/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.helper;

import java.io.File;

public abstract class FilenameUtil {
    public static boolean isXslFile(String filename) {
        return FilenameUtil.endsWithExtension(filename, ".xsl", ".xslt");
    }

    public static boolean isXqueryFile(String filename) {
        return FilenameUtil.endsWithExtension(filename, ".xqy", ".xqy");
    }

    public static boolean isJavascriptFile(String filename) {
        return FilenameUtil.endsWithExtension(filename, ".sjs", ".js");
    }

    public static boolean endsWithExtension(String filename, String ... extensions) {
        if (filename == null || extensions == null) {
            return false;
        }
        filename = filename.toLowerCase();
        for (String extension : extensions) {
            if (extension == null || !filename.endsWith(extension.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static String getFileExtension(File f) {
        String[] split = f.getName().split("\\.");
        if (split.length > 1) {
            return split[1];
        }
        return null;
    }
}

