/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.rest.util;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;

public class Fragment {
    private Document internalDoc;
    private Namespace[] namespaces;

    public Fragment(Fragment other) {
        this.internalDoc = other.internalDoc;
        this.namespaces = other.namespaces;
    }

    public Fragment(String xml, Namespace ... namespaces) {
        try {
            this.internalDoc = new SAXBuilder().build((Reader)new StringReader(xml));
            ArrayList<Namespace> list = new ArrayList<Namespace>();
            list.add(Namespace.getNamespace((String)"arp", (String)"http://marklogic.com/manage/alert-rule/properties"));
            list.add(Namespace.getNamespace((String)"c", (String)"http://marklogic.com/manage/clusters"));
            list.add(Namespace.getNamespace((String)"cert", (String)"http://marklogic.com/xdmp/x509"));
            list.add(Namespace.getNamespace((String)"cts", (String)"http://marklogic.com/cts"));
            list.add(Namespace.getNamespace((String)"db", (String)"http://marklogic.com/manage/databases"));
            list.add(Namespace.getNamespace((String)"es", (String)"http://marklogic.com/entity-services"));
            list.add(Namespace.getNamespace((String)"f", (String)"http://marklogic.com/manage/forests"));
            list.add(Namespace.getNamespace((String)"g", (String)"http://marklogic.com/manage/groups"));
            list.add(Namespace.getNamespace((String)"h", (String)"http://marklogic.com/manage/hosts"));
            list.add(Namespace.getNamespace((String)"m", (String)"http://marklogic.com/manage"));
            list.add(Namespace.getNamespace((String)"msec", (String)"http://marklogic.com/manage/security"));
            list.add(Namespace.getNamespace((String)"pki", (String)"http://marklogic.com/xdmp/pki"));
            list.add(Namespace.getNamespace((String)"req", (String)"http://marklogic.com/manage/requests"));
            list.add(Namespace.getNamespace((String)"qr", (String)"http://marklogic.com/manage/query-roleset/properties"));
            list.add(Namespace.getNamespace((String)"s", (String)"http://marklogic.com/manage/servers"));
            list.add(Namespace.getNamespace((String)"sec", (String)"http://marklogic.com/xdmp/security"));
            list.add(Namespace.getNamespace((String)"ts", (String)"http://marklogic.com/manage/task-server"));
            list.add(Namespace.getNamespace((String)"t", (String)"http://marklogic.com/manage/tasks"));
            list.add(Namespace.getNamespace((String)"creds", (String)"http://marklogic.com/manage/credentials/properties"));
            list.addAll(Arrays.asList(namespaces));
            this.namespaces = list.toArray(new Namespace[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Unable to parse XML, cause: %s; XML: %s", e.getMessage(), xml), e);
        }
    }

    public void prettyPrint() {
        System.out.println(this.getPrettyXml());
    }

    public String getPrettyXml() {
        return new XMLOutputter(Format.getPrettyFormat()).outputString(this.internalDoc);
    }

    public boolean elementExists(String xpath) {
        return this.evaluateForElements(xpath).size() > 0;
    }

    public List<String> getElementValues(String xpath) {
        ArrayList<String> values = new ArrayList<String>();
        for (Element el : this.evaluateForElements(xpath)) {
            values.add(el.getText());
        }
        return values;
    }

    public String getElementValue(String xpath) {
        List<String> values = this.getElementValues(xpath);
        return values.isEmpty() ? null : values.get(0);
    }

    public List<Element> getElements(String xpath) {
        return this.evaluateForElements(xpath);
    }

    protected List<Element> evaluateForElements(String xpath) {
        XPathFactory f = XPathFactory.instance();
        XPathExpression expr = f.compile(xpath, Filters.element(), new HashMap(), this.namespaces);
        return expr.evaluate((Object)this.internalDoc);
    }

    public Document getInternalDoc() {
        return this.internalDoc;
    }
}

