/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.resource.taskservers;

import com.marklogic.mgmt.AbstractManager;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.admin.AdminManager;
import com.marklogic.rest.util.Fragment;
import org.springframework.http.ResponseEntity;

public class TaskServerManager
extends AbstractManager {
    private ManageClient manageClient;

    public TaskServerManager(ManageClient manageClient) {
        this.manageClient = manageClient;
    }

    public void updateTaskServer(String taskServerName, String payload, AdminManager adminManager) {
        String path = this.format("/manage/v2/task-servers/%s/properties", new Object[]{taskServerName});
        ResponseEntity<String> response = this.payloadParser.isJsonPayload(payload) ? this.manageClient.putJson(path, payload) : this.manageClient.putXml(path, payload);
        if (response != null && response.getHeaders().getLocation() != null && adminManager != null) {
            adminManager.waitForRestart();
        }
    }

    public Fragment getPropertiesAsXml() {
        return this.getPropertiesAsXml("TaskServer");
    }

    public Fragment getPropertiesAsXml(String taskServerName) {
        return this.manageClient.getXml(this.format("/manage/v2/task-servers/%s/properties", new Object[]{taskServerName}), new String[0]);
    }
}

