/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.resource.security;

import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.SaveReceipt;
import com.marklogic.mgmt.api.API;
import com.marklogic.mgmt.api.security.Role;
import com.marklogic.mgmt.mapper.DefaultResourceMapper;
import com.marklogic.mgmt.mapper.ResourceMapper;
import com.marklogic.mgmt.resource.AbstractResourceManager;

public class RoleManager
extends AbstractResourceManager {
    private ResourceMapper resourceMapper;

    public RoleManager(ManageClient client) {
        super(client);
    }

    @Override
    protected boolean useSecurityUser() {
        return true;
    }

    @Override
    protected SaveReceipt createNewResource(String payload, String resourceId) {
        Role role;
        if (this.resourceMapper == null) {
            API api = new API(this.getManageClient());
            this.resourceMapper = new DefaultResourceMapper(api);
        }
        if ((role = this.resourceMapper.readResource(payload, Role.class)).hasPermissionWithOwnRoleName()) {
            role.getPermission().clear();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Creating role '" + resourceId + "' that has permissions that refer to itself, so first creating role without permissions, and then updating role with permissions");
            }
            SaveReceipt receipt = super.createNewResource(role.getJson(), resourceId);
            super.updateResource(payload, resourceId);
            return receipt;
        }
        return super.createNewResource(payload, resourceId);
    }
}

