/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.resource.security;

import com.marklogic.mgmt.DeleteReceipt;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.resource.AbstractResourceManager;

public class CredentialsManager
extends AbstractResourceManager {
    public CredentialsManager(ManageClient client) {
        super(client, true);
    }

    @Override
    public String getResourcesPath() {
        return "/manage/v2/credentials/properties";
    }

    @Override
    protected String getIdFieldName() {
        return "type";
    }

    @Override
    protected String getResourceId(String payload) {
        return this.getCredentialsType(payload);
    }

    @Override
    public DeleteReceipt delete(String payload, String ... resourceUrlParams) {
        String type = this.getCredentialsType(payload);
        String path = "/manage/v2/credentials/properties?type=" + type;
        super.deleteAtPath(path, "Content-type", "application/json");
        return new DeleteReceipt(type, path, true);
    }

    private String getCredentialsType(String payload) {
        if (this.payloadParser.isJsonPayload(payload)) {
            return this.payloadParser.getPayloadFieldValue(payload, this.getIdFieldName());
        }
        return this.payloadParser.getPayloadFieldValue(payload, "azure", false) != null ? "azure" : "aws";
    }
}

