/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.resource.forests;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.api.API;
import com.marklogic.mgmt.api.forest.Forest;
import com.marklogic.mgmt.cma.ConfigurationManager;
import com.marklogic.mgmt.mapper.DefaultResourceMapper;
import com.marklogic.mgmt.resource.AbstractResourceManager;
import com.marklogic.mgmt.resource.forests.ForestStatus;
import com.marklogic.rest.util.Fragment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ForestManager
extends AbstractResourceManager {
    public static final String DELETE_LEVEL_FULL = "full";
    public static final String DELETE_LEVEL_CONFIG_ONLY = "config-only";
    public static final String REPLICAS_DETACH = "detach";
    public static final String REPLICAS_DELETE = "delete";
    private String deleteLevel = "full";
    private int deleteRetryAttempts = 3;
    private long deleteSleepPeriod = 500L;

    public ForestManager(ManageClient client) {
        super(client);
        this.setUpdateAllowed(false);
    }

    public Map<String, List<Forest>> getMapOfPrimaryForests() {
        JsonNode json = (JsonNode)new ConfigurationManager(this.getManageClient()).getResourcesAsJson("forest").getBody();
        ArrayNode allPrimaryForests = (ArrayNode)json.get("config").get(0).get("forest");
        DefaultResourceMapper mapper = new DefaultResourceMapper(new API(this.getManageClient()));
        HashMap<String, List<Forest>> mapOfPrimaryForests = new HashMap<String, List<Forest>>();
        allPrimaryForests.iterator().forEachRemaining(forest -> {
            if (forest.has("database")) {
                String db = forest.get("database").asText();
                ArrayList<Forest> databaseForests = (ArrayList<Forest>)mapOfPrimaryForests.get(db);
                if (databaseForests == null) {
                    databaseForests = new ArrayList<Forest>();
                    mapOfPrimaryForests.put(db, databaseForests);
                }
                databaseForests.add(mapper.readResource(forest.toString(), Forest.class));
            }
        });
        return mapOfPrimaryForests;
    }

    public void createJsonForestWithName(String name, String host) {
        if (this.forestExists(name)) {
            this.logger.info(this.format("Forest already exists with name, so not creating: %s", new Object[]{name}));
        } else {
            this.logger.info(this.format("Creating forest %s on host %s", new Object[]{name, host}));
            this.createJsonForest(this.format("{\"forest-name\":\"%s\", \"host\":\"%s\"}", new Object[]{name, host}));
            this.logger.info(this.format("Created forest %s on host %s", new Object[]{name, host}));
        }
    }

    public void delete(String nameOrId, String level) {
        this.delete(nameOrId, level, REPLICAS_DELETE);
    }

    public void delete(String nameOrId, String level, String replicas) {
        if (!this.forestExists(nameOrId)) {
            this.logger.info(this.format("Could not find forest with name or ID: %s, so not deleting", new Object[]{nameOrId}));
        } else {
            this.logger.info(this.format("Deleting forest %s", new Object[]{nameOrId}));
            String path = this.format("/manage/v2/forests/%s?level=%s&replicas=%s", new Object[]{nameOrId, level, replicas});
            this.deleteWithRetry(path, this.deleteRetryAttempts);
            this.logger.info(this.format("Deleted forest %s", new Object[]{nameOrId}));
        }
    }

    public void deleteWithRetry(String path, int attemptsLeft) {
        try {
            this.getManageClient().delete(path, new String[0]);
        }
        catch (Exception e) {
            if (attemptsLeft > 0) {
                try {
                    this.logger.warn("Unable to delete forest; will wait " + this.deleteSleepPeriod + "ms, then retry at path: " + path);
                    Thread.sleep(this.deleteSleepPeriod);
                    this.deleteWithRetry(path, --attemptsLeft);
                }
                catch (InterruptedException interruptedException) {}
            }
            throw e;
        }
    }

    public void saveJsonForests(String json) {
        JsonNode node = this.payloadParser.parseJson(json);
        if (node.isArray()) {
            Iterator iter = node.iterator();
            while (iter.hasNext()) {
                this.save(((JsonNode)iter.next()).toString());
            }
        } else {
            this.save(json);
        }
    }

    public void createJsonForest(String json) {
        this.getManageClient().postJson("/manage/v2/forests", json);
    }

    public boolean forestExists(String nameOrId) {
        Fragment f = this.getManageClient().getXml("/manage/v2/forests", new String[0]);
        return f.elementExists(this.format("/node()/f:list-items/f:list-item[f:nameref = '%s' or f:idref = '%s']", new Object[]{nameOrId, nameOrId}));
    }

    public void attachForest(String forestIdOrName, String databaseIdOrName) {
        if (this.isForestAttached(forestIdOrName)) {
            this.logger.info(this.format("Forest %s is already attached to a database, not attaching", new Object[]{forestIdOrName}));
            return;
        }
        this.logger.info(this.format("Attaching forest %s to database %s", new Object[]{forestIdOrName, databaseIdOrName}));
        String path = this.format("/manage/v2/forests/%s", new Object[]{forestIdOrName});
        this.getManageClient().postForm(path, "state", "attach", "database", databaseIdOrName);
        this.logger.info(this.format("Attached forest %s to database %s", new Object[]{forestIdOrName, databaseIdOrName}));
    }

    public boolean isForestAttached(String forestIdOrName) {
        Fragment f = this.getManageClient().getXml(this.format("/manage/v2/forests/%s", new Object[]{forestIdOrName}), new String[0]);
        return f.elementExists("/node()/f:relations/f:relation-group[f:typeref = 'databases']");
    }

    public String getHostId(String forestIdOrName) {
        Fragment f = this.getManageClient().getXml(this.format("/manage/v2/forests/%s", new Object[]{forestIdOrName}), new String[0]);
        return f.getElementValue("/node()/f:relations/f:relation-group[f:typeref = 'hosts']/f:relation/f:idref");
    }

    public void setReplicas(String forestIdOrName, Map<String, String> replicaNamesAndHostIds) {
        StringBuilder json = new StringBuilder("{\"forest-replica\":[");
        boolean firstOne = true;
        for (String replicaName : replicaNamesAndHostIds.keySet()) {
            if (!firstOne) {
                json.append(",");
            }
            String hostId = replicaNamesAndHostIds.get(replicaName);
            json.append(this.format("{\"replica-name\":\"%s\", \"host\":\"%s\"}", new Object[]{replicaName, hostId}));
            firstOne = false;
        }
        json.append("]}");
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.format("Setting replicas for forest %s, JSON: %s", new Object[]{forestIdOrName, json.toString()}));
        }
        this.getManageClient().putJson(this.getPropertiesPath(forestIdOrName, new String[0]), json.toString());
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.format("Finished setting replicas for forest %s", new Object[]{forestIdOrName}));
        }
    }

    public void setReplicasToNone(String forestIdOrName) {
        this.setReplicas(forestIdOrName, new HashMap<String, String>());
    }

    public List<String> getReplicaIds(String forestIdOrName) {
        String path = this.getResourcePath(forestIdOrName, "view", "config", "format", "xml");
        return this.getManageClient().getXml(path, new String[0]).getElementValues("/f:forest-config/f:config-properties/f:forest-replicas/f:forest-replica");
    }

    public void deleteReplicas(String forestIdOrName) {
        List<String> replicaIds = this.getReplicaIds(forestIdOrName);
        if (replicaIds.isEmpty()) {
            this.logger.info(this.format("Forest '%s' has no replicas, so not deleting anything", new Object[]{forestIdOrName}));
            return;
        }
        this.setReplicasToNone(forestIdOrName);
        for (String id : replicaIds) {
            this.delete(id, DELETE_LEVEL_FULL);
        }
    }

    public ForestStatus getForestStatus(String forestIdOrName) {
        String path = this.getResourcePath(forestIdOrName, "view", "status", "format", "xml");
        return new ForestStatus(this.getManageClient().getXml(path, new String[0]));
    }

    public void setUpdatesAllowed(String forestIdOrName, String mode) {
        String path = this.getPropertiesPath(forestIdOrName, new String[0]);
        String json = this.format("{\"updates-allowed\":\"%s\"}", new Object[]{mode});
        this.getManageClient().putJson(path, json);
    }

    @Override
    protected String[] getDeleteResourceParams(String payload) {
        String[] stringArray;
        if (this.deleteLevel != null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "level";
            stringArray = stringArray2;
            stringArray2[1] = this.deleteLevel;
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    public String getDeleteLevel() {
        return this.deleteLevel;
    }

    public void setDeleteLevel(String deleteLevel) {
        this.deleteLevel = deleteLevel;
    }

    public void setDeleteRetryAttempts(int deleteRetryAttempts) {
        this.deleteRetryAttempts = deleteRetryAttempts;
    }

    public void setDeleteSleepPeriod(long deleteSleepPeriod) {
        this.deleteSleepPeriod = deleteSleepPeriod;
    }
}

