/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.resource.flexrep;

import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.resource.AbstractResourceManager;
import com.marklogic.mgmt.resource.flexrep.TargetManager;
import com.marklogic.rest.util.Fragment;

public class ConfigManager
extends AbstractResourceManager {
    private String databaseIdOrName;

    public ConfigManager(ManageClient client, String databaseIdOrName) {
        super(client);
        this.databaseIdOrName = databaseIdOrName;
    }

    @Override
    public String getResourcesPath() {
        return this.format("/manage/v2/databases/%s/flexrep/configs", new Object[]{this.databaseIdOrName});
    }

    @Override
    protected String getIdFieldName() {
        return "domain-name";
    }

    public void deleteAllConfigs() {
        for (String nameref : this.getAsXml().getListItemNameRefs()) {
            TargetManager mgr = new TargetManager(this.getManageClient(), this.databaseIdOrName, nameref);
            for (String idref : mgr.getAsXml().getListItemIdRefs()) {
                mgr.deleteByIdField(idref, new String[0]);
            }
            this.deleteByIdField(nameref, new String[0]);
        }
    }

    public void disableAllFlexrepTargets() {
        for (String nameref : this.getAsXml().getListItemNameRefs()) {
            new TargetManager(this.getManageClient(), this.databaseIdOrName, nameref).disableAllTargets();
        }
    }

    public void enableAllFlexrepTargets() {
        for (String nameref : this.getAsXml().getListItemNameRefs()) {
            new TargetManager(this.getManageClient(), this.databaseIdOrName, nameref).enableAllTargets();
        }
    }

    public String getDomainId(String configName) {
        Fragment f = this.getManageClient().getXml(this.getResourcesPath() + "/" + configName, new String[0]);
        return f.getElementValue("/node()/db:id");
    }
}

