/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.api.database;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.marklogic.mgmt.api.API;
import com.marklogic.mgmt.api.Resource;
import com.marklogic.mgmt.api.database.AssignmentPolicy;
import com.marklogic.mgmt.api.database.DatabaseBackup;
import com.marklogic.mgmt.api.database.DatabaseReference;
import com.marklogic.mgmt.api.database.DatabaseReplication;
import com.marklogic.mgmt.api.database.DefaultRuleset;
import com.marklogic.mgmt.api.database.Element;
import com.marklogic.mgmt.api.database.ElementAttributeIndex;
import com.marklogic.mgmt.api.database.ElementAttributeWordLexicon;
import com.marklogic.mgmt.api.database.ElementIndex;
import com.marklogic.mgmt.api.database.ElementWordLexicon;
import com.marklogic.mgmt.api.database.Field;
import com.marklogic.mgmt.api.database.FieldIndex;
import com.marklogic.mgmt.api.database.FragmentParent;
import com.marklogic.mgmt.api.database.FragmentRoot;
import com.marklogic.mgmt.api.database.GeospatialElementChildIndex;
import com.marklogic.mgmt.api.database.GeospatialElementIndex;
import com.marklogic.mgmt.api.database.GeospatialElementPairIndex;
import com.marklogic.mgmt.api.database.GeospatialPathIndex;
import com.marklogic.mgmt.api.database.GeospatialRegionPathIndex;
import com.marklogic.mgmt.api.database.MergeBlackout;
import com.marklogic.mgmt.api.database.PathIndex;
import com.marklogic.mgmt.api.database.PathNamespace;
import com.marklogic.mgmt.api.forest.Forest;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.databases.DatabaseManager;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.springframework.util.StringUtils;

@XmlRootElement(name="database-properties")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Database
extends Resource {
    @XmlElement(name="database-name")
    private String databaseName;
    @XmlElementWrapper(name="forests")
    private List<String> forest;
    @XmlElement(name="security-database")
    private String securityDatabase;
    @XmlElement(name="schema-database")
    private String schemaDatabase;
    @XmlElement(name="triggers-database")
    private String triggersDatabase;
    private Boolean enabled;
    @XmlElement(name="retired-forest-count")
    private Integer retiredForestCount;
    private String language;
    @XmlElement(name="stemmed-searches")
    private String stemmedSearches;
    @XmlElement(name="word-searches")
    private Boolean wordSearches;
    @XmlElement(name="word-positions")
    private Boolean wordPositions;
    @XmlElement(name="fast-phrase-searches")
    private Boolean fastPhraseSearches;
    @XmlElement(name="fast-reverse-searches")
    private Boolean fastReverseSearches;
    @XmlElement(name="triple-index")
    private Boolean tripleIndex;
    @XmlElement(name="triple-positions")
    private Boolean triplePositions;
    @XmlElement(name="fast-case-sensitive-searches")
    private Boolean fastCaseSensitiveSearches;
    @XmlElement(name="fast-diacritic-sensitive-searches")
    private Boolean fastDiacriticSensitiveSearches;
    @XmlElement(name="fast-element-word-searches")
    private Boolean fastElementWordSearches;
    @XmlElement(name="element-word-positions")
    private Boolean elementWordPositions;
    @XmlElement(name="fast-element-phrase-searches")
    private Boolean fastElementPhraseSearches;
    @XmlElement(name="element-value-positions")
    private Boolean elementValuePositions;
    @XmlElement(name="attribute-value-positions")
    private Boolean attributeValuePositions;
    @XmlElement(name="field-value-searches")
    private Boolean fieldValueSearches;
    @XmlElement(name="field-value-positions")
    private Boolean fieldValuePositions;
    @XmlElement(name="three-character-searches")
    private Boolean threeCharacterSearches;
    @XmlElement(name="three-character-word-positions")
    private Boolean threeCharacterWordPositions;
    @XmlElement(name="fast-element-character-searches")
    private Boolean fastElementCharacterSearches;
    @XmlElement(name="trailing-wildcard-searches")
    private Boolean trailingWildcardSearches;
    @XmlElement(name="trailing-wildcard-word-positions")
    private Boolean trailingWildcardWordPositions;
    @XmlElement(name="fast-element-trailing-wildcard-searches")
    private Boolean fastElementTrailingWildcardSearches;
    @XmlElement(name="two-character-searches")
    private Boolean twoCharacterSearches;
    @XmlElement(name="one-character-searches")
    private Boolean oneCharacterSearches;
    @XmlElement(name="uri-lexicon")
    private Boolean uriLexicon;
    @XmlElement(name="collection-lexicon")
    private Boolean collectionLexicon;
    @XmlElement(name="reindexer-enable")
    private Boolean reindexerEnable;
    @XmlElement(name="reindexer-throttle")
    private Integer reindexerThrottle;
    @XmlElement(name="reindexer-timestamp")
    private Long reindexerTimestamp;
    @XmlElement(name="directory-creation")
    private String directoryCreation;
    @XmlElement(name="maintain-last-modified")
    private Boolean maintainLastModified;
    @XmlElement(name="maintain-directory-last-modified")
    private Boolean maintainDirectoryLastModified;
    @XmlElement(name="inherit-permissions")
    private Boolean inheritPermissions;
    @XmlElement(name="inherit-collections")
    private Boolean inheritCollections;
    @XmlElement(name="inherit-quality")
    private Boolean inheritQuality;
    @XmlElement(name="in-memory-limit")
    private Long inMemoryLimit;
    @XmlElement(name="in-memory-list-size")
    private Long inMemoryListSize;
    @XmlElement(name="in-memory-tree-size")
    private Long inMemoryTreeSize;
    @XmlElement(name="in-memory-range-index-size")
    private Long inMemoryRangeIndexSize;
    @XmlElement(name="in-memory-reverse-index-size")
    private Long inMemoryReverseIndexSize;
    @XmlElement(name="in-memory-triple-index-size")
    private Long inMemoryTripleIndexSize;
    @XmlElement(name="large-size-threshold")
    private Long largeSizeThreshold;
    @XmlElement(name="locking")
    private String locking;
    @XmlElement(name="journaling")
    private String journaling;
    @XmlElement(name="journal-size")
    private Long journalSize;
    @XmlElement(name="journal-count")
    private Integer journalCount;
    @XmlElement(name="preallocate-journals")
    private Boolean preallocateJournals;
    @XmlElement(name="preload-mapped-data")
    private Boolean preloadMappedData;
    @XmlElement(name="preload-replica-mapped-data")
    private Boolean preloadReplicaMappedData;
    @XmlElement(name="range-index-optimize")
    private String rangeIndexOptimize;
    @XmlElement(name="positions-list-max-size")
    private Long positionsListMaxSize;
    @XmlElement(name="format-compatibility")
    private String formatCompatibility;
    @XmlElement(name="index-detection")
    private String indexDetection;
    @XmlElement(name="expunge-locks")
    private String expungeLocks;
    @XmlElement(name="tf-normalization")
    private String tfNormalization;
    @XmlElement(name="merge-priority")
    private String mergePriority;
    @XmlElement(name="merge-max-size")
    private Long mergeMaxSize;
    @XmlElement(name="merge-min-size")
    private Long mergeMinSize;
    @XmlElement(name="merge-min-ratio")
    private Integer mergeMinRatio;
    @XmlElement(name="merge-timestamp")
    private Long mergeTimestamp;
    @XmlElement(name="retain-until-backup")
    private Boolean retainUntilBackup;
    @XmlElementWrapper(name="merge-blackouts")
    @XmlElement(name="merge-blackout")
    private List<MergeBlackout> mergeBlackout;
    @XmlElementWrapper(name="database-backups")
    @XmlElement(name="database-backup")
    private List<DatabaseBackup> databaseBackup;
    @XmlElementWrapper(name="fragment-roots")
    @XmlElement(name="fragment-root")
    private List<FragmentRoot> fragmentRoot;
    @XmlElementWrapper(name="fragment-parents")
    @XmlElement(name="fragment-parent")
    private List<FragmentParent> fragmentParent;
    @XmlElementWrapper(name="element-word-query-throughs")
    @XmlElement(name="element-word-query-through")
    private List<Element> elementWordQueryThrough;
    @XmlElementWrapper(name="phrase-throughs")
    @XmlElement(name="phrase-through")
    private List<Element> phraseThrough;
    @XmlElementWrapper(name="phrase-arounds")
    @XmlElement(name="phrase-around")
    private List<Element> phraseAround;
    @XmlElementWrapper(name="range-element-indexes")
    @XmlElement(name="range-element-index")
    private List<ElementIndex> rangeElementIndex;
    @XmlElementWrapper(name="range-element-attribute-indexes")
    @XmlElement(name="range-element-attribute-index")
    private List<ElementAttributeIndex> rangeElementAttributeIndex;
    @XmlElementWrapper(name="element-word-lexicons")
    @XmlElement(name="element-word-lexicon")
    private List<ElementWordLexicon> elementWordLexicon;
    @XmlElementWrapper(name="element-attribute-word-lexicons")
    @XmlElement(name="element-attribute-word-lexicon")
    private List<ElementAttributeWordLexicon> elementAttributeWordLexicon;
    @XmlElementWrapper(name="path-namespaces")
    @XmlElement(name="path-namespace")
    private List<PathNamespace> pathNamespace;
    @XmlElementWrapper(name="range-path-indexes")
    @XmlElement(name="range-path-index")
    private List<PathIndex> rangePathIndex;
    @XmlElementWrapper(name="fields")
    private List<Field> field;
    @XmlElementWrapper(name="range-field-indexes")
    @XmlElement(name="range-field-index")
    private List<FieldIndex> rangeFieldIndex;
    @XmlElementWrapper(name="geospatial-element-indexes")
    @XmlElement(name="geospatial-element-index")
    private List<GeospatialElementIndex> geospatialElementIndex;
    @XmlElementWrapper(name="geospatial-element-child-indexes")
    @XmlElement(name="geospatial-element-child-index")
    private List<GeospatialElementChildIndex> geospatialElementChildIndex;
    @XmlElementWrapper(name="geospatial-element-pair-indexes")
    @XmlElement(name="geospatial-element-pair-index")
    private List<GeospatialElementPairIndex> geospatialElementPairIndex;
    @XmlElementWrapper(name="geospatial-element-attribute-pair-indexes")
    @XmlElement(name="geospatial-element-attribute-pair-index")
    private List<GeospatialElementPairIndex> geospatialElementAttributePairIndex;
    @XmlElementWrapper(name="geospatial-path-indexes")
    @XmlElement(name="geospatial-path-index")
    private List<GeospatialPathIndex> geospatialPathIndex;
    @XmlElementWrapper(name="geospatial-region-path-indexes")
    @XmlElement(name="geospatial-region-path-index")
    private List<GeospatialRegionPathIndex> geospatialRegionPathIndex;
    @XmlElementWrapper(name="default-rulesets")
    @XmlElement(name="default-ruleset")
    private List<DefaultRuleset> defaultRuleset;
    @XmlElement(name="database-replication")
    private DatabaseReplication databaseReplication;
    @XmlElementWrapper(name="database-references")
    @XmlElement(name="database-reference")
    private List<DatabaseReference> databaseReference;
    @XmlElement(name="rebalancer-enable")
    private Boolean rebalancerEnable;
    @XmlElement(name="rebalancer-throttle")
    private Integer rebalancerThrottle;
    @XmlElement(name="assignment-policy")
    private AssignmentPolicy assignmentPolicy;

    public Database() {
    }

    public Database(API api, String databaseName) {
        super(api);
        this.databaseName = databaseName;
    }

    @Override
    protected String getResourceLabel() {
        return this.getDatabaseName();
    }

    @Override
    protected ResourceManager getResourceManager() {
        return new DatabaseManager(this.getClient());
    }

    @Override
    protected String getResourceId() {
        return this.databaseName;
    }

    public void addForest(Forest f) {
        this.addForest(f.getForestName());
    }

    public void addForest(String forestName) {
        if (this.forest == null) {
            this.forest = new ArrayList<String>();
        }
        this.forest.add(forestName);
    }

    public void clear() {
        new DatabaseManager(this.getClient()).clearDatabase(this.databaseName);
    }

    public void attach(Forest f) {
        this.attach(f.getForestName());
    }

    public void attach(String forestName) {
        if (this.forest == null) {
            this.forest = new ArrayList<String>();
        }
        this.forest.add(forestName);
        this.save();
    }

    public Forest attachNewForest(String forestName) {
        Forest f = this.getApi().forest(forestName);
        f.save();
        this.attach(f);
        return f;
    }

    public void detach(Forest f) {
        this.detach(f.getForestName());
    }

    public void detach(String forestName) {
        if (this.forest == null || !this.forest.contains(forestName)) {
            this.getLogger().warn(this.format("Forest %s not in list of known forests for database, so not detaching", new Object[0]));
        } else {
            this.forest.remove(forestName);
            this.save();
        }
    }

    @JsonIgnore
    public List<String> getDatabaseDependencyNames() {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.hasText((String)this.schemaDatabase)) {
            list.add(this.schemaDatabase);
        }
        if (StringUtils.hasText((String)this.triggersDatabase)) {
            list.add(this.triggersDatabase);
        }
        if (StringUtils.hasText((String)this.securityDatabase)) {
            list.add(this.securityDatabase);
        }
        return list;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public List<String> getForest() {
        return this.forest;
    }

    public void setForest(List<String> forest) {
        this.forest = forest;
    }

    public List<ElementIndex> getRangeElementIndex() {
        return this.rangeElementIndex;
    }

    public void setRangeElementIndex(List<ElementIndex> elementIndexes) {
        this.rangeElementIndex = elementIndexes;
    }

    public String getSecurityDatabase() {
        return this.securityDatabase;
    }

    public void setSecurityDatabase(String securityDatabase) {
        this.securityDatabase = securityDatabase;
    }

    public String getSchemaDatabase() {
        return this.schemaDatabase;
    }

    public void setSchemaDatabase(String schemaDatabase) {
        this.schemaDatabase = schemaDatabase;
    }

    public String getTriggersDatabase() {
        return this.triggersDatabase;
    }

    public void setTriggersDatabase(String triggersDatabase) {
        this.triggersDatabase = triggersDatabase;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Integer getRetiredForestCount() {
        return this.retiredForestCount;
    }

    public void setRetiredForestCount(Integer retiredForestCount) {
        this.retiredForestCount = retiredForestCount;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getStemmedSearches() {
        return this.stemmedSearches;
    }

    public void setStemmedSearches(String stemmedSearches) {
        this.stemmedSearches = stemmedSearches;
    }

    public Boolean getWordSearches() {
        return this.wordSearches;
    }

    public void setWordSearches(Boolean wordSearches) {
        this.wordSearches = wordSearches;
    }

    public Boolean getWordPositions() {
        return this.wordPositions;
    }

    public void setWordPositions(Boolean wordPositions) {
        this.wordPositions = wordPositions;
    }

    public Boolean getFastPhraseSearches() {
        return this.fastPhraseSearches;
    }

    public void setFastPhraseSearches(Boolean fastPhraseSearches) {
        this.fastPhraseSearches = fastPhraseSearches;
    }

    public Boolean getFastReverseSearches() {
        return this.fastReverseSearches;
    }

    public void setFastReverseSearches(Boolean fastReverseSearches) {
        this.fastReverseSearches = fastReverseSearches;
    }

    public Boolean getTripleIndex() {
        return this.tripleIndex;
    }

    public void setTripleIndex(Boolean tripleIndex) {
        this.tripleIndex = tripleIndex;
    }

    public Boolean getTriplePositions() {
        return this.triplePositions;
    }

    public void setTriplePositions(Boolean triplePositions) {
        this.triplePositions = triplePositions;
    }

    public Boolean getFastCaseSensitiveSearches() {
        return this.fastCaseSensitiveSearches;
    }

    public void setFastCaseSensitiveSearches(Boolean fastCaseSensitiveSearches) {
        this.fastCaseSensitiveSearches = fastCaseSensitiveSearches;
    }

    public Boolean getFastDiacriticSensitiveSearches() {
        return this.fastDiacriticSensitiveSearches;
    }

    public void setFastDiacriticSensitiveSearches(Boolean fastDiacriticSensitiveSearches) {
        this.fastDiacriticSensitiveSearches = fastDiacriticSensitiveSearches;
    }

    public Boolean getFastElementWordSearches() {
        return this.fastElementWordSearches;
    }

    public void setFastElementWordSearches(Boolean fastElementWordSearches) {
        this.fastElementWordSearches = fastElementWordSearches;
    }

    public Boolean getElementWordPositions() {
        return this.elementWordPositions;
    }

    public void setElementWordPositions(Boolean elementWordPositions) {
        this.elementWordPositions = elementWordPositions;
    }

    public Boolean getFastElementPhraseSearches() {
        return this.fastElementPhraseSearches;
    }

    public void setFastElementPhraseSearches(Boolean fastElementPhraseSearches) {
        this.fastElementPhraseSearches = fastElementPhraseSearches;
    }

    public Boolean getElementValuePositions() {
        return this.elementValuePositions;
    }

    public void setElementValuePositions(Boolean elementValuePositions) {
        this.elementValuePositions = elementValuePositions;
    }

    public Boolean getAttributeValuePositions() {
        return this.attributeValuePositions;
    }

    public void setAttributeValuePositions(Boolean attributeValuePositions) {
        this.attributeValuePositions = attributeValuePositions;
    }

    public Boolean getFieldValueSearches() {
        return this.fieldValueSearches;
    }

    public void setFieldValueSearches(Boolean fieldValueSearches) {
        this.fieldValueSearches = fieldValueSearches;
    }

    public Boolean getFieldValuePositions() {
        return this.fieldValuePositions;
    }

    public void setFieldValuePositions(Boolean fieldValuePositions) {
        this.fieldValuePositions = fieldValuePositions;
    }

    public Boolean getThreeCharacterSearches() {
        return this.threeCharacterSearches;
    }

    public void setThreeCharacterSearches(Boolean threeCharacterSearches) {
        this.threeCharacterSearches = threeCharacterSearches;
    }

    public Boolean getThreeCharacterWordPositions() {
        return this.threeCharacterWordPositions;
    }

    public void setThreeCharacterWordPositions(Boolean threeCharacterWordPositions) {
        this.threeCharacterWordPositions = threeCharacterWordPositions;
    }

    public Boolean getFastElementCharacterSearches() {
        return this.fastElementCharacterSearches;
    }

    public void setFastElementCharacterSearches(Boolean fastElementCharacterSearches) {
        this.fastElementCharacterSearches = fastElementCharacterSearches;
    }

    public Boolean getTrailingWildcardSearches() {
        return this.trailingWildcardSearches;
    }

    public void setTrailingWildcardSearches(Boolean trailingWildcardSearches) {
        this.trailingWildcardSearches = trailingWildcardSearches;
    }

    public Boolean getTrailingWildcardWordPositions() {
        return this.trailingWildcardWordPositions;
    }

    public void setTrailingWildcardWordPositions(Boolean trailingWildcardWordPositions) {
        this.trailingWildcardWordPositions = trailingWildcardWordPositions;
    }

    public Boolean getFastElementTrailingWildcardSearches() {
        return this.fastElementTrailingWildcardSearches;
    }

    public void setFastElementTrailingWildcardSearches(Boolean fastElementTrailingWildcardSearches) {
        this.fastElementTrailingWildcardSearches = fastElementTrailingWildcardSearches;
    }

    public Boolean getTwoCharacterSearches() {
        return this.twoCharacterSearches;
    }

    public void setTwoCharacterSearches(Boolean twoCharacterSearches) {
        this.twoCharacterSearches = twoCharacterSearches;
    }

    public Boolean getOneCharacterSearches() {
        return this.oneCharacterSearches;
    }

    public void setOneCharacterSearches(Boolean oneCharacterSearches) {
        this.oneCharacterSearches = oneCharacterSearches;
    }

    public Boolean getUriLexicon() {
        return this.uriLexicon;
    }

    public void setUriLexicon(Boolean uriLexicon) {
        this.uriLexicon = uriLexicon;
    }

    public Boolean getCollectionLexicon() {
        return this.collectionLexicon;
    }

    public void setCollectionLexicon(Boolean collectionLexicon) {
        this.collectionLexicon = collectionLexicon;
    }

    public Boolean getReindexerEnable() {
        return this.reindexerEnable;
    }

    public void setReindexerEnable(Boolean reindexerEnable) {
        this.reindexerEnable = reindexerEnable;
    }

    public Integer getReindexerThrottle() {
        return this.reindexerThrottle;
    }

    public void setReindexerThrottle(Integer reindexerThrottle) {
        this.reindexerThrottle = reindexerThrottle;
    }

    public Long getReindexerTimestamp() {
        return this.reindexerTimestamp;
    }

    public void setReindexerTimestamp(Long reindexerTimestamp) {
        this.reindexerTimestamp = reindexerTimestamp;
    }

    public String getDirectoryCreation() {
        return this.directoryCreation;
    }

    public void setDirectoryCreation(String directoryCreation) {
        this.directoryCreation = directoryCreation;
    }

    public Boolean getMaintainLastModified() {
        return this.maintainLastModified;
    }

    public void setMaintainLastModified(Boolean maintainLastModified) {
        this.maintainLastModified = maintainLastModified;
    }

    public Boolean getMaintainDirectoryLastModified() {
        return this.maintainDirectoryLastModified;
    }

    public void setMaintainDirectoryLastModified(Boolean maintainDirectoryLastModified) {
        this.maintainDirectoryLastModified = maintainDirectoryLastModified;
    }

    public Boolean getInheritPermissions() {
        return this.inheritPermissions;
    }

    public void setInheritPermissions(Boolean inheritPermissions) {
        this.inheritPermissions = inheritPermissions;
    }

    public Boolean getInheritCollections() {
        return this.inheritCollections;
    }

    public void setInheritCollections(Boolean inheritCollections) {
        this.inheritCollections = inheritCollections;
    }

    public Boolean getInheritQuality() {
        return this.inheritQuality;
    }

    public void setInheritQuality(Boolean inheritQuality) {
        this.inheritQuality = inheritQuality;
    }

    public Long getInMemoryLimit() {
        return this.inMemoryLimit;
    }

    public void setInMemoryLimit(Long inMemoryLimit) {
        this.inMemoryLimit = inMemoryLimit;
    }

    public Long getInMemoryListSize() {
        return this.inMemoryListSize;
    }

    public void setInMemoryListSize(Long inMemoryListSize) {
        this.inMemoryListSize = inMemoryListSize;
    }

    public Long getInMemoryTreeSize() {
        return this.inMemoryTreeSize;
    }

    public void setInMemoryTreeSize(Long inMemoryTreeSize) {
        this.inMemoryTreeSize = inMemoryTreeSize;
    }

    public Long getInMemoryRangeIndexSize() {
        return this.inMemoryRangeIndexSize;
    }

    public void setInMemoryRangeIndexSize(Long inMemoryRangeIndexSize) {
        this.inMemoryRangeIndexSize = inMemoryRangeIndexSize;
    }

    public Long getInMemoryReverseIndexSize() {
        return this.inMemoryReverseIndexSize;
    }

    public void setInMemoryReverseIndexSize(Long inMemoryReverseIndexSize) {
        this.inMemoryReverseIndexSize = inMemoryReverseIndexSize;
    }

    public Long getInMemoryTripleIndexSize() {
        return this.inMemoryTripleIndexSize;
    }

    public void setInMemoryTripleIndexSize(Long inMemoryTripleIndexSize) {
        this.inMemoryTripleIndexSize = inMemoryTripleIndexSize;
    }

    public Long getLargeSizeThreshold() {
        return this.largeSizeThreshold;
    }

    public void setLargeSizeThreshold(Long largeSizeThreshold) {
        this.largeSizeThreshold = largeSizeThreshold;
    }

    public String getLocking() {
        return this.locking;
    }

    public void setLocking(String locking) {
        this.locking = locking;
    }

    public String getJournaling() {
        return this.journaling;
    }

    public void setJournaling(String journaling) {
        this.journaling = journaling;
    }

    public Long getJournalSize() {
        return this.journalSize;
    }

    public void setJournalSize(Long journalSize) {
        this.journalSize = journalSize;
    }

    public Integer getJournalCount() {
        return this.journalCount;
    }

    public void setJournalCount(Integer journalCount) {
        this.journalCount = journalCount;
    }

    public Boolean getPreallocateJournals() {
        return this.preallocateJournals;
    }

    public void setPreallocateJournals(Boolean preallocateJournals) {
        this.preallocateJournals = preallocateJournals;
    }

    public Boolean getPreloadMappedData() {
        return this.preloadMappedData;
    }

    public void setPreloadMappedData(Boolean preloadMappedData) {
        this.preloadMappedData = preloadMappedData;
    }

    public Boolean getPreloadReplicaMappedData() {
        return this.preloadReplicaMappedData;
    }

    public void setPreloadReplicaMappedData(Boolean preloadReplicaMappedData) {
        this.preloadReplicaMappedData = preloadReplicaMappedData;
    }

    public String getRangeIndexOptimize() {
        return this.rangeIndexOptimize;
    }

    public void setRangeIndexOptimize(String rangeIndexOptimize) {
        this.rangeIndexOptimize = rangeIndexOptimize;
    }

    public Long getPositionsListMaxSize() {
        return this.positionsListMaxSize;
    }

    public void setPositionsListMaxSize(Long positionsListMaxSize) {
        this.positionsListMaxSize = positionsListMaxSize;
    }

    public String getFormatCompatibility() {
        return this.formatCompatibility;
    }

    public void setFormatCompatibility(String formatCompatibility) {
        this.formatCompatibility = formatCompatibility;
    }

    public String getIndexDetection() {
        return this.indexDetection;
    }

    public void setIndexDetection(String indexDetection) {
        this.indexDetection = indexDetection;
    }

    public String getExpungeLocks() {
        return this.expungeLocks;
    }

    public void setExpungeLocks(String expungeLocks) {
        this.expungeLocks = expungeLocks;
    }

    public String getTfNormalization() {
        return this.tfNormalization;
    }

    public void setTfNormalization(String tfNormalization) {
        this.tfNormalization = tfNormalization;
    }

    public String getMergePriority() {
        return this.mergePriority;
    }

    public void setMergePriority(String mergePriority) {
        this.mergePriority = mergePriority;
    }

    public Long getMergeMaxSize() {
        return this.mergeMaxSize;
    }

    public void setMergeMaxSize(Long mergeMaxSize) {
        this.mergeMaxSize = mergeMaxSize;
    }

    public Long getMergeMinSize() {
        return this.mergeMinSize;
    }

    public void setMergeMinSize(Long mergeMinSize) {
        this.mergeMinSize = mergeMinSize;
    }

    public Integer getMergeMinRatio() {
        return this.mergeMinRatio;
    }

    public void setMergeMinRatio(Integer mergeMinRatio) {
        this.mergeMinRatio = mergeMinRatio;
    }

    public Long getMergeTimestamp() {
        return this.mergeTimestamp;
    }

    public void setMergeTimestamp(Long mergeTimestamp) {
        this.mergeTimestamp = mergeTimestamp;
    }

    public Boolean getRetainUntilBackup() {
        return this.retainUntilBackup;
    }

    public void setRetainUntilBackup(Boolean retainUntilBackup) {
        this.retainUntilBackup = retainUntilBackup;
    }

    public List<Element> getElementWordQueryThrough() {
        return this.elementWordQueryThrough;
    }

    public void setElementWordQueryThrough(List<Element> elementWordQueryThrough) {
        this.elementWordQueryThrough = elementWordQueryThrough;
    }

    public List<Element> getPhraseThrough() {
        return this.phraseThrough;
    }

    public void setPhraseThrough(List<Element> phraseThrough) {
        this.phraseThrough = phraseThrough;
    }

    public List<Element> getPhraseAround() {
        return this.phraseAround;
    }

    public void setPhraseAround(List<Element> phraseAround) {
        this.phraseAround = phraseAround;
    }

    public List<Field> getField() {
        return this.field;
    }

    public void setField(List<Field> field) {
        this.field = field;
    }

    public Boolean getRebalancerEnable() {
        return this.rebalancerEnable;
    }

    public void setRebalancerEnable(Boolean rebalancerEnable) {
        this.rebalancerEnable = rebalancerEnable;
    }

    public Integer getRebalancerThrottle() {
        return this.rebalancerThrottle;
    }

    public void setRebalancerThrottle(Integer rebalancerThrottle) {
        this.rebalancerThrottle = rebalancerThrottle;
    }

    public AssignmentPolicy getAssignmentPolicy() {
        return this.assignmentPolicy;
    }

    public void setAssignmentPolicy(AssignmentPolicy assignmentPolicy) {
        this.assignmentPolicy = assignmentPolicy;
    }

    public List<FieldIndex> getRangeFieldIndex() {
        return this.rangeFieldIndex;
    }

    public void setRangeFieldIndex(List<FieldIndex> rangeFieldIndex) {
        this.rangeFieldIndex = rangeFieldIndex;
    }

    public List<ElementAttributeIndex> getRangeElementAttributeIndex() {
        return this.rangeElementAttributeIndex;
    }

    public void setRangeElementAttributeIndex(List<ElementAttributeIndex> rangeElementAttributeIndex) {
        this.rangeElementAttributeIndex = rangeElementAttributeIndex;
    }

    public List<ElementWordLexicon> getElementWordLexicon() {
        return this.elementWordLexicon;
    }

    public void setElementWordLexicon(List<ElementWordLexicon> elementWordLexicon) {
        this.elementWordLexicon = elementWordLexicon;
    }

    public List<ElementAttributeWordLexicon> getElementAttributeWordLexicon() {
        return this.elementAttributeWordLexicon;
    }

    public void setElementAttributeWordLexicon(List<ElementAttributeWordLexicon> elementAttributeWordLexicon) {
        this.elementAttributeWordLexicon = elementAttributeWordLexicon;
    }

    public List<PathNamespace> getPathNamespace() {
        return this.pathNamespace;
    }

    public void setPathNamespace(List<PathNamespace> pathNamespace) {
        this.pathNamespace = pathNamespace;
    }

    public List<GeospatialElementIndex> getGeospatialElementIndex() {
        return this.geospatialElementIndex;
    }

    public void setGeospatialElementIndex(List<GeospatialElementIndex> geospatialElementIndex) {
        this.geospatialElementIndex = geospatialElementIndex;
    }

    public List<GeospatialElementChildIndex> getGeospatialElementChildIndex() {
        return this.geospatialElementChildIndex;
    }

    public void setGeospatialElementChildIndex(List<GeospatialElementChildIndex> geospatialElementChildIndex) {
        this.geospatialElementChildIndex = geospatialElementChildIndex;
    }

    public List<GeospatialElementPairIndex> getGeospatialElementPairIndex() {
        return this.geospatialElementPairIndex;
    }

    public void setGeospatialElementPairIndex(List<GeospatialElementPairIndex> geospatialElementPairIndex) {
        this.geospatialElementPairIndex = geospatialElementPairIndex;
    }

    public List<GeospatialElementPairIndex> getGeospatialElementAttributePairIndex() {
        return this.geospatialElementAttributePairIndex;
    }

    public void setGeospatialElementAttributePairIndex(List<GeospatialElementPairIndex> geospatialElementAttributePairIndex) {
        this.geospatialElementAttributePairIndex = geospatialElementAttributePairIndex;
    }

    public List<GeospatialPathIndex> getGeospatialPathIndex() {
        return this.geospatialPathIndex;
    }

    public void setGeospatialPathIndex(List<GeospatialPathIndex> geospatialPathIndex) {
        this.geospatialPathIndex = geospatialPathIndex;
    }

    public List<GeospatialRegionPathIndex> getGeospatialRegionPathIndex() {
        return this.geospatialRegionPathIndex;
    }

    public void setGeospatialRegionPathIndex(List<GeospatialRegionPathIndex> geospatialRegionPathIndex) {
        this.geospatialRegionPathIndex = geospatialRegionPathIndex;
    }

    public List<DefaultRuleset> getDefaultRuleset() {
        return this.defaultRuleset;
    }

    public void setDefaultRuleset(List<DefaultRuleset> defaultRuleset) {
        this.defaultRuleset = defaultRuleset;
    }

    public DatabaseReplication getDatabaseReplication() {
        return this.databaseReplication;
    }

    public void setDatabaseReplication(DatabaseReplication databaseReplication) {
        this.databaseReplication = databaseReplication;
    }

    public List<DatabaseReference> getDatabaseReference() {
        return this.databaseReference;
    }

    public void setDatabaseReference(List<DatabaseReference> databaseReference) {
        this.databaseReference = databaseReference;
    }

    public List<DatabaseBackup> getDatabaseBackup() {
        return this.databaseBackup;
    }

    public void setDatabaseBackup(List<DatabaseBackup> databaseBackup) {
        this.databaseBackup = databaseBackup;
    }

    public List<MergeBlackout> getMergeBlackout() {
        return this.mergeBlackout;
    }

    public void setMergeBlackout(List<MergeBlackout> mergeBlackout) {
        this.mergeBlackout = mergeBlackout;
    }

    public List<FragmentRoot> getFragmentRoot() {
        return this.fragmentRoot;
    }

    public void setFragmentRoot(List<FragmentRoot> fragmentRoot) {
        this.fragmentRoot = fragmentRoot;
    }

    public List<FragmentParent> getFragmentParent() {
        return this.fragmentParent;
    }

    public void setFragmentParent(List<FragmentParent> fragmentParent) {
        this.fragmentParent = fragmentParent;
    }

    public List<PathIndex> getRangePathIndex() {
        return this.rangePathIndex;
    }

    public void setRangePathIndex(List<PathIndex> rangePathIndex) {
        this.rangePathIndex = rangePathIndex;
    }
}

