/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.scaffold;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.util.RestApiUtil;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.mgmt.util.ObjectMapperFactory;
import java.io.File;
import java.io.IOException;
import org.springframework.util.FileCopyUtils;

public class ScaffoldGenerator
extends LoggingObject {
    protected ObjectMapper objectMapper;
    private PrettyPrinter prettyPrinter = new DefaultPrettyPrinter();

    public void generateScaffold(String path, AppInputs appInputs) {
        if (this.objectMapper == null) {
            this.objectMapper = ObjectMapperFactory.getObjectMapper();
        }
        File rootDir = new File(path);
        File configDir = this.getConfigDir(rootDir);
        configDir.mkdirs();
        File modulesDir = this.getModulesDir(rootDir);
        modulesDir.mkdirs();
        this.generateDatabaseFiles(configDir);
        if (appInputs.isWithUsersAndRoles()) {
            this.generateSecurityFiles(configDir, appInputs.getAppName());
        }
        if (appInputs.isWithRestServer()) {
            this.generateRestApiFile(configDir);
            this.generateRestPropertiesFile(modulesDir);
            this.generateSearchOptions(modulesDir, appInputs.getAppName());
        }
    }

    @Deprecated
    public void generateScaffold(String path, AppConfig config) {
        if (this.objectMapper == null) {
            this.objectMapper = ObjectMapperFactory.getObjectMapper();
        }
        File rootDir = new File(path);
        File configDir = this.getConfigDir(rootDir);
        configDir.mkdirs();
        File modulesDir = this.getModulesDir(rootDir);
        modulesDir.mkdirs();
        this.generateDatabaseFiles(configDir);
        this.generateSecurityFiles(configDir, config.getName());
        if (!config.isNoRestServer()) {
            this.generateRestApiFile(configDir);
            this.generateRestPropertiesFile(modulesDir);
            this.generateSearchOptions(modulesDir, config.getName());
        }
    }

    private void generateSearchOptions(File modulesDir, String appName) {
        File optionsDir = new File(modulesDir, "options");
        optionsDir.mkdirs();
        String xml = "<options xmlns='http://marklogic.com/appservices/search'>\n  <search-option>unfiltered</search-option>\n  <quality-weight>0</quality-weight>\n</options>";
        this.writeFile(xml.getBytes(), new File(optionsDir, appName + "-options.xml"));
    }

    protected void generateRestPropertiesFile(File modulesDir) {
        this.writeFile(this.buildRestPropertiesJson(), new File(modulesDir, "rest-properties.json"));
    }

    protected ObjectNode buildRestPropertiesJson() {
        ObjectNode node = this.objectMapper.createObjectNode();
        node.put("debug", false);
        node.put("validate-queries", true);
        node.put("document-transform-all", false);
        node.put("validate-options", true);
        return node;
    }

    protected void generateSecurityFiles(File configDir, String appName) {
        File rolesDir = new File(configDir, "security/roles");
        rolesDir.mkdirs();
        this.writeFile(this.buildNobodyRole(appName), new File(rolesDir, "1-" + appName + "-nobody-role.json"));
        this.writeFile(this.buildReaderRole(appName), new File(rolesDir, "2-" + appName + "-reader-role.json"));
        this.writeFile(this.buildWriterRole(appName), new File(rolesDir, "3-" + appName + "-writer-role.json"));
        this.writeFile(this.buildInternalRole(appName), new File(rolesDir, "4-" + appName + "-internal-role.json"));
        this.writeFile(this.buildAdminRole(appName), new File(rolesDir, "5-" + appName + "-admin-role.json"));
        File usersDir = new File(configDir, "security/users");
        usersDir.mkdirs();
        this.writeFile(this.buildReaderUser(appName), new File(usersDir, appName + "-reader-user.json"));
        this.writeFile(this.buildWriterUser(appName), new File(usersDir, appName + "-writer-user.json"));
        this.writeFile(this.buildAdminUser(appName), new File(usersDir, appName + "-admin-user.json"));
    }

    protected ObjectNode buildNobodyRole(String appName) {
        ObjectNode node = this.objectMapper.createObjectNode();
        node.put("role-name", appName + "-nobody");
        node.put("description", "Unauthenticated user");
        node.putArray("role");
        return node;
    }

    protected ObjectNode buildReaderRole(String appName) {
        ObjectNode node = this.objectMapper.createObjectNode();
        node.put("role-name", appName + "-reader");
        node.put("description", "Can view documents, but not edit");
        ArrayNode array = node.putArray("role");
        array.add(appName + "-nobody");
        array = node.putArray("privilege");
        array.add((JsonNode)this.buildPrivilege("rest-reader", "http://marklogic.com/xdmp/privileges/rest-reader", "execute"));
        return node;
    }

    protected ObjectNode buildWriterRole(String appName) {
        ObjectNode node = this.objectMapper.createObjectNode();
        node.put("role-name", appName + "-writer");
        node.put("description", "Can read and write documents");
        ArrayNode array = node.putArray("role");
        array.add(appName + "-reader");
        array = node.putArray("privilege");
        array.add((JsonNode)this.buildPrivilege("rest-writer", "http://marklogic.com/xdmp/privileges/rest-writer", "execute"));
        array.add((JsonNode)this.buildPrivilege("any-uri", "http://marklogic.com/xdmp/privileges/any-uri", "execute"));
        array.add((JsonNode)this.buildPrivilege("unprotected-collections", "http://marklogic.com/xdmp/privileges/unprotected-collections", "execute"));
        return node;
    }

    protected ObjectNode buildInternalRole(String appName) {
        ObjectNode node = this.objectMapper.createObjectNode();
        node.put("role-name", appName + "-internal");
        node.put("description", "Internal role used for amping");
        ArrayNode array = node.putArray("role");
        array.add(appName + "-writer");
        return node;
    }

    protected ObjectNode buildAdminRole(String appName) {
        ObjectNode node = this.objectMapper.createObjectNode();
        node.put("role-name", appName + "-admin");
        node.put("description", "Non-admin administrator");
        ArrayNode array = node.putArray("role");
        array.add("rest-admin");
        array.add("manage-admin");
        array.add(appName + "-writer");
        array = node.putArray("privilege");
        array.add((JsonNode)this.buildPrivilege("any-uri", "http://marklogic.com/xdmp/privileges/any-uri", "execute"));
        array.add((JsonNode)this.buildPrivilege("xdbc:insert-in", "http://marklogic.com/xdmp/privileges/xdbc-insert-in", "execute"));
        array.add((JsonNode)this.buildPrivilege("xdmp:eval-in", "http://marklogic.com/xdmp/privileges/xdmp-eval-in", "execute"));
        return node;
    }

    protected ObjectNode buildPrivilege(String name, String action, String kind) {
        ObjectNode node = this.objectMapper.createObjectNode();
        node.put("privilege-name", name);
        node.put("action", action);
        node.put("kind", kind);
        return node;
    }

    protected ObjectNode buildReaderUser(String appName) {
        ObjectNode node = this.objectMapper.createObjectNode();
        String name = appName + "-reader";
        node.put("user-name", name);
        node.put("password", name);
        ArrayNode roles = node.putArray("role");
        roles.add(appName + "-reader");
        return node;
    }

    protected ObjectNode buildWriterUser(String appName) {
        ObjectNode node = this.objectMapper.createObjectNode();
        String name = appName + "-writer";
        node.put("user-name", name);
        node.put("password", name);
        ArrayNode roles = node.putArray("role");
        roles.add(appName + "-writer");
        return node;
    }

    protected ObjectNode buildAdminUser(String appName) {
        ObjectNode node = this.objectMapper.createObjectNode();
        String name = appName + "-admin";
        node.put("user-name", name);
        node.put("password", name);
        ArrayNode roles = node.putArray("role");
        roles.add(appName + "-admin");
        return node;
    }

    protected void generateRestApiFile(File configDir) {
        this.writeFile(this.buildRestApiJson().getBytes(), new File(configDir, "rest-api.json"));
    }

    protected String buildRestApiJson() {
        return RestApiUtil.buildDefaultRestApiJson();
    }

    protected void generateDatabaseFiles(File configDir) {
        File databasesDir = new File(configDir, "databases");
        databasesDir.mkdirs();
        this.writeFile(this.buildContentDatabaseJson(), new File(databasesDir, "content-database.json"));
        this.writeFile(this.buildSchemasDatabaseJson(), new File(databasesDir, "schemas-database.json"));
    }

    protected ObjectNode buildContentDatabaseJson() {
        ObjectNode node = this.objectMapper.createObjectNode();
        node.put("database-name", "%%DATABASE%%");
        node.put("schema-database", "%%SCHEMAS_DATABASE%%");
        ArrayNode array = node.putArray("range-element-index");
        ObjectNode index = array.addObject();
        index.put("scalar-type", "string");
        index.put("namespace-uri", "CHANGEME");
        index.put("localname", "CHANGEME");
        index.put("collation", "http://marklogic.com/collation/");
        index.put("range-value-positions", false);
        index.put("invalid-values", "reject");
        return node;
    }

    protected ObjectNode buildSchemasDatabaseJson() {
        ObjectNode node = this.objectMapper.createObjectNode();
        node.put("database-name", "%%SCHEMAS_DATABASE%%");
        return node;
    }

    protected void writeFile(ObjectNode node, File f) {
        try {
            byte[] bytes = this.objectMapper.writer(this.prettyPrinter).writeValueAsBytes((Object)node);
            this.writeFile(bytes, f);
        }
        catch (JsonProcessingException je) {
            throw new RuntimeException("Unable to process JSON for file: " + f.getAbsolutePath() + "; cause: " + je.getMessage(), je);
        }
    }

    protected void writeFile(byte[] bytes, File f) {
        if (f.exists()) {
            this.logger.info("Not writing file, as it already exists: " + f.getAbsolutePath());
        } else {
            try {
                this.logger.info("Writing: " + f.getAbsolutePath());
                FileCopyUtils.copy((byte[])bytes, (File)f);
            }
            catch (IOException ie) {
                throw new RuntimeException("Unable to write file at: " + f.getAbsolutePath() + "; cause: " + ie.getMessage(), ie);
            }
        }
    }

    protected File getConfigDir(File rootDir) {
        return new File(rootDir, "src/main/ml-config");
    }

    protected File getModulesDir(File rootDir) {
        return new File(rootDir, "src/main/ml-modules");
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setPrettyPrinter(PrettyPrinter prettyPrinter) {
        this.prettyPrinter = prettyPrinter;
    }

    public static class AppInputs {
        private final String appName;
        private final boolean withRestServer;
        private final boolean withUsersAndRoles;

        public AppInputs(String appName) {
            this(appName, true, true);
        }

        public AppInputs(String appName, boolean withRestServer, boolean withUsersAndRoles) {
            this.appName = appName;
            this.withRestServer = withRestServer;
            this.withUsersAndRoles = withUsersAndRoles;
        }

        public String getAppName() {
            return this.appName;
        }

        public boolean isWithRestServer() {
            return this.withRestServer;
        }

        public boolean isWithUsersAndRoles() {
            return this.withUsersAndRoles;
        }
    }
}

