/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.impl;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.AppDeployer;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.Command;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.UndoableCommand;
import com.marklogic.appdeployer.impl.AddHostNameTokensDeployerListener;
import com.marklogic.appdeployer.impl.CmaDeployerListener;
import com.marklogic.appdeployer.impl.DeployerListener;
import com.marklogic.appdeployer.impl.DeploymentContext;
import com.marklogic.appdeployer.impl.ExecuteComparator;
import com.marklogic.appdeployer.impl.PrepareCommandListener;
import com.marklogic.appdeployer.impl.UndoComparator;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.admin.AdminManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractAppDeployer
extends LoggingObject
implements AppDeployer {
    private ManageClient manageClient;
    private AdminManager adminManager;
    private List<DeployerListener> deployerListeners;

    @Deprecated
    public AbstractAppDeployer() {
        this(new ManageClient(), new AdminManager());
    }

    public AbstractAppDeployer(ManageClient manageClient, AdminManager adminManager) {
        this.manageClient = manageClient;
        this.adminManager = adminManager;
        this.deployerListeners = new ArrayList<DeployerListener>();
        this.deployerListeners.add(new AddHostNameTokensDeployerListener());
        this.deployerListeners.add(new PrepareCommandListener());
        this.deployerListeners.add(new CmaDeployerListener());
    }

    protected abstract List<Command> getCommands();

    @Override
    public void deploy(AppConfig appConfig) {
        ArrayList<String> configPaths = new ArrayList<String>();
        for (ConfigDir configDir : appConfig.getConfigDirs()) {
            configPaths.add(configDir.getBaseDir().getAbsolutePath());
        }
        this.logger.info(this.format("Deploying app %s with config dirs: %s\n", new Object[]{appConfig.getName(), configPaths}));
        List<Command> commands = this.getCommands();
        Collections.sort(commands, new ExecuteComparator());
        CommandContext context = new CommandContext(appConfig, this.manageClient, this.adminManager);
        DeploymentContext deploymentContext = new DeploymentContext(context, appConfig, commands);
        this.deployerListeners.forEach(listener -> listener.beforeCommandsExecuted(deploymentContext));
        boolean catchExceptions = appConfig.isCatchDeployExceptions();
        int commandCount = commands.size();
        for (int i = 0; i < commandCount; ++i) {
            Command command = commands.get(i);
            List<Command> remainingCommands = commands.subList(i + 1, commandCount);
            String name = command.getClass().getName();
            this.logger.info(this.format("Executing command [%s] with sort order [%d]", new Object[]{name, command.getExecuteSortOrder()}));
            this.invokeListenersBeforeCommandExecuted(context, command, deploymentContext, remainingCommands, catchExceptions);
            long start = System.currentTimeMillis();
            this.executeCommand(command, context);
            this.logger.info(this.format("Finished executing command [%s] in %dms\n", new Object[]{name, System.currentTimeMillis() - start}));
            this.invokeListenersAfterCommandExecuted(context, command, deploymentContext, remainingCommands, catchExceptions);
        }
        this.logger.info(this.format("Deployed app %s", new Object[]{appConfig.getName()}));
    }

    protected void executeCommand(Command command, CommandContext context) {
        try {
            command.execute(context);
        }
        catch (RuntimeException ex) {
            if (context.getAppConfig().isCatchDeployExceptions()) {
                this.logger.error(this.format("Command [%s] threw exception that was caught; cause: %s", new Object[]{command.getClass().getName(), ex.getMessage()}), (Throwable)ex);
            }
            throw ex;
        }
    }

    @Override
    public void undeploy(AppConfig appConfig) {
        ArrayList<String> configPaths = new ArrayList<String>();
        for (ConfigDir configDir : appConfig.getConfigDirs()) {
            configPaths.add(configDir.getBaseDir().getAbsolutePath());
        }
        this.logger.info(this.format("Undeploying app %s with config dirs: %s\n", new Object[]{appConfig.getName(), configPaths}));
        List<Command> commands = this.getCommands();
        ArrayList<UndoableCommand> undoableCommands = new ArrayList<UndoableCommand>();
        for (Command command : commands) {
            if (!(command instanceof UndoableCommand)) continue;
            undoableCommands.add((UndoableCommand)command);
        }
        Collections.sort(undoableCommands, new UndoComparator());
        CommandContext context = new CommandContext(appConfig, this.manageClient, this.adminManager);
        DeploymentContext deploymentContext = new DeploymentContext(context, appConfig, commands);
        this.deployerListeners.forEach(listener -> listener.beforeCommandsExecuted(deploymentContext));
        boolean catchExceptions = appConfig.isCatchUndeployExceptions();
        int commandCount = undoableCommands.size();
        for (int i = 0; i < commandCount; ++i) {
            UndoableCommand command = (UndoableCommand)undoableCommands.get(i);
            List<Command> remainingCommands = commands.subList(i + 1, commandCount);
            String name = command.getClass().getName();
            this.logger.info(this.format("Undoing command [%s] with sort order [%d]", new Object[]{name, command.getUndoSortOrder()}));
            this.invokeListenersBeforeCommandExecuted(context, command, deploymentContext, remainingCommands, catchExceptions);
            this.undoCommand(command, context);
            this.logger.info(this.format("Finished undoing command [%s]\n", new Object[]{name}));
            this.invokeListenersAfterCommandExecuted(context, command, deploymentContext, remainingCommands, catchExceptions);
        }
        this.logger.info(this.format("Undeployed app %s", new Object[]{appConfig.getName()}));
    }

    protected void undoCommand(UndoableCommand command, CommandContext context) {
        try {
            command.undo(context);
        }
        catch (RuntimeException ex) {
            if (context.getAppConfig().isCatchUndeployExceptions()) {
                this.logger.error(this.format("Command [%s] threw exception that was caught; cause: %s", new Object[]{command.getClass().getName(), ex.getMessage()}), (Throwable)ex);
            }
            throw ex;
        }
    }

    protected void invokeListenersBeforeCommandExecuted(CommandContext context, Command command, DeploymentContext deploymentContext, List<Command> remainingCommands, boolean catchExceptions) {
        this.deployerListeners.forEach(listener -> {
            try {
                listener.beforeCommandExecuted(command, deploymentContext, remainingCommands);
            }
            catch (Exception ex) {
                if (catchExceptions) {
                    this.logger.error(this.format("Listener threw exception that was caught; cause: %s", new Object[]{ex.getMessage()}), (Throwable)ex);
                }
                throw ex;
            }
        });
    }

    protected void invokeListenersAfterCommandExecuted(CommandContext context, Command command, DeploymentContext deploymentContext, List<Command> remainingCommands, boolean catchExceptions) {
        this.deployerListeners.forEach(listener -> {
            try {
                listener.afterCommandExecuted(command, deploymentContext, remainingCommands);
            }
            catch (Exception ex) {
                if (catchExceptions) {
                    this.logger.error(this.format("Listener threw exception that was caught; cause: %s", new Object[]{ex.getMessage()}), (Throwable)ex);
                }
                throw ex;
            }
        });
    }

    public List<DeployerListener> getDeployerListeners() {
        return this.deployerListeners;
    }

    public void setDeployerListeners(List<DeployerListener> deployerListeners) {
        this.deployerListeners = deployerListeners;
    }
}

