/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.export;

import com.marklogic.appdeployer.export.ExportedResources;
import com.marklogic.appdeployer.export.ResourceExporter;
import com.marklogic.appdeployer.export.appservers.ServerExporter;
import com.marklogic.appdeployer.export.cpf.CpfConfigExporter;
import com.marklogic.appdeployer.export.cpf.DomainExporter;
import com.marklogic.appdeployer.export.cpf.PipelineExporter;
import com.marklogic.appdeployer.export.databases.DatabaseExporter;
import com.marklogic.appdeployer.export.groups.GroupExporter;
import com.marklogic.appdeployer.export.impl.CompositeResourceExporter;
import com.marklogic.appdeployer.export.security.AmpExporter;
import com.marklogic.appdeployer.export.security.PrivilegeExporter;
import com.marklogic.appdeployer.export.security.RoleExporter;
import com.marklogic.appdeployer.export.security.UserExporter;
import com.marklogic.appdeployer.export.tasks.TaskExporter;
import com.marklogic.appdeployer.export.triggers.TriggerExporter;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.selector.AbstractNameMatchingResourceSelector;
import com.marklogic.mgmt.selector.ResourceSelection;
import com.marklogic.mgmt.selector.ResourceSelector;
import java.io.File;

public class Exporter
extends LoggingObject {
    private CompositeResourceExporter compositeExporter;
    private ManageClient manageClient;
    private String groupName;
    private String triggersDatabase;

    public static Exporter client(ManageClient manageClient) {
        return new Exporter(manageClient);
    }

    public Exporter(ManageClient manageClient) {
        this(manageClient, null);
    }

    public Exporter(ManageClient manageClient, String groupName) {
        this.manageClient = manageClient;
        this.compositeExporter = new CompositeResourceExporter(new ResourceExporter[0]);
        this.groupName = groupName;
    }

    public Exporter select(ResourceSelector selector) {
        if (selector instanceof AbstractNameMatchingResourceSelector) {
            ((AbstractNameMatchingResourceSelector)selector).setTriggersDatabase(this.triggersDatabase);
        }
        ResourceSelection selection = selector.selectResources(this.manageClient);
        this.amps(selection.getAmpUriRefs());
        this.cpfConfigs(this.triggersDatabase, selection.getCpfConfigNames());
        this.databases(selection.getDatabaseNames());
        this.domains(this.triggersDatabase, selection.getDomainNames());
        this.groups(selection.getGroupNames());
        this.pipelines(this.triggersDatabase, selection.getPipelineNames());
        this.privilegesExecute(selection.getPrivilegeExecuteNames());
        this.privilegesUri(selection.getPrivilegeUriNames());
        this.roles(selection.getRoleNames());
        this.servers(selection.getServerNames());
        this.tasks(selection.getTaskNames());
        this.triggers(this.triggersDatabase, selection.getTriggerNames());
        this.users(selection.getUserNames());
        return this;
    }

    public Exporter format(String xmlOrJson) {
        this.compositeExporter.setFormat(xmlOrJson);
        return this;
    }

    public ExportedResources export(File baseDir) {
        return this.compositeExporter.exportResources(baseDir);
    }

    public Exporter add(ResourceExporter resourceExporter) {
        this.compositeExporter.add(resourceExporter);
        return this;
    }

    public Exporter amps(String ... ampUriRefs) {
        return ampUriRefs != null && ampUriRefs.length > 0 ? this.add(new AmpExporter(this.manageClient, ampUriRefs)) : this;
    }

    public Exporter cpfConfigs(String databaseIdOrName, String ... domainNames) {
        return domainNames != null && domainNames.length > 0 ? this.add(new CpfConfigExporter(this.manageClient, databaseIdOrName, domainNames)) : null;
    }

    public Exporter databases(String ... databaseNames) {
        return databaseNames != null && databaseNames.length > 0 ? this.add(new DatabaseExporter(this.manageClient, databaseNames)) : null;
    }

    public Exporter domains(String databaseIdOrName, String ... domainNames) {
        return domainNames != null && domainNames.length > 0 ? this.add(new DomainExporter(this.manageClient, databaseIdOrName, domainNames)) : null;
    }

    public Exporter groups(String ... groupNames) {
        return groupNames != null && groupNames.length > 0 ? this.add(new GroupExporter(this.manageClient, groupNames)) : null;
    }

    public Exporter pipelines(String databaseIdOrName, String ... pipelineNames) {
        return pipelineNames != null && pipelineNames.length > 0 ? this.add(new PipelineExporter(this.manageClient, databaseIdOrName, pipelineNames)) : null;
    }

    public Exporter privilegesExecute(String ... privilegeNames) {
        return privilegeNames != null && privilegeNames.length > 0 ? this.add(new PrivilegeExporter(this.manageClient, privilegeNames)) : null;
    }

    public Exporter privilegesUri(String ... privilegeNames) {
        if (privilegeNames != null && privilegeNames.length > 0) {
            PrivilegeExporter ex = new PrivilegeExporter(this.manageClient, privilegeNames);
            ex.setUriPrivilegeNames(privilegeNames);
            return this.add(ex);
        }
        return this;
    }

    public Exporter roles(String ... roleNames) {
        return roleNames != null && roleNames.length > 0 ? this.add(new RoleExporter(this.manageClient, roleNames)) : null;
    }

    public Exporter servers(String ... serverNames) {
        return serverNames != null && serverNames.length > 0 ? this.add(this.buildServerExporter(serverNames)) : null;
    }

    public Exporter serversNoDatabases(String ... serverNames) {
        if (serverNames != null && serverNames.length > 0) {
            ServerExporter se = this.buildServerExporter(serverNames);
            se.setExportDatabases(false);
            return this.add(se);
        }
        return this;
    }

    protected ServerExporter buildServerExporter(String ... serverNames) {
        return this.groupName != null ? new ServerExporter(this.groupName, this.manageClient, serverNames) : new ServerExporter(this.manageClient, serverNames);
    }

    public Exporter tasks(String ... taskNames) {
        if (taskNames != null && taskNames.length > 0) {
            TaskExporter te = this.groupName != null ? new TaskExporter(this.groupName, this.manageClient, taskNames) : new TaskExporter(this.manageClient, taskNames);
            return this.add(te);
        }
        return this;
    }

    public Exporter triggers(String databaseIdOrName, String ... triggerNames) {
        return triggerNames != null && triggerNames.length > 0 ? this.add(new TriggerExporter(this.manageClient, databaseIdOrName, triggerNames)) : null;
    }

    public Exporter users(String ... usernames) {
        return usernames != null && usernames.length > 0 ? this.add(new UserExporter(this.manageClient, usernames)) : null;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public Exporter withTriggersDatabase(String triggersDatabase) {
        this.setTriggersDatabase(triggersDatabase);
        return this;
    }

    public void setTriggersDatabase(String triggersDatabase) {
        this.triggersDatabase = triggersDatabase;
    }
}

