/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.security;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractResourceCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.appdeployer.command.SupportsCmaCommand;
import com.marklogic.mgmt.api.configuration.Configuration;
import com.marklogic.mgmt.api.security.Amp;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.security.AmpManager;
import com.marklogic.rest.util.ResourcesFragment;
import java.io.File;

public class DeployAmpsCommand
extends AbstractResourceCommand
implements SupportsCmaCommand {
    private AmpManager ampManager;
    private ResourcesFragment existingAmpResources;

    public DeployAmpsCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_AMPS);
        this.setUndoSortOrder(SortOrderConstants.DELETE_AMPS);
        this.setResourceClassType(Amp.class);
    }

    @Override
    public void execute(CommandContext context) {
        this.ampManager = new AmpManager(context.getManageClient());
        this.existingAmpResources = this.findExistingAmpResources(this.ampManager);
        super.execute(context);
    }

    protected ResourcesFragment findExistingAmpResources(AmpManager ampManager) {
        return ampManager.getAsXml();
    }

    @Override
    protected File[] getResourceDirs(CommandContext context) {
        return this.findResourceDirs(context, (ConfigDir configDir) -> configDir.getAmpsDir());
    }

    @Override
    protected ResourceManager getResourceManager(CommandContext context) {
        return new AmpManager(context.getManageClient());
    }

    @Override
    public boolean cmaShouldBeUsed(CommandContext context) {
        return context.getAppConfig().getCmaConfig().isDeployAmps();
    }

    @Override
    public void addResourceToConfiguration(ObjectNode amp, Configuration configuration) {
        if (this.ampIsUnchanged(amp)) {
            this.logger.info("Amp is unchanged, so not deploying: " + amp.get("local-name"));
        } else {
            configuration.addAmp(amp);
        }
    }

    protected boolean ampIsUnchanged(ObjectNode amp) {
        if (this.existingAmpResources != null) {
            String localName = amp.get("local-name").asText();
            String namespace = amp.has("namespace") ? amp.get("namespace").asText() : null;
            String documentUri = amp.get("document-uri").asText();
            String modulesDatabase = amp.has("modules-database") ? amp.get("modules-database").asText() : null;
            return this.ampManager.ampExists(this.existingAmpResources, localName, documentUri, namespace, modulesDatabase);
        }
        return false;
    }
}

