/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.forests;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.command.forests.AbstractReplicaBuilderStrategy;
import com.marklogic.appdeployer.command.forests.ForestNamingStrategy;
import com.marklogic.appdeployer.command.forests.ForestPlan;
import com.marklogic.mgmt.api.forest.Forest;
import com.marklogic.mgmt.api.forest.ForestReplica;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DistributedReplicaBuilderStrategy
extends AbstractReplicaBuilderStrategy {
    @Override
    public void buildReplicas(List<Forest> forests, ForestPlan forestPlan, AppConfig appConfig, List<String> replicaDataDirectories, ForestNamingStrategy fns) {
        String databaseName = forestPlan.getDatabaseName();
        List<String> hostNames = forestPlan.getReplicaHostNames();
        int replicaCount = forestPlan.getReplicaCount();
        HashMap hostToForests = new HashMap();
        for (Forest f : forests) {
            String host = f.getHost();
            if (hostToForests.containsKey(host)) {
                ((List)hostToForests.get(host)).add(f);
                continue;
            }
            ArrayList<Forest> hostForests = new ArrayList<Forest>();
            hostForests.add(f);
            hostToForests.put(host, hostForests);
        }
        for (String host : hostToForests.keySet()) {
            this.logger.info("Determining replicas for host: " + host);
            ArrayList<String> availableHosts = new ArrayList<String>();
            int hostIndex = hostNames.indexOf(host);
            if (hostIndex != -1 && hostIndex < hostNames.size()) {
                availableHosts.addAll(hostNames.subList(hostIndex + 1, hostNames.size()));
            }
            availableHosts.addAll(hostNames.subList(0, hostIndex));
            int availableHostCount = availableHosts.size();
            this.logger.info("Available hosts for replicas: " + availableHosts);
            int hostPointer = 0;
            for (Forest currForest : (List)hostToForests.get(host)) {
                ArrayList<ForestReplica> replicas = new ArrayList<ForestReplica>();
                int dataDirectoryPointer = replicaDataDirectories.indexOf(currForest.getDataDirectory());
                for (int i = 1; i <= replicaCount; ++i) {
                    String dataDir;
                    ForestReplica replica = new ForestReplica();
                    replica.setReplicaName(fns.getReplicaName(databaseName, currForest.getForestName(), i, appConfig));
                    replicas.add(replica);
                    int replicaHostPointer = hostPointer + i - 1;
                    if (replicaHostPointer >= availableHostCount) {
                        replicaHostPointer %= availableHostCount;
                    }
                    replica.setHost((String)availableHosts.get(replicaHostPointer));
                    this.logger.info(this.format("Built replica '%s' for forest '%s' on host '%s'", new Object[]{replica.getReplicaName(), currForest.getForestName(), replica.getHost()}));
                    if (++dataDirectoryPointer == replicaDataDirectories.size()) {
                        dataDirectoryPointer = 0;
                    }
                    if ((dataDir = replicaDataDirectories.get(dataDirectoryPointer)) != null && dataDir.trim().length() > 0) {
                        replica.setDataDirectory(dataDir);
                    }
                    this.configureReplica(replica, databaseName, appConfig);
                }
                currForest.setForestReplica(replicas);
                if (++hostPointer != availableHostCount) continue;
                hostPointer = 0;
            }
        }
    }
}

