/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.forests;

import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.appdeployer.command.forests.DefaultHostCalculator;
import com.marklogic.appdeployer.command.forests.ForestBuilder;
import com.marklogic.appdeployer.command.forests.ForestHostNames;
import com.marklogic.appdeployer.command.forests.ForestPlan;
import com.marklogic.appdeployer.command.forests.HostCalculator;
import com.marklogic.mgmt.api.API;
import com.marklogic.mgmt.api.configuration.Configuration;
import com.marklogic.mgmt.api.configuration.Configurations;
import com.marklogic.mgmt.api.forest.Forest;
import com.marklogic.mgmt.mapper.DefaultResourceMapper;
import com.marklogic.mgmt.resource.databases.DatabaseManager;
import com.marklogic.mgmt.resource.forests.ForestManager;
import com.marklogic.mgmt.resource.hosts.DefaultHostNameProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class DeployForestsCommand
extends AbstractCommand {
    public static final String DEFAULT_FOREST_PAYLOAD = "{\"forest-name\": \"%%FOREST_NAME%%\", \"host\": \"%%FOREST_HOST%%\", \"database\": \"%%FOREST_DATABASE%%\"}";
    private int forestsPerHost = 1;
    private String databaseName;
    private String forestFilename;
    private String forestPayload;
    @Deprecated
    private boolean createForestsOnEachHost = true;
    private HostCalculator hostCalculator;
    private ForestBuilder forestBuilder = new ForestBuilder();

    public DeployForestsCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_FORESTS);
    }

    public DeployForestsCommand(String databaseName) {
        this();
        this.databaseName = databaseName;
    }

    @Override
    public void execute(CommandContext context) {
        List<Forest> forests = this.buildForests(context, false);
        if (context.getAppConfig().getCmaConfig().isDeployForests() && !forests.isEmpty() && this.cmaEndpointExists(context)) {
            this.createForestsViaCma(context, forests);
        } else {
            this.createForestsViaForestEndpoint(context, forests);
        }
    }

    protected void createForestsViaCma(CommandContext context, List<Forest> forests) {
        Configuration config = new Configuration();
        forests.forEach(forest -> config.addForest(forest.toObjectNode()));
        new Configurations(config).submit(context.getManageClient());
    }

    protected void createForestsViaForestEndpoint(CommandContext context, List<Forest> forests) {
        ForestManager forestManager = new ForestManager(context.getManageClient());
        for (Forest f : forests) {
            forestManager.save(f.getJson());
        }
    }

    public List<Forest> buildForests(CommandContext context, boolean includeReplicas) {
        List<Forest> existingPrimaryForests = null;
        Map<String, List<Forest>> mapOfPrimaryForests = context.getMapOfPrimaryForests();
        if (mapOfPrimaryForests != null && mapOfPrimaryForests.containsKey(this.databaseName)) {
            existingPrimaryForests = mapOfPrimaryForests.get(this.databaseName);
        }
        if (existingPrimaryForests == null) {
            existingPrimaryForests = this.getExistingPrimaryForests(context, this.databaseName);
        }
        return this.buildForests(context, includeReplicas, existingPrimaryForests);
    }

    protected List<Forest> buildForests(CommandContext context, boolean includeReplicas, List<Forest> existingPrimaryForests) {
        int count;
        Map<String, Integer> map;
        ForestHostNames forestHostNames = this.determineHostNamesForForest(context, existingPrimaryForests);
        String template = this.buildForestTemplate(context, new ForestManager(context.getManageClient()));
        ForestPlan forestPlan = new ForestPlan(this.databaseName, forestHostNames.getPrimaryForestHostNames()).withReplicaHostNames(forestHostNames.getReplicaForestHostNames()).withTemplate(template).withForestsPerDataDirectory(this.forestsPerHost).withExistingForests(existingPrimaryForests);
        if (includeReplicas && (map = context.getAppConfig().getDatabaseNamesAndReplicaCounts()) != null && map.containsKey(this.databaseName) && (count = map.get(this.databaseName).intValue()) > 0) {
            forestPlan.withReplicaCount(count);
        }
        return this.forestBuilder.buildForests(forestPlan, context.getAppConfig());
    }

    @Deprecated
    protected List<Forest> getExistingPrimaryForests(CommandContext context, String databaseName) {
        List<String> forestIds = new DatabaseManager(context.getManageClient()).getPrimaryForestIds(databaseName);
        ForestManager forestMgr = new ForestManager(context.getManageClient());
        DefaultResourceMapper mapper = new DefaultResourceMapper(new API(context.getManageClient()));
        ArrayList<Forest> forests = new ArrayList<Forest>();
        for (String forestId : forestIds) {
            String json = forestMgr.getPropertiesAsJson(forestId, new String[0]);
            forests.add(mapper.readResource(json, Forest.class));
        }
        return forests;
    }

    protected String buildForestTemplate(CommandContext context, ForestManager forestManager) {
        String payload = null;
        if (this.forestFilename != null) {
            for (ConfigDir configDir : context.getAppConfig().getConfigDirs()) {
                File f;
                File dir = configDir.getForestsDir();
                if (!dir.exists() || !(f = new File(dir, this.forestFilename)).exists()) continue;
                payload = this.copyFileToString(f);
            }
        }
        if (payload == null && StringUtils.hasText((String)this.forestPayload)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Creating forests using configured payload: " + this.forestPayload);
            }
            payload = this.forestPayload;
        }
        if (payload != null) {
            return this.adjustPayloadBeforeSavingResource(context, null, payload);
        }
        return null;
    }

    protected ForestHostNames determineHostNamesForForest(CommandContext context, List<Forest> existingPrimaryForests) {
        if (this.hostCalculator == null) {
            this.hostCalculator = new DefaultHostCalculator(new DefaultHostNameProvider(context.getManageClient()));
        }
        if (!this.createForestsOnEachHost) {
            context.getAppConfig().addDatabaseWithForestsOnOneHost(this.databaseName);
        }
        return this.hostCalculator.calculateHostNames(this.databaseName, context, existingPrimaryForests);
    }

    public int getForestsPerHost() {
        return this.forestsPerHost;
    }

    public void setForestsPerHost(int forestsPerHost) {
        this.forestsPerHost = forestsPerHost;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getForestFilename() {
        return this.forestFilename;
    }

    public void setForestFilename(String forestFilename) {
        this.forestFilename = forestFilename;
    }

    public String getForestPayload() {
        return this.forestPayload;
    }

    public void setForestPayload(String forestPayload) {
        this.forestPayload = forestPayload;
    }

    @Deprecated
    public boolean isCreateForestsOnEachHost() {
        return this.createForestsOnEachHost;
    }

    @Deprecated
    public void setCreateForestsOnEachHost(boolean createForestsOnEachHost) {
        this.createForestsOnEachHost = createForestsOnEachHost;
    }

    public void setHostCalculator(HostCalculator hostCalculator) {
        this.hostCalculator = hostCalculator;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setForestBuilder(ForestBuilder forestBuilder) {
        this.forestBuilder = forestBuilder;
    }
}

