/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.AppConfigFactory;
import com.marklogic.appdeployer.CmaConfig;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.util.JavaClientUtil;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.ext.SecurityContextType;
import com.marklogic.mgmt.util.PropertySource;
import com.marklogic.mgmt.util.PropertySourceFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class DefaultAppConfigFactory
extends PropertySourceFactory
implements AppConfigFactory {
    private File projectDir;
    private Map<String, BiConsumer<AppConfig, String>> propertyConsumerMap;

    public DefaultAppConfigFactory() {
        this.initialize();
    }

    public DefaultAppConfigFactory(PropertySource propertySource) {
        super(propertySource);
        this.initialize();
    }

    @Override
    public AppConfig newAppConfig() {
        AppConfig appConfig = new AppConfig(this.projectDir);
        for (String propertyName : this.propertyConsumerMap.keySet()) {
            String value = this.getProperty(propertyName);
            if (value == null) continue;
            try {
                this.propertyConsumerMap.get(propertyName).accept(appConfig, value);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(this.format("Unable to parse value '%s' for property '%s'; cause: %s", new Object[]{value, propertyName, ex.getMessage()}), ex);
            }
        }
        return appConfig;
    }

    public void initialize() {
        this.propertyConsumerMap = new LinkedHashMap<String, BiConsumer<AppConfig, String>>();
        this.propertyConsumerMap.put("mlCatchDeployExceptions", (config, prop) -> {
            this.logger.info("Catch deploy exceptions: " + prop);
            config.setCatchDeployExceptions(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlCatchUndeployExceptions", (config, prop) -> {
            this.logger.info("Catch undeploy exceptions: " + prop);
            config.setCatchUndeployExceptions(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlMergeResources", (config, prop) -> {
            this.logger.info("Merge resources before saving them: " + prop);
            config.setMergeResources(Boolean.parseBoolean(prop));
        });
        String cmaMessage = " with the Configuration Management API (CMA): ";
        this.propertyConsumerMap.put("mlDeployWithCma", (config, prop) -> {
            this.logger.info("Deploy all supported resources and combine requests with the Configuration Management API (CMA): " + prop);
            if (Boolean.parseBoolean(prop)) {
                config.getCmaConfig().enableAll();
            } else {
                config.setCmaConfig(new CmaConfig());
            }
        });
        this.propertyConsumerMap.put("mlOptimizeWithCma", (config, prop) -> {
            this.logger.info("mlOptimizeWithCma is DEPRECATED; please use a property specific to the resource that you want to deploy with CMA");
            config.getCmaConfig().setDeployForests(true);
        });
        this.propertyConsumerMap.put("mlCombineCmaRequests", (config, prop) -> {
            this.logger.info("Combine requests with the Configuration Management API (CMA): " + prop);
            config.getCmaConfig().setCombineRequests(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlDeployAmpsWithCma", (config, prop) -> {
            this.logger.info("Deploy amps with the Configuration Management API (CMA): " + prop);
            config.getCmaConfig().setDeployAmps(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlDeployDatabasesWithCma", (config, prop) -> {
            this.logger.info("Deploy databases and forests with the Configuration Management API (CMA): " + prop);
            config.getCmaConfig().setDeployDatabases(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlDeployForestsWithCma", (config, prop) -> {
            this.logger.info("Deploy forests with the Configuration Management API (CMA): " + prop);
            config.getCmaConfig().setDeployForests(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlDeployPrivilegesWithCma", (config, prop) -> {
            this.logger.info("Deploy privileges with the Configuration Management API (CMA): " + prop);
            config.getCmaConfig().setDeployPrivileges(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlDeployProtectedPathsWithCma", (config, prop) -> {
            this.logger.info("Deploy protected paths with the Configuration Management API (CMA): " + prop);
            config.getCmaConfig().setDeployProtectedPaths(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlDeployQueryRolesetsWithCma", (config, prop) -> {
            this.logger.info("Deploy query rolesets with the Configuration Management API (CMA): " + prop);
            config.getCmaConfig().setDeployQueryRolesets(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlDeployRolesWithCma", (config, prop) -> {
            this.logger.info("Deploy servers with the Configuration Management API (CMA): " + prop);
            config.getCmaConfig().setDeployRoles(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlDeployServersWithCma", (config, prop) -> {
            this.logger.info("Deploy servers with the Configuration Management API (CMA): " + prop);
            config.getCmaConfig().setDeployServers(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlDeployUsersWithCma", (config, prop) -> {
            this.logger.info("Deploy users with the Configuration Management API (CMA): " + prop);
            config.getCmaConfig().setDeployUsers(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlAddHostNameTokens", (config, prop) -> {
            this.logger.info("Add host names to the custom tokens map: " + prop);
            config.setAddHostNameTokens(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlAppName", (config, prop) -> {
            this.logger.info("App name: " + prop);
            config.setName((String)prop);
        });
        this.propertyConsumerMap.put("mlConfigPaths", (config, prop) -> {
            this.logger.info("Config paths: " + prop);
            ArrayList<ConfigDir> list = new ArrayList<ConfigDir>();
            for (String path : prop.split(",")) {
                list.add(this.buildConfigDir(path));
            }
            config.setConfigDirs(list);
        });
        this.propertyConsumerMap.put("mlConfigDir", (config, prop) -> {
            this.logger.info("mlConfigDir is deprecated; please use mlConfigPath; Config dir: " + prop);
            config.setConfigDir(this.buildConfigDir((String)prop));
        });
        this.propertyConsumerMap.put("mlConfigPath", (config, prop) -> {
            this.logger.info("Config path: " + prop);
            config.setConfigDir(this.buildConfigDir((String)prop));
        });
        this.propertyConsumerMap.put("mlHost", (config, prop) -> {
            this.logger.info("App host: " + prop);
            config.setHost((String)prop);
        });
        this.propertyConsumerMap.put("mlCloudApiKey", (config, prop) -> {
            this.logger.info("Setting cloud API key");
            config.setCloudApiKey((String)prop);
        });
        this.propertyConsumerMap.put("mlKeyStorePath", (config, prop) -> {
            this.logger.info("REST and App-Services key store path: " + prop);
            config.setRestKeyStorePath((String)prop);
            config.setAppServicesKeyStorePath((String)prop);
        });
        this.propertyConsumerMap.put("mlKeyStorePassword", (config, prop) -> {
            config.setRestKeyStorePassword((String)prop);
            config.setAppServicesKeyStorePassword((String)prop);
        });
        this.propertyConsumerMap.put("mlKeyStoreType", (config, prop) -> {
            this.logger.info("REST and App-Services key store type: " + prop);
            config.setRestKeyStoreType((String)prop);
            config.setAppServicesKeyStoreType((String)prop);
        });
        this.propertyConsumerMap.put("mlKeyStoreAlgorithm", (config, prop) -> {
            this.logger.info("REST and App-Services key store algorithm: " + prop);
            config.setRestKeyStoreAlgorithm((String)prop);
            config.setAppServicesKeyStoreAlgorithm((String)prop);
        });
        this.propertyConsumerMap.put("mlTrustStorePath", (config, prop) -> {
            this.logger.info("REST and App-Services trust store path: " + prop);
            config.setRestTrustStorePath((String)prop);
            config.setAppServicesTrustStorePath((String)prop);
        });
        this.propertyConsumerMap.put("mlTrustStorePassword", (config, prop) -> {
            config.setRestTrustStorePassword((String)prop);
            config.setAppServicesTrustStorePassword((String)prop);
        });
        this.propertyConsumerMap.put("mlTrustStoreType", (config, prop) -> {
            this.logger.info("REST and App-Services trust store type: " + prop);
            config.setRestTrustStoreType((String)prop);
            config.setAppServicesTrustStoreType((String)prop);
        });
        this.propertyConsumerMap.put("mlTrustStoreAlgorithm", (config, prop) -> {
            this.logger.info("REST and App-Services trust store algorithm: " + prop);
            config.setRestTrustStoreAlgorithm((String)prop);
            config.setAppServicesTrustStoreAlgorithm((String)prop);
        });
        this.propertyConsumerMap.put("mlAppServicesPort", (config, prop) -> {
            this.logger.info("App services port: {}", prop);
            config.setAppServicesPort(this.propertyToInteger("mlAppServicesPort", (String)prop));
        });
        this.propertyConsumerMap.put("mlAppServicesUsername", (config, prop) -> {
            this.logger.info("App Services username: " + prop);
            config.setAppServicesUsername((String)prop);
        });
        this.propertyConsumerMap.put("mlAppServicesPassword", (config, prop) -> config.setAppServicesPassword((String)prop));
        this.propertyConsumerMap.put("mlAppServicesAuthentication", (config, prop) -> {
            this.logger.info("App Services authentication: " + prop);
            config.setAppServicesSecurityContextType(SecurityContextType.valueOf((String)prop.toUpperCase()));
        });
        this.propertyConsumerMap.put("mlAppServicesCertFile", (config, prop) -> {
            this.logger.info("App Services certificate file: " + prop);
            config.setAppServicesCertFile((String)prop);
        });
        this.propertyConsumerMap.put("mlAppServicesCertPassword", (config, prop) -> config.setAppServicesCertPassword((String)prop));
        this.propertyConsumerMap.put("mlAppServicesConnectionType", (config, prop) -> {
            this.logger.info("App Services connection type: " + prop);
            config.setAppServicesConnectionType(DatabaseClient.ConnectionType.valueOf((String)prop));
        });
        this.propertyConsumerMap.put("mlAppServicesExternalName", (config, prop) -> {
            this.logger.info("App Services external name: " + prop);
            config.setAppServicesExternalName((String)prop);
        });
        this.propertyConsumerMap.put("mlAppServicesSamlToken", (config, prop) -> config.setAppServicesSamlToken((String)prop));
        this.propertyConsumerMap.put("mlAppServicesSimpleSsl", (config, prop) -> {
            if (StringUtils.hasText((String)prop) && !"false".equalsIgnoreCase((String)prop)) {
                if ("true".equalsIgnoreCase((String)prop)) {
                    config.setAppServicesSimpleSslConfig();
                } else {
                    config.setAppServicesSimpleSslConfig((String)prop);
                }
                String protocol = config.getAppServicesSslContext().getProtocol();
                this.logger.info(this.format("Using protocol '%s' and 'ANY' hostname verifier for authenticating against the App-Services server", new Object[]{protocol}));
            }
        });
        this.propertyConsumerMap.put("mlAppServicesSslProtocol", (config, prop) -> {
            this.logger.info("Using SSL protocol for App-Services server: " + prop);
            config.setAppServicesSslProtocol((String)prop);
        });
        this.propertyConsumerMap.put("mlAppServicesSslHostnameVerifier", (config, prop) -> {
            this.logger.info("App-Services SSL hostname verifier: " + prop);
            config.setAppServicesSslHostnameVerifier(JavaClientUtil.toSSLHostnameVerifier(prop));
        });
        this.propertyConsumerMap.put("mlAppServicesUseDefaultKeystore", (config, prop) -> {
            this.logger.info("Using default JVM keystore for SSL for App-Services server: " + prop);
            config.setAppServicesUseDefaultKeystore(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlAppServicesTrustManagementAlgorithm", (config, prop) -> {
            this.logger.info("Using trust management algorithm for SSL for App-Services server: " + prop);
            config.setAppServicesTrustManagementAlgorithm((String)prop);
        });
        this.propertyConsumerMap.put("mlCloudBasePath", (config, prop) -> {
            String defaultPath = prop + "/app-services";
            this.logger.info("App-Services base path: " + defaultPath);
            config.setAppServicesBasePath(defaultPath);
        });
        this.propertyConsumerMap.put("mlAppServicesBasePath", (config, prop) -> {
            String cloudBasePath = this.getProperty("mlCloudBasePath");
            String appServicesPath = StringUtils.hasText((String)cloudBasePath) ? cloudBasePath + prop : prop;
            this.logger.info("App-Services base path: " + appServicesPath);
            config.setAppServicesBasePath(appServicesPath);
        });
        this.propertyConsumerMap.put("mlAppServicesKeyStorePath", (config, prop) -> {
            this.logger.info("App-Services key store path: " + prop);
            config.setAppServicesKeyStorePath((String)prop);
        });
        this.propertyConsumerMap.put("mlAppServicesKeyStorePassword", (config, prop) -> config.setAppServicesKeyStorePassword((String)prop));
        this.propertyConsumerMap.put("mlAppServicesKeyStoreType", (config, prop) -> {
            this.logger.info("App-Services key store type: " + prop);
            config.setAppServicesKeyStoreType((String)prop);
        });
        this.propertyConsumerMap.put("mlAppServicesKeyStoreAlgorithm", (config, prop) -> {
            this.logger.info("App-Services key store algorithm: " + prop);
            config.setAppServicesKeyStoreAlgorithm((String)prop);
        });
        this.propertyConsumerMap.put("mlAppServicesTrustStorePath", (config, prop) -> {
            this.logger.info("App-Services trust store path: " + prop);
            config.setAppServicesTrustStorePath((String)prop);
        });
        this.propertyConsumerMap.put("mlAppServicesTrustStorePassword", (config, prop) -> config.setAppServicesTrustStorePassword((String)prop));
        this.propertyConsumerMap.put("mlAppServicesTrustStoreType", (config, prop) -> {
            this.logger.info("App-Services trust store type: " + prop);
            config.setAppServicesTrustStoreType((String)prop);
        });
        this.propertyConsumerMap.put("mlAppServicesTrustStoreAlgorithm", (config, prop) -> {
            this.logger.info("App-Services trust store algorithm: " + prop);
            config.setAppServicesTrustStoreAlgorithm((String)prop);
        });
        this.propertyConsumerMap.put("mlNoRestServer", (config, prop) -> {
            this.logger.info("Not creating REST server if no REST config file is found");
            config.setNoRestServer(true);
        });
        this.propertyConsumerMap.put("mlRestPort", (config, prop) -> {
            this.logger.info("App REST port: " + prop);
            config.setRestPort(this.propertyToInteger("mlRestPort", (String)prop));
        });
        this.propertyConsumerMap.put("mlRestAdminUsername", (config, prop) -> {
            this.logger.info("REST admin username: " + prop);
            config.setRestAdminUsername((String)prop);
            if (!this.propertyExists("mlAppServicesUsername")) {
                this.logger.info("App Services username: " + prop);
                config.setAppServicesUsername((String)prop);
            }
        });
        this.propertyConsumerMap.put("mlRestAdminPassword", (config, prop) -> {
            config.setRestAdminPassword((String)prop);
            if (!this.propertyExists("mlAppServicesPassword")) {
                config.setAppServicesPassword((String)prop);
            }
        });
        this.propertyConsumerMap.put("mlRestConnectionType", (config, prop) -> {
            this.logger.info("REST connection type: " + prop);
            config.setRestConnectionType(DatabaseClient.ConnectionType.valueOf((String)prop));
        });
        this.propertyConsumerMap.put("mlRestAuthentication", (config, prop) -> {
            this.logger.info("REST authentication: " + prop);
            config.setRestSecurityContextType(SecurityContextType.valueOf((String)prop.toUpperCase()));
        });
        this.propertyConsumerMap.put("mlRestCertFile", (config, prop) -> {
            this.logger.info("REST certificate file: " + prop);
            config.setRestCertFile((String)prop);
        });
        this.propertyConsumerMap.put("mlRestCertPassword", (config, prop) -> config.setRestCertPassword((String)prop));
        this.propertyConsumerMap.put("mlRestExternalName", (config, prop) -> {
            this.logger.info("REST external name: " + prop);
            config.setRestExternalName((String)prop);
        });
        this.propertyConsumerMap.put("mlRestSamlToken", (config, prop) -> config.setRestSamlToken((String)prop));
        this.propertyConsumerMap.put("mlRestBasePath", (config, prop) -> {
            String cloudBasePath = this.getProperty("mlCloudBasePath");
            String restPath = StringUtils.hasText((String)cloudBasePath) ? cloudBasePath + prop : prop;
            this.logger.info("REST base path: " + restPath);
            config.setRestBasePath(restPath);
        });
        this.propertyConsumerMap.put("mlTestRestBasePath", (config, prop) -> {
            String cloudBasePath = this.getProperty("mlCloudBasePath");
            String testRestPath = StringUtils.hasText((String)cloudBasePath) ? cloudBasePath + prop : prop;
            this.logger.info("Test REST base path: " + testRestPath);
            config.setTestRestBasePath(testRestPath);
        });
        this.propertyConsumerMap.put("mlAuthentication", (config, prop) -> {
            if (!this.propertyExists("mlAppServicesAuthentication")) {
                this.logger.info("App Services authentication: " + prop);
                config.setAppServicesSecurityContextType(SecurityContextType.valueOf((String)prop.toUpperCase()));
            }
            if (!this.propertyExists("mlRestAuthentication")) {
                this.logger.info("REST authentication: " + prop);
                config.setRestSecurityContextType(SecurityContextType.valueOf((String)prop.toUpperCase()));
            }
        });
        this.propertyConsumerMap.put("mlSslHostnameVerifier", (config, prop) -> {
            if (!this.propertyExists("mlAppServicesSslHostnameVerifier")) {
                this.logger.info("App-Services SSL hostname verifier: " + prop);
                config.setAppServicesSslHostnameVerifier(JavaClientUtil.toSSLHostnameVerifier(prop));
            }
            if (!this.propertyExists("mlRestSslHostnameVerifier")) {
                this.logger.info("REST SSL hostname verifier: " + prop);
                config.setRestSslHostnameVerifier(JavaClientUtil.toSSLHostnameVerifier(prop));
            }
        });
        this.propertyConsumerMap.put("mlSimpleSsl", (config, prop) -> {
            if (StringUtils.hasText((String)prop) && !"false".equalsIgnoreCase((String)prop)) {
                if ("true".equalsIgnoreCase((String)prop)) {
                    config.setSimpleSslConfig();
                } else {
                    config.setSimpleSslConfig((String)prop);
                }
                String protocol = config.getRestSslContext().getProtocol();
                this.logger.info(this.format("Using protocol '%s' and 'ANY' hostname verifier for authenticating against the client REST API server", new Object[]{protocol}));
            }
        });
        this.propertyConsumerMap.put("mlRestSslProtocol", (config, prop) -> {
            this.logger.info("Using SSL protocol for client REST API server: " + prop);
            config.setRestSslProtocol((String)prop);
        });
        this.propertyConsumerMap.put("mlRestSslHostnameVerifier", (config, prop) -> {
            this.logger.info("REST SSL hostname verifier: " + prop);
            config.setRestSslHostnameVerifier(JavaClientUtil.toSSLHostnameVerifier(prop));
        });
        this.propertyConsumerMap.put("mlRestUseDefaultKeystore", (config, prop) -> {
            this.logger.info("Using default JVM keystore for SSL for client REST API server: " + prop);
            config.setRestUseDefaultKeystore(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlRestTrustManagementAlgorithm", (config, prop) -> {
            this.logger.info("Using trust management algorithm for SSL for client REST API server: " + prop);
            config.setRestTrustManagementAlgorithm((String)prop);
        });
        this.propertyConsumerMap.put("mlRestKeyStorePath", (config, prop) -> {
            this.logger.info("REST key store path: " + prop);
            config.setRestKeyStorePath((String)prop);
        });
        this.propertyConsumerMap.put("mlRestKeyStorePassword", (config, prop) -> config.setRestKeyStorePassword((String)prop));
        this.propertyConsumerMap.put("mlRestKeyStoreType", (config, prop) -> {
            this.logger.info("REST key store type: " + prop);
            config.setRestKeyStoreType((String)prop);
        });
        this.propertyConsumerMap.put("mlRestKeyStoreAlgorithm", (config, prop) -> {
            this.logger.info("REST key store algorithm: " + prop);
            config.setRestKeyStoreAlgorithm((String)prop);
        });
        this.propertyConsumerMap.put("mlRestTrustStorePath", (config, prop) -> {
            this.logger.info("REST trust store path: " + prop);
            config.setRestTrustStorePath((String)prop);
        });
        this.propertyConsumerMap.put("mlRestTrustStorePassword", (config, prop) -> config.setRestTrustStorePassword((String)prop));
        this.propertyConsumerMap.put("mlRestTrustStoreType", (config, prop) -> {
            this.logger.info("REST trust store type: " + prop);
            config.setRestTrustStoreType((String)prop);
        });
        this.propertyConsumerMap.put("mlRestTrustStoreAlgorithm", (config, prop) -> {
            this.logger.info("REST trust store algorithm: " + prop);
            config.setRestTrustStoreAlgorithm((String)prop);
        });
        this.propertyConsumerMap.put("mlUsername", (config, prop) -> {
            if (!this.propertyExists("mlRestAdminUsername")) {
                this.logger.info("REST admin username: " + prop);
                config.setRestAdminUsername((String)prop);
            }
            if (!this.propertyExists("mlAppServicesUsername")) {
                this.logger.info("App Services username: " + prop);
                config.setAppServicesUsername((String)prop);
            }
        });
        this.propertyConsumerMap.put("mlPassword", (config, prop) -> {
            if (!this.propertyExists("mlRestAdminPassword")) {
                config.setRestAdminPassword((String)prop);
            }
            if (!this.propertyExists("mlAppServicesPassword")) {
                config.setAppServicesPassword((String)prop);
            }
        });
        this.propertyConsumerMap.put("mlRestServerName", (config, prop) -> {
            this.logger.info("REST server name: " + prop);
            config.setRestServerName((String)prop);
        });
        this.propertyConsumerMap.put("mlTestRestPort", (config, prop) -> {
            this.logger.info("Test REST port: " + prop);
            config.setTestRestPort(this.propertyToInteger("mlTestRestPort", (String)prop));
        });
        this.propertyConsumerMap.put("mlTestRestServerName", (config, prop) -> {
            this.logger.info("Test REST server name: " + prop);
            config.setTestRestServerName((String)prop);
        });
        this.propertyConsumerMap.put("mlTestContentDatabaseName", (config, prop) -> {
            this.logger.info("Test content database name: " + prop);
            config.setTestContentDatabaseName((String)prop);
        });
        this.propertyConsumerMap.put("mlSchemasPath", (config, prop) -> {
            this.logger.info("mlSchemasPath is deprecated as of version 3.13.0; please use mlSchemaPaths instead; schemas path: " + prop);
            config.setSchemaPaths(this.buildPathListFromCommaDelimitedString((String)prop));
        });
        this.propertyConsumerMap.put("mlSchemaPaths", (config, prop) -> {
            this.logger.info("Schema paths: " + prop);
            config.setSchemaPaths(this.buildPathListFromCommaDelimitedString((String)prop));
        });
        this.propertyConsumerMap.put("mlTdeValidationEnabled", (config, prop) -> {
            this.logger.info("TDE validation enabled: " + prop);
            config.setTdeValidationEnabled(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlSchemasDatabaseName", (config, prop) -> {
            this.logger.info("Schemas database name: " + prop);
            config.setSchemasDatabaseName((String)prop);
        });
        this.propertyConsumerMap.put("mlTriggersDatabaseName", (config, prop) -> {
            this.logger.info("Triggers database name: " + prop);
            config.setTriggersDatabaseName((String)prop);
        });
        this.propertyConsumerMap.put("mlCpfDatabaseName", (config, prop) -> {
            this.logger.info("CPF database name: " + prop);
            config.setCpfDatabaseName((String)prop);
        });
        this.propertyConsumerMap.put("mlContentForestsPerHost", (config, prop) -> {
            this.logger.info("Content forests per host: " + prop);
            config.setContentForestsPerHost(this.propertyToInteger("mlContentForestsPerHost", (String)prop));
        });
        this.propertyConsumerMap.put("mlCreateForests", (config, prop) -> {
            this.logger.info("Create forests for each deployed database: " + prop);
            config.setCreateForests(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlForestsPerHost", (config, prop) -> {
            this.logger.info("Forests per host: " + prop);
            String[] tokens = prop.split(",");
            for (int i = 0; i < tokens.length; i += 2) {
                config.getForestCounts().put(tokens[i], this.propertyToInteger("mlForestsPerHost", tokens[i + 1]));
            }
        });
        this.propertyConsumerMap.put("mlDatabaseNamesAndReplicaCounts", (config, prop) -> {
            this.logger.info("Database names and replica counts: " + prop);
            String[] tokens = prop.split(",");
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (int i = 0; i < tokens.length; i += 2) {
                map.put(tokens[i], this.propertyToInteger("mlDatabaseNamesAndReplicaCounts", tokens[i + 1]));
            }
            config.setDatabaseNamesAndReplicaCounts(map);
        });
        this.propertyConsumerMap.put("mlDatabasesWithForestsOnOneHost", (config, prop) -> {
            this.logger.info("Databases that will have their forest(s) created on a single host: " + prop);
            String[] names = prop.split(",");
            HashSet<String> set = new HashSet<String>();
            set.addAll(Arrays.asList(names));
            config.setDatabasesWithForestsOnOneHost(set);
        });
        this.propertyConsumerMap.put("mlDatabaseGroups", (config, prop) -> {
            this.logger.info("Databases and the groups containing the hosts that their forests will be created on: " + prop);
            config.setDatabaseGroups(this.buildMapOfListsFromDelimitedString((String)prop));
        });
        this.propertyConsumerMap.put("mlHostGroups", (config, prop) -> {
            this.logger.info("Hosts will be assigned to groups: " + prop);
            config.setHostGroups(this.buildMapFromCommaDelimitedString((String)prop));
        });
        this.propertyConsumerMap.put("mlDatabaseHosts", (config, prop) -> {
            this.logger.info("Databases and the hosts that their forests will be created on: " + prop);
            config.setDatabaseHosts(this.buildMapOfListsFromDelimitedString((String)prop));
        });
        this.propertyConsumerMap.put("mlForestDataDirectory", (config, prop) -> {
            this.logger.info("Default forest data directory for all databases: " + prop);
            config.setForestDataDirectory((String)prop);
        });
        this.propertyConsumerMap.put("mlForestFastDataDirectory", (config, prop) -> {
            this.logger.info("Default forest fast data directory for all databases: " + prop);
            config.setForestFastDataDirectory((String)prop);
        });
        this.propertyConsumerMap.put("mlForestLargeDataDirectory", (config, prop) -> {
            this.logger.info("Default forest large data directory for all databases: " + prop);
            config.setForestLargeDataDirectory((String)prop);
        });
        this.propertyConsumerMap.put("mlReplicaForestDataDirectory", (config, prop) -> {
            this.logger.info("Default replica forest data directory for all databases: " + prop);
            config.setReplicaForestDataDirectory((String)prop);
        });
        this.propertyConsumerMap.put("mlReplicaForestLargeDataDirectory", (config, prop) -> {
            this.logger.info("Default replica forest large data directory for all databases: " + prop);
            config.setReplicaForestLargeDataDirectory((String)prop);
        });
        this.propertyConsumerMap.put("mlReplicaForestFastDataDirectory", (config, prop) -> {
            this.logger.info("Default replica forest fast data directory for all databases: " + prop);
            config.setReplicaForestFastDataDirectory((String)prop);
        });
        this.propertyConsumerMap.put("mlDatabaseDataDirectories", (config, prop) -> {
            this.logger.info("Databases and forest data directories: " + prop);
            config.setDatabaseDataDirectories(this.buildMapOfListsFromDelimitedString((String)prop));
        });
        this.propertyConsumerMap.put("mlDatabaseFastDataDirectories", (config, prop) -> {
            this.logger.info("Databases and forest fast data directories: " + prop);
            config.setDatabaseFastDataDirectories(this.buildMapFromCommaDelimitedString((String)prop));
        });
        this.propertyConsumerMap.put("mlDatabaseLargeDataDirectories", (config, prop) -> {
            this.logger.info("Databases and forest large data directories: " + prop);
            config.setDatabaseLargeDataDirectories(this.buildMapFromCommaDelimitedString((String)prop));
        });
        this.propertyConsumerMap.put("mlDatabaseReplicaDataDirectories", (config, prop) -> {
            this.logger.info("Databases and replica forest data directories: " + prop);
            config.setDatabaseReplicaDataDirectories(this.buildMapOfListsFromDelimitedString((String)prop));
        });
        this.propertyConsumerMap.put("mlDatabaseReplicaFastDataDirectories", (config, prop) -> {
            this.logger.info("Databases and replica forest fast data directories: " + prop);
            config.setDatabaseReplicaFastDataDirectories(this.buildMapFromCommaDelimitedString((String)prop));
        });
        this.propertyConsumerMap.put("mlDatabaseReplicaLargeDataDirectories", (config, prop) -> {
            this.logger.info("Databases and replica forest large data directories: " + prop);
            config.setDatabaseReplicaLargeDataDirectories(this.buildMapFromCommaDelimitedString((String)prop));
        });
        this.propertyConsumerMap.put("mlDeleteForests", (config, prop) -> {
            this.logger.info("Delete forests when a database is deleted: " + prop);
            config.setDeleteForests(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlDeleteReplicas", (config, prop) -> {
            this.logger.info("Delete replicas when a database is deleted: " + prop);
            config.setDeleteReplicas(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlContentDatabaseName", (config, prop) -> {
            this.logger.info("Content database name: " + prop);
            config.setContentDatabaseName((String)prop);
        });
        this.propertyConsumerMap.put("mlModulesDatabaseName", (config, prop) -> {
            this.logger.info("Modules database name: " + prop);
            config.setModulesDatabaseName((String)prop);
        });
        this.propertyConsumerMap.put("mlFlexrepPath", (config, prop) -> {
            this.logger.info("Flexrep path: " + prop);
            config.setFlexrepPath((String)prop);
        });
        this.propertyConsumerMap.put("mlGroupName", (config, prop) -> {
            this.logger.info("Group name: " + prop);
            config.setGroupName((String)prop);
        });
        this.propertyConsumerMap.put("mlModulePermissions", (config, prop) -> {
            this.logger.info("Module permissions: " + prop);
            config.setModulePermissions((String)prop);
        });
        this.propertyConsumerMap.put("mlAdditionalBinaryExtensions", (config, prop) -> {
            String[] values = prop.split(",");
            this.logger.info("Additional binary extensions for loading modules: " + Arrays.asList(values));
            config.setAdditionalBinaryExtensions(values);
        });
        this.propertyConsumerMap.put("mlReplaceTokensInModules", (config, prop) -> {
            this.logger.info("Replace tokens in modules: " + prop);
            config.setReplaceTokensInModules(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlUseRoxyTokenPrefix", (config, prop) -> {
            this.logger.info("Use Roxy token prefix of '@ml.': " + prop);
            config.setUseRoxyTokenPrefix(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlModulePaths", (config, prop) -> {
            this.logger.info("Module paths: " + prop);
            config.setModulePaths(this.buildPathListFromCommaDelimitedString((String)prop));
        });
        this.propertyConsumerMap.put("mlModuleTimestampsPath", (config, prop) -> {
            if (prop.trim().length() == 0) {
                this.logger.info("Disabling use of module timestamps file");
                config.setModuleTimestampsPath(null);
            } else {
                this.logger.info("Module timestamps path: " + prop);
                config.setModuleTimestampsPath((String)prop);
            }
        });
        this.propertyConsumerMap.put("mlModuleTimestampsUseHost", (config, prop) -> {
            this.logger.info("Use host in module timestamps file: " + prop);
            config.setModuleTimestampsUseHost(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlModuleUriPrefix", (config, prop) -> {
            this.logger.info("Will added prefix to the URI of each module: " + prop);
            config.setModuleUriPrefix((String)prop);
        });
        this.propertyConsumerMap.put("mlModulesRegex", (config, prop) -> {
            this.logger.info("Including module filenames matching regex: " + prop);
            config.setModuleFilenamesIncludePattern(Pattern.compile(prop));
        });
        this.propertyConsumerMap.put("mlBulkLoadAssets", (config, prop) -> {
            this.logger.info("Bulk load modules: " + prop);
            config.setBulkLoadAssets(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlStaticCheckAssets", (config, prop) -> {
            this.logger.info("Statically check asset modules: " + prop);
            config.setStaticCheckAssets(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlStaticCheckLibraryAssets", (config, prop) -> {
            this.logger.info("Statically check asset library modules: " + prop);
            config.setStaticCheckLibraryAssets(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlDeleteTestModules", (config, prop) -> {
            this.logger.info("Delete test modules: " + prop);
            config.setDeleteTestModules(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlDeleteTestModulesPattern", (config, prop) -> {
            this.logger.info("Delete test modules pattern: " + prop);
            config.setDeleteTestModulesPattern((String)prop);
        });
        this.propertyConsumerMap.put("mlModulesLoaderThreadCount", (config, prop) -> {
            this.logger.info("Modules loader thread count: " + prop);
            config.setModulesLoaderThreadCount(this.propertyToInteger("mlModulesLoaderThreadCount", (String)prop));
        });
        this.propertyConsumerMap.put("mlModulesLoaderBatchSize", (config, prop) -> {
            this.logger.info("Modules loader batch size: " + prop);
            config.setModulesLoaderBatchSize(this.propertyToInteger("mlModulesLoaderBatchSize", (String)prop));
        });
        this.propertyConsumerMap.put("mlCascadeCollections", (config, prop) -> {
            this.logger.info("Cascade collections.properties configuration when loading data, modules, and schemas: " + prop);
            config.setCascadeCollections(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlCascadePermissions", (config, prop) -> {
            this.logger.info("Cascade permissions.properties configuration when loading data, modules, and schemas: " + prop);
            config.setCascadePermissions(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlModelsDatabase", (config, prop) -> {
            this.logger.info("Entity Services models database: " + prop);
            config.setModelsDatabase((String)prop);
        });
        this.propertyConsumerMap.put("mlModelsPath", (config, prop) -> {
            this.logger.info("Entity Services models path: " + prop);
            config.setModelsPath((String)prop);
        });
        this.propertyConsumerMap.put("mlInstanceConverterPath", (config, prop) -> {
            this.logger.info("Entity Services instance converter path: " + prop);
            config.setInstanceConverterPath((String)prop);
        });
        this.propertyConsumerMap.put("mlGenerateInstanceConverter", (config, prop) -> {
            this.logger.info("Entity Services generate instance converter: " + prop);
            config.setGenerateInstanceConverter(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlGenerateSchema", (config, prop) -> {
            this.logger.info("Entity Services generate schema: " + prop);
            config.setGenerateSchema(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlGenerateSearchOptions", (config, prop) -> {
            this.logger.info("Entity Services generate search options: " + prop);
            config.setGenerateSearchOptions(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlGenerateDatabaseProperties", (config, prop) -> {
            this.logger.info("Entity Services generate database properties: " + prop);
            config.setGenerateDatabaseProperties(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlGenerateExtractionTemplate", (config, prop) -> {
            this.logger.info("Entity Services generate extraction template: " + prop);
            config.setGenerateExtractionTemplate(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlResourceFilenamesToIgnore", (config, prop) -> {
            String[] values = prop.split(",");
            this.logger.info("Ignoring resource filenames: " + Arrays.asList(values));
            config.setResourceFilenamesToIgnore(values);
        });
        this.propertyConsumerMap.put("mlResourceFilenamesToExcludeRegex", (config, prop) -> {
            this.logger.info("Excluding resource filenames matching regex: " + prop);
            config.setResourceFilenamesExcludePattern(Pattern.compile(prop));
        });
        this.propertyConsumerMap.put("mlResourceFilenamesToIncludeRegex", (config, prop) -> {
            this.logger.info("Including resource filenames matching regex: " + prop);
            config.setResourceFilenamesIncludePattern(Pattern.compile(prop));
        });
        this.propertyConsumerMap.put("mlExcludeProperties", (config, prop) -> {
            String[] values = prop.split(",");
            this.logger.info("Will exclude these properties from all resource payloads: " + Arrays.asList(values));
            config.setExcludeProperties(values);
        });
        this.propertyConsumerMap.put("mlIncludeProperties", (config, prop) -> {
            String[] values = prop.split(",");
            this.logger.info("Will include only these properties in all resource payloads: " + Arrays.asList(values));
            config.setIncludeProperties(values);
        });
        this.propertyConsumerMap.put("mlIncremental", (config, prop) -> {
            this.logger.info("Supported resources will only be deployed if their resource files are new or have been modified since the last deployment: " + prop);
            config.setIncrementalDeploy(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlUpdateMimetypeWhenPropertiesAreEqual", (config, prop) -> {
            this.logger.info("Update mimetype when properties are equal (defaults to false to avoid unnecessary ML restarts): " + prop);
            config.setUpdateMimetypeWhenPropertiesAreEqual(Boolean.parseBoolean(prop));
        });
        this.registerDataLoadingProperties();
        this.registerPluginProperties();
    }

    protected void registerDataLoadingProperties() {
        this.propertyConsumerMap.put("mlDataBatchSize", (config, prop) -> {
            this.logger.info("Batch size for loading data: " + prop);
            config.getDataConfig().setBatchSize(this.propertyToInteger("mlDataBatchSize", (String)prop));
        });
        this.propertyConsumerMap.put("mlDataCollections", (config, prop) -> {
            this.logger.info("Collections that data will be loaded into: " + prop);
            config.getDataConfig().setCollections(prop.split(","));
        });
        this.propertyConsumerMap.put("mlDataDatabaseName", (config, prop) -> {
            this.logger.info("Database that data will be loaded into: " + prop);
            config.getDataConfig().setDatabaseName((String)prop);
        });
        this.propertyConsumerMap.put("mlDataPaths", (config, prop) -> {
            this.logger.info("Paths that data will be loaded from: " + prop);
            ArrayList<String> paths = new ArrayList<String>();
            for (String s : prop.split(",")) {
                String path = this.projectDir != null ? new File(this.projectDir, s).getAbsolutePath() : s;
                paths.add(path);
            }
            config.getDataConfig().setDataPaths(paths);
        });
        this.propertyConsumerMap.put("mlDataLoadingEnabled", (config, prop) -> {
            this.logger.info("Whether data loading is enabled: " + prop);
            config.getDataConfig().setDataLoadingEnabled(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlDataLogUris", (config, prop) -> {
            this.logger.info("Log URIs when loading data: " + prop);
            config.getDataConfig().setLogUris(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlDataPermissions", (config, prop) -> {
            this.logger.info("Permissions to be applied to loaded data: " + prop);
            config.getDataConfig().setPermissions((String)prop);
        });
        this.propertyConsumerMap.put("mlDataReplaceTokens", (config, prop) -> {
            this.logger.info("Whether tokens will be replaced when loading data: " + prop);
            config.getDataConfig().setReplaceTokensInData(Boolean.parseBoolean(prop));
        });
    }

    protected void registerPluginProperties() {
        this.propertyConsumerMap.put("mlPluginDatabaseName", (config, prop) -> {
            this.logger.info("Database that plugins will be loaded into and installed from: " + prop);
            config.getPluginConfig().setDatabaseName((String)prop);
        });
        this.propertyConsumerMap.put("mlPluginInstallationEnabled", (config, prop) -> {
            this.logger.info("Whether plugins will be installed: " + prop);
            config.getPluginConfig().setEnabled(Boolean.parseBoolean(prop));
        });
        this.propertyConsumerMap.put("mlPluginPaths", (config, prop) -> {
            this.logger.info("Paths that plugins will be installed from: " + prop);
            config.getPluginConfig().setPluginPaths(this.buildPathListFromCommaDelimitedString((String)prop));
        });
        this.propertyConsumerMap.put("mlPluginUriPrefix", (config, prop) -> {
            this.logger.info("URI prefix for plugins: " + prop);
            config.getPluginConfig().setUriPrefix((String)prop);
        });
    }

    protected ConfigDir buildConfigDir(String path) {
        File baseDir = this.projectDir != null ? new File(this.projectDir, path) : new File(path);
        return new ConfigDir(baseDir);
    }

    protected List<String> buildPathListFromCommaDelimitedString(String prop) {
        String[] paths = prop.split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (String s : paths) {
            String path = this.projectDir != null ? new File(this.projectDir, s).getAbsolutePath() : s;
            list.add(path);
        }
        return list;
    }

    protected Map<String, String> buildMapFromCommaDelimitedString(String str) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] tokens = str.split(",");
        for (int i = 0; i < tokens.length; i += 2) {
            map.put(tokens[i], tokens[i + 1]);
        }
        return map;
    }

    protected Map<String, List<String>> buildMapOfListsFromDelimitedString(String str) {
        String[] tokens = str.split(",");
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        for (int i = 0; i < tokens.length; i += 2) {
            String dbName = tokens[i];
            String[] hostNames = tokens[i + 1].split("\\|");
            ArrayList<String> names = new ArrayList<String>();
            names.addAll(Arrays.asList(hostNames));
            map.put(dbName, names);
        }
        return map;
    }

    public Map<String, BiConsumer<AppConfig, String>> getPropertyConsumerMap() {
        return this.propertyConsumerMap;
    }

    public void setProjectDir(File projectDir) {
        this.projectDir = projectDir;
    }
}

