/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.datamovement.listener;

import com.marklogic.client.datamovement.ExportToWriterListener;
import com.marklogic.client.document.DocumentRecord;
import com.marklogic.client.io.DOMHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.marker.AbstractReadHandle;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class XmlOutputListener
implements ExportToWriterListener.OutputListener {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean omitXmlDeclaration = true;
    private TransformerFactory transformerFactory = TransformerFactory.newInstance();

    public String generateOutput(DocumentRecord documentRecord) {
        if (Format.XML.equals((Object)documentRecord.getFormat())) {
            return this.convertDocumentToString(((DOMHandle)documentRecord.getContent((AbstractReadHandle)new DOMHandle())).get());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Document '%s' has a format of '%s', so will not attempt to remove the XML declaration from it", documentRecord.getUri(), documentRecord.getFormat().name()));
        }
        return ((StringHandle)documentRecord.getContent((AbstractReadHandle)new StringHandle())).get();
    }

    protected String convertDocumentToString(Document document) {
        try {
            Transformer transformer = this.transformerFactory.newTransformer();
            if (this.omitXmlDeclaration) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(writer));
            return writer.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to serialize XML document to string: " + e.getMessage(), e);
        }
    }

    public void setOmitXmlDeclaration(boolean omitXmlDeclaration) {
        this.omitXmlDeclaration = omitXmlDeclaration;
    }
}

