/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.datamovement.job;

import com.marklogic.client.ext.datamovement.job.AbstractQueryBatcherJob;
import com.marklogic.client.ext.datamovement.listener.SetCollectionsListener;
import java.util.Arrays;

public class SetCollectionsJob
extends AbstractQueryBatcherJob {
    private String[] collections;

    public SetCollectionsJob() {
        this.addRequiredJobProperty("collections", "Comma-delimited list collections to set on selected records", value -> this.setCollections(value.split(",")));
    }

    public SetCollectionsJob(String ... collections) {
        this();
        this.setCollections(collections);
    }

    @Override
    protected String getJobDescription() {
        return "Setting collections " + Arrays.asList(this.collections) + " on documents " + this.getQueryDescription();
    }

    public void setCollections(String ... collections) {
        this.collections = collections;
        this.addUrisReadyListener(new SetCollectionsListener(collections));
    }
}

