/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.datamovement.job;

import com.marklogic.client.datamovement.QueryBatchListener;
import com.marklogic.client.document.ServerTransform;
import com.marklogic.client.ext.datamovement.job.AbstractQueryBatcherJob;
import com.marklogic.client.ext.datamovement.listener.ExportBatchesToZipsListener;
import java.io.File;

public class ExportBatchesToZipsJob
extends AbstractQueryBatcherJob {
    private File exportDir;
    private ExportBatchesToZipsListener exportBatchesToZipsListener;

    public ExportBatchesToZipsJob() {
        this.addRequiredJobProperty("exportPath", "Directory path to which each batch should be written as a zip", value -> this.setExportDir(new File((String)value)));
        this.addJobProperty("filenamePrefix", "Prefix written to the beginning of the filename of each file; defaults to batch-", value -> this.getExportListener().withFilenamePrefix((String)value));
        this.addJobProperty("filenameExtension", "Filename extension for each file; defaults to .zip", value -> this.getExportListener().withFilenameExtension((String)value));
        this.addJobProperty("flattenUri", "Whether or not record URIs are flattened before being used as zip entry names; defaults to false", value -> this.getExportListener().withFlattenUri(Boolean.parseBoolean(value)));
        this.addTransformJobProperty((value, transform) -> this.getExportListener().withTransform((ServerTransform)transform));
        this.addJobProperty("uriPrefix", "Prefix to prepend to each URI it is used as an entry name; applied after a URI is optionally flattened", value -> this.getExportListener().withUriPrefix((String)value));
    }

    public ExportBatchesToZipsJob(File exportDir) {
        this();
        this.setExportDir(exportDir);
    }

    @Override
    protected String getJobDescription() {
        return "Exporting batches of documents " + this.getQueryDescription() + " to files at: " + this.exportDir;
    }

    public ExportBatchesToZipsListener getExportListener() {
        return this.exportBatchesToZipsListener;
    }

    public void setExportDir(File exportDir) {
        this.exportDir = exportDir;
        this.exportBatchesToZipsListener = new ExportBatchesToZipsListener(exportDir);
        this.addUrisReadyListener((QueryBatchListener)this.exportBatchesToZipsListener);
    }

    public File getExportDir() {
        return this.exportDir;
    }
}

