/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.datamovement.consumer;

import com.marklogic.client.document.DocumentRecord;
import com.marklogic.client.io.InputStreamHandle;
import com.marklogic.client.io.marker.AbstractReadHandle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteDocumentToFileConsumer
implements Consumer<DocumentRecord> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private File baseDir;
    private boolean logErrors = true;

    public WriteDocumentToFileConsumer(File baseDir) {
        this.baseDir = baseDir;
        this.baseDir.mkdirs();
    }

    @Override
    public void accept(DocumentRecord documentRecord) {
        String uri = documentRecord.getUri();
        File outputFile = this.getOutputFile(documentRecord);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Writing document with URI " + uri + " to file: " + outputFile);
        }
        try {
            this.writeDocumentToFile(documentRecord, outputFile);
        }
        catch (IOException e) {
            String message = "Unable to write document to file; URI: " + uri + "; file: " + outputFile;
            if (this.logErrors) {
                this.logger.warn(message, (Throwable)e);
            }
            throw new RuntimeException(message, e);
        }
    }

    protected File getOutputFile(DocumentRecord documentRecord) {
        return new File(this.baseDir, documentRecord.getUri());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeDocumentToFile(DocumentRecord documentRecord, File file) throws IOException {
        file.getParentFile().mkdirs();
        try (FileOutputStream fos = new FileOutputStream(file);){
            InputStream in = ((InputStreamHandle)documentRecord.getContent((AbstractReadHandle)new InputStreamHandle())).get();
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = in.read(buffer)) != -1) {
                fos.write(buffer, 0, bytesRead);
            }
            fos.flush();
        }
    }

    protected File getBaseDir() {
        return this.baseDir;
    }

    protected boolean isLogErrors() {
        return this.logErrors;
    }

    public void setLogErrors(boolean logErrors) {
        this.logErrors = logErrors;
    }
}

