/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.datamovement.listener;

import com.marklogic.client.datamovement.ExportListener;
import com.marklogic.client.datamovement.ExportToWriterListener;
import com.marklogic.client.datamovement.QueryBatch;
import com.marklogic.client.ext.datamovement.listener.AbstractExportBatchesListener;
import com.marklogic.client.ext.datamovement.listener.XmlOutputListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.slf4j.LoggerFactory;

public class ExportBatchesToDirectoryListener
extends AbstractExportBatchesListener {
    private File exportDir;
    private boolean includeXmlOutputListener = true;
    private String recordPrefix;
    private String recordSuffix;
    private String fileHeader;
    private String fileFooter;

    public ExportBatchesToDirectoryListener(File exportDir) {
        this.withFilenameExtension(".xml");
        this.exportDir = exportDir;
        this.exportDir.mkdirs();
    }

    @Override
    protected void exportBatch(QueryBatch queryBatch) {
        File file = this.getFileForBatch(queryBatch, this.exportDir);
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            if (this.fileHeader != null) {
                fileWriter.write(this.fileHeader);
            }
            ExportToWriterListener listener = new ExportToWriterListener((Writer)fileWriter);
            this.prepareExportToWriterListener(listener);
            listener.processEvent(queryBatch);
            if (this.fileFooter != null) {
                fileWriter.write(this.fileFooter);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Unable to close FileWriter: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected void prepareExportToWriterListener(ExportToWriterListener listener) {
        super.prepareExportListener((ExportListener)listener);
        if (this.includeXmlOutputListener) {
            listener.onGenerateOutput((ExportToWriterListener.OutputListener)new XmlOutputListener());
        }
        if (this.recordPrefix != null) {
            listener.withRecordPrefix(this.recordPrefix);
        }
        if (this.recordSuffix != null) {
            listener.withRecordSuffix(this.recordSuffix);
        }
    }

    public ExportBatchesToDirectoryListener withRecordPrefix(String recordPrefix) {
        this.recordPrefix = recordPrefix;
        return this;
    }

    public ExportBatchesToDirectoryListener withRecordSuffix(String recordSuffix) {
        this.recordSuffix = recordSuffix;
        return this;
    }

    public ExportBatchesToDirectoryListener withFileHeader(String fileHeader) {
        this.fileHeader = fileHeader;
        return this;
    }

    public ExportBatchesToDirectoryListener withFileFooter(String fileFooter) {
        this.fileFooter = fileFooter;
        return this;
    }

    public ExportBatchesToDirectoryListener withXmlOutputListener(boolean includeXmlOutputListener) {
        this.includeXmlOutputListener = includeXmlOutputListener;
        return this;
    }
}

