/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.datamovement.job;

import com.marklogic.client.ext.datamovement.CollectionsQueryBatcherBuilder;
import com.marklogic.client.ext.datamovement.QueryBatcherBuilder;
import com.marklogic.client.ext.datamovement.job.AbstractQueryBatcherJob;
import com.marklogic.client.ext.datamovement.listener.RemoveCollectionsListener;
import java.util.Arrays;

public class RemoveCollectionsJob
extends AbstractQueryBatcherJob {
    private String[] collections;

    public RemoveCollectionsJob() {
        this.setRequireWhereProperty(false);
        this.addRequiredJobProperty("collections", "Comma-delimited list of collections from which to remove selected records. If no 'where' property is set, then this property also defines the list of collections to select.", value -> this.setCollections(value.split(",")));
    }

    public RemoveCollectionsJob(String ... collections) {
        this();
        this.setCollections(collections);
    }

    @Override
    protected String getJobDescription() {
        Object description = !this.isWherePropertySet() ? "in collections " + Arrays.asList(this.collections) : super.getQueryDescription();
        return "Removing documents " + (String)description + " from collections " + Arrays.asList(this.collections);
    }

    @Override
    protected QueryBatcherBuilder newQueryBatcherBuilder() {
        QueryBatcherBuilder builder = super.newQueryBatcherBuilder();
        return builder != null ? builder : new CollectionsQueryBatcherBuilder(this.collections);
    }

    public void setCollections(String ... collections) {
        this.collections = collections;
        this.addUrisReadyListener(new RemoveCollectionsListener(collections));
    }
}

