/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.datamovement;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.datamovement.Batcher;
import com.marklogic.client.datamovement.DataMovementManager;
import com.marklogic.client.datamovement.JobTicket;
import com.marklogic.client.datamovement.QueryBatchListener;
import com.marklogic.client.datamovement.QueryBatcher;
import com.marklogic.client.datamovement.QueryFailureListener;
import com.marklogic.client.ext.datamovement.BatcherConfig;
import com.marklogic.client.ext.datamovement.CollectionsQueryBatcherBuilder;
import com.marklogic.client.ext.datamovement.DocumentUrisQueryBatcherBuilder;
import com.marklogic.client.ext.datamovement.QueryBatcherBuilder;
import com.marklogic.client.ext.datamovement.QueryBatcherJobTicket;
import com.marklogic.client.ext.datamovement.UriPatternQueryBatcherBuilder;
import com.marklogic.client.ext.datamovement.UrisQueryQueryBatcherBuilder;
import com.marklogic.client.query.RawCombinedQueryDefinition;
import com.marklogic.client.query.RawStructuredQueryDefinition;
import com.marklogic.client.query.StringQueryDefinition;
import com.marklogic.client.query.StructuredQueryDefinition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class QueryBatcherTemplate
extends BatcherConfig {
    private DatabaseClient databaseClient;
    private DataMovementManager dataMovementManager;
    private boolean applyConsistentSnapshot = true;
    private boolean awaitCompletion = true;
    private boolean stopJob = true;
    private List<QueryFailureListener> queryFailureListeners;
    private List<QueryBatchListener> urisReadyListeners;

    public QueryBatcherTemplate(DatabaseClient databaseClient) {
        this.databaseClient = databaseClient;
        this.dataMovementManager = this.databaseClient.newDataMovementManager();
    }

    public QueryBatcherJobTicket applyOnCollections(QueryBatchListener urisReadyListener, String ... collectionUris) {
        return this.apply(urisReadyListener, new CollectionsQueryBatcherBuilder(collectionUris));
    }

    public QueryBatcherJobTicket applyOnDocumentUris(QueryBatchListener urisReadyListener, String ... documentUris) {
        return this.apply(urisReadyListener, new DocumentUrisQueryBatcherBuilder(documentUris));
    }

    public QueryBatcherJobTicket applyOnUriPattern(QueryBatchListener urisReadyListener, String uriPattern) {
        return this.apply(urisReadyListener, new UriPatternQueryBatcherBuilder(uriPattern));
    }

    public QueryBatcherJobTicket applyOnUrisQuery(QueryBatchListener urisReadyListener, String xqueryOrJavascriptQuery) {
        return this.apply(urisReadyListener, new UrisQueryQueryBatcherBuilder(xqueryOrJavascriptQuery));
    }

    public QueryBatcherJobTicket applyOnStructuredQuery(QueryBatchListener urisReadyListener, StructuredQueryDefinition queryDefinition) {
        return this.apply(urisReadyListener, this.dataMovementManager.newQueryBatcher(queryDefinition));
    }

    public QueryBatcherJobTicket applyOnRawStructuredQuery(QueryBatchListener urisReadyListener, RawStructuredQueryDefinition queryDefinition) {
        return this.apply(urisReadyListener, this.dataMovementManager.newQueryBatcher(queryDefinition));
    }

    public QueryBatcherJobTicket applyOnStringQuery(QueryBatchListener urisReadyListener, StringQueryDefinition queryDefinition) {
        return this.apply(urisReadyListener, this.dataMovementManager.newQueryBatcher(queryDefinition));
    }

    public QueryBatcherJobTicket applyOnRawCombinedQuery(QueryBatchListener urisReadyListener, RawCombinedQueryDefinition queryDefinition) {
        return this.apply(urisReadyListener, this.dataMovementManager.newQueryBatcher(queryDefinition));
    }

    public QueryBatcherJobTicket applyOnIterator(QueryBatchListener urisReadyListener, Iterator<String> uriIterator) {
        return this.apply(urisReadyListener, this.dataMovementManager.newQueryBatcher(uriIterator));
    }

    public QueryBatcherJobTicket apply(QueryBatchListener urisReadyListener, QueryBatcherBuilder queryBatcherBuilder) {
        return this.apply(urisReadyListener, queryBatcherBuilder.buildQueryBatcher(this.databaseClient, this.dataMovementManager));
    }

    public QueryBatcherJobTicket apply(QueryBatchListener urisReadyListener, QueryBatcher queryBatcher) {
        ArrayList<Object> newListeners;
        QueryBatchListener[] existingListeners;
        this.prepareBatcher((Batcher)queryBatcher);
        if (this.applyConsistentSnapshot) {
            queryBatcher.withConsistentSnapshot();
        }
        if (this.urisReadyListeners != null) {
            existingListeners = queryBatcher.getQuerySuccessListeners();
            if (existingListeners == null || existingListeners.length == 0) {
                queryBatcher.setUrisReadyListeners(this.urisReadyListeners.toArray(new QueryBatchListener[0]));
            } else {
                newListeners = new ArrayList<Object>();
                newListeners.addAll(this.urisReadyListeners);
                for (QueryBatchListener listener : existingListeners) {
                    newListeners.add(listener);
                }
                queryBatcher.setUrisReadyListeners(newListeners.toArray(new QueryBatchListener[0]));
            }
        }
        if (urisReadyListener != null) {
            queryBatcher.onUrisReady(urisReadyListener);
        }
        if (this.queryFailureListeners != null) {
            existingListeners = queryBatcher.getQueryFailureListeners();
            if (existingListeners == null || existingListeners.length == 0) {
                queryBatcher.setQueryFailureListeners(this.queryFailureListeners.toArray(new QueryFailureListener[0]));
            } else {
                newListeners = new ArrayList();
                newListeners.addAll(this.queryFailureListeners);
                for (QueryBatchListener listener : existingListeners) {
                    newListeners.add(listener);
                }
                queryBatcher.setQueryFailureListeners(newListeners.toArray(new QueryFailureListener[0]));
            }
        }
        JobTicket jobTicket = this.dataMovementManager.startJob(queryBatcher);
        if (this.awaitCompletion) {
            queryBatcher.awaitCompletion();
        }
        if (this.stopJob) {
            this.dataMovementManager.stopJob((Batcher)queryBatcher);
        }
        return new QueryBatcherJobTicket(this.dataMovementManager, queryBatcher, jobTicket);
    }

    public void setApplyConsistentSnapshot(boolean applyConsistentSnapshot) {
        this.applyConsistentSnapshot = applyConsistentSnapshot;
    }

    public void setAwaitCompletion(boolean awaitCompletion) {
        this.awaitCompletion = awaitCompletion;
    }

    public void setStopJob(boolean stopJob) {
        this.stopJob = stopJob;
    }

    public DataMovementManager getDataMovementManager() {
        return this.dataMovementManager;
    }

    public DatabaseClient getDatabaseClient() {
        return this.databaseClient;
    }

    public void addQueryFailureListeners(QueryFailureListener ... listeners) {
        if (this.queryFailureListeners == null) {
            this.queryFailureListeners = new ArrayList<QueryFailureListener>();
        }
        for (QueryFailureListener listener : listeners) {
            this.queryFailureListeners.add(listener);
        }
    }

    public void setQueryFailureListeners(QueryFailureListener ... listeners) {
        this.queryFailureListeners = new ArrayList<QueryFailureListener>();
        for (QueryFailureListener listener : listeners) {
            this.queryFailureListeners.add(listener);
        }
    }

    public void addUrisReadyListeners(QueryBatchListener ... listeners) {
        if (this.urisReadyListeners == null) {
            this.urisReadyListeners = new ArrayList<QueryBatchListener>();
        }
        for (QueryBatchListener listener : listeners) {
            this.urisReadyListeners.add(listener);
        }
    }

    public void setUrisReadyListeners(QueryBatchListener ... listeners) {
        this.urisReadyListeners = new ArrayList<QueryBatchListener>();
        for (QueryBatchListener listener : listeners) {
            this.urisReadyListeners.add(listener);
        }
    }
}

