/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.datamovement.listener;

import com.marklogic.client.datamovement.QueryBatch;
import com.marklogic.client.datamovement.QueryBatchListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleBatchLoggingListener
implements QueryBatchListener {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean useLogger;

    public SimpleBatchLoggingListener() {
        this(false);
    }

    public SimpleBatchLoggingListener(boolean useLogger) {
        this.useLogger = useLogger;
    }

    public void processEvent(QueryBatch queryBatch) {
        String message = String.format("Processed batch number [%d]; job results so far: [%d]", queryBatch.getJobBatchNumber(), queryBatch.getJobResultsSoFar());
        if (this.useLogger) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(message);
            }
        } else {
            System.out.println(message);
        }
    }

    public void setUseLogger(boolean useLogger) {
        this.useLogger = useLogger;
    }
}

