/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.datamovement.consumer;

import com.marklogic.client.document.DocumentRecord;
import com.marklogic.client.io.BytesHandle;
import com.marklogic.client.io.marker.AbstractReadHandle;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteToZipConsumer
implements Consumer<DocumentRecord>,
Closeable {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private ZipOutputStream zipOutputStream;
    private boolean flattenUri = false;
    private String uriPrefix;

    public WriteToZipConsumer(File file) {
        try {
            this.zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to open zip output stream on file: " + file + "; cause: " + e.getMessage(), e);
        }
    }

    public WriteToZipConsumer(ZipOutputStream zipOutputStream) {
        this.zipOutputStream = zipOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(DocumentRecord documentRecord) {
        String uri = documentRecord.getUri();
        ZipEntry zipEntry = this.buildZipEntry(documentRecord);
        ZipOutputStream zipOutputStream = this.zipOutputStream;
        synchronized (zipOutputStream) {
            try {
                this.zipOutputStream.putNextEntry(zipEntry);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Writing zip entry, name: " + zipEntry.getName());
                }
                this.zipOutputStream.write(((BytesHandle)documentRecord.getContent((AbstractReadHandle)new BytesHandle())).get());
                this.zipOutputStream.closeEntry();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to write zip entry for URI: " + uri + "; cause: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void close() {
        if (this.zipOutputStream != null) {
            try {
                this.zipOutputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected ZipEntry buildZipEntry(DocumentRecord documentRecord) {
        Object uri = documentRecord.getUri();
        if (this.flattenUri) {
            int pos = ((String)uri).lastIndexOf("/");
            Object object = uri = pos > -1 ? ((String)uri).substring(pos + 1) : uri;
        }
        if (this.uriPrefix != null) {
            uri = this.uriPrefix + (String)uri;
        }
        return new ZipEntry((String)uri);
    }

    public void setFlattenUri(boolean flattenUri) {
        this.flattenUri = flattenUri;
    }

    public void setUriPrefix(String uriPrefix) {
        this.uriPrefix = uriPrefix;
    }
}

