/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.datamovement.job;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.datamovement.ExportListener;
import com.marklogic.client.datamovement.QueryBatchListener;
import com.marklogic.client.ext.datamovement.QueryBatcherJobTicket;
import com.marklogic.client.ext.datamovement.consumer.WriteToZipConsumer;
import com.marklogic.client.ext.datamovement.job.AbstractQueryBatcherJob;
import java.io.File;
import java.util.function.Consumer;

public class ExportToZipJob
extends AbstractQueryBatcherJob {
    private File exportFile;
    private WriteToZipConsumer writeToZipConsumer;
    private ExportListener exportListener;

    public ExportToZipJob() {
        this.addRequiredJobProperty("exportPath", "The path of the zip file to which selected records are exported", value -> this.setExportFile(new File((String)value)));
        this.addJobProperty("flattenUri", "Whether or not record URIs are flattened before being used as zip entry names; defaults to false", value -> this.getWriteToZipConsumer().setFlattenUri(Boolean.parseBoolean(value)));
        this.addTransformJobProperty((value, transform) -> this.getExportListener().withTransform(transform));
        this.addJobProperty("uriPrefix", "Prefix to prepend to each URI it is used as an entry name; applied after a URI is optionally flattened", value -> this.getWriteToZipConsumer().setUriPrefix((String)value));
    }

    public ExportToZipJob(File exportFile) {
        this();
        this.setExportFile(exportFile);
    }

    @Override
    public QueryBatcherJobTicket run(DatabaseClient databaseClient) {
        QueryBatcherJobTicket ticket = super.run(databaseClient);
        if (this.writeToZipConsumer != null) {
            this.writeToZipConsumer.close();
        }
        return ticket;
    }

    public void setExportFile(File exportFile) {
        this.exportFile = exportFile;
        this.exportFile = exportFile;
        if (this.exportFile.getParentFile() != null) {
            this.exportFile.getParentFile().mkdirs();
        }
        this.writeToZipConsumer = new WriteToZipConsumer(exportFile);
        this.exportListener = new ExportListener();
        this.exportListener.onDocumentReady((Consumer)this.writeToZipConsumer);
        this.addUrisReadyListener((QueryBatchListener)this.exportListener);
    }

    @Override
    protected String getJobDescription() {
        return "Exporting documents " + this.getQueryDescription() + " to file at: " + this.exportFile;
    }

    public ExportListener getExportListener() {
        return this.exportListener;
    }

    public WriteToZipConsumer getWriteToZipConsumer() {
        return this.writeToZipConsumer;
    }
}

