/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.datamovement.job;

import com.marklogic.client.datamovement.QueryBatchListener;
import com.marklogic.client.document.ServerTransform;
import com.marklogic.client.ext.datamovement.job.AbstractQueryBatcherJob;
import com.marklogic.client.ext.datamovement.listener.ExportBatchesToDirectoryListener;
import java.io.File;

public class ExportBatchesToDirectoryJob
extends AbstractQueryBatcherJob {
    private ExportBatchesToDirectoryListener exportBatchesToDirectoryListener;
    private File exportDir;

    public ExportBatchesToDirectoryJob() {
        this.addRequiredJobProperty("exportPath", "Directory path to which each batch should be written as a file", value -> this.setExportDir(new File((String)value)));
        this.addJobProperty("fileHeader", "Content written to the start of each file", value -> this.getExportListener().withFileHeader((String)value));
        this.addJobProperty("fileFooter", "Content written to the end of each file", value -> this.getExportListener().withFileFooter((String)value));
        this.addJobProperty("filenamePrefix", "Prefix written to the beginning of the filename of each file; defaults to batch-", value -> this.getExportListener().withFilenamePrefix((String)value));
        this.addJobProperty("filenameExtension", "Filename extension for each file; defaults to .zip", value -> this.getExportListener().withFilenameExtension((String)value));
        this.addJobProperty("recordPrefix", "Optional content to be written before each record is written", value -> this.getExportListener().withRecordPrefix((String)value));
        this.addJobProperty("recordSuffix", "Optional content to be written after each record is written", value -> this.getExportListener().withRecordSuffix((String)value));
        this.addTransformJobProperty((value, transform) -> this.getExportListener().withTransform((ServerTransform)transform));
    }

    public ExportBatchesToDirectoryJob(File exportDir) {
        this();
        this.setExportDir(exportDir);
    }

    @Override
    protected String getJobDescription() {
        return "Exporting batches of documents " + this.getQueryDescription() + " to files at: " + this.exportDir;
    }

    public ExportBatchesToDirectoryListener getExportListener() {
        return this.exportBatchesToDirectoryListener;
    }

    public void setExportDir(File exportDir) {
        this.exportDir = exportDir;
        this.exportBatchesToDirectoryListener = new ExportBatchesToDirectoryListener(exportDir);
        this.addUrisReadyListener((QueryBatchListener)this.exportBatchesToDirectoryListener);
    }

    public File getExportDir() {
        return this.exportDir;
    }
}

