/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.datamovement.job;

import com.marklogic.client.ext.datamovement.job.AbstractQueryBatcherJob;
import com.marklogic.client.ext.datamovement.job.QueryBatcherJob;
import com.marklogic.client.ext.datamovement.listener.AddCollectionsListener;
import java.util.Arrays;

public class AddCollectionsJob
extends AbstractQueryBatcherJob
implements QueryBatcherJob {
    private String[] collections;

    public AddCollectionsJob() {
        this.addRequiredJobProperty("collections", "Comma-delimited list collections to which selected records are added", value -> this.setCollections(value.split(",")));
    }

    public AddCollectionsJob(String ... collections) {
        this();
        this.setCollections(collections);
    }

    @Override
    protected String getJobDescription() {
        return "Adding documents " + this.getQueryDescription() + " to collections " + Arrays.asList(this.collections);
    }

    public void setCollections(String ... collections) {
        this.collections = collections;
        this.addUrisReadyListener(new AddCollectionsListener(collections));
    }
}

