<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:mapping="http://marklogic.com/entity-services/mapping"
                xmlns:xdmp="http://marklogic.com/xdmp"
                xmlns:sem="http://marklogic.com/semantics"
                xmlns:axsl="uri:namespace-alias-xsl"
                xmlns:axdmp="uri:namespace-alias-xdmp"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:this="uri:local"
                version="2.0"
                xdmp:dialect="1.0-ml"
                exclude-result-prefixes="mapping this"
>
  <!--
     mapping := input-model?, output-model?, use-functions*, wc(mapping)*, entity*, output?, triples?
     input-model := @href
     output-model := @href
     use-functions := @href
     entity := wc()*
     output := wc()*
     triples := wc()*
     triple := subject, predicate, object
     subject := wc(mapping)*
     predicate := wc(mapping)*
     object := wc(mapping)*
     variable := @name, wc(mapping)*
     optional := wc()
     for-each := select, wc()*
     call-template := @name, wc()*
     if := test, wc()*
     val := #XPATH
     copy := #XPATH
     select := #XPATH
     test := #XPATH
     mapping:X == xsl:X
  -->
  <xsl:namespace-alias stylesheet-prefix="axsl" result-prefix="xsl"/>
  <xsl:namespace-alias stylesheet-prefix="axdmp" result-prefix="xdmp"/>

  <!-- We have TDE as a dialect in XSLT in 10.0 and in 9.0-20190401/9.0-10 -->
  <xsl:function name="this:haveTDE" as="xs:boolean">
    <xsl:variable name="version" select="xdmp:version()"/>
    <xsl:variable name="major" select="number(substring-before($version,'.'))"/>
    <xsl:choose>
      <xsl:when test="$major ge 10">true</xsl:when>
      <xsl:when test="$major eq 9">
        <xsl:variable name="minor" select="number(substring-after($version,'-'))"/>
        <xsl:choose>
          <xsl:when test="$minor ge 20190401">true</xsl:when>
          <xsl:when test="$minor lt 2000 and $minor ge 10">true</xsl:when>
          <xsl:otherwise>false</xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>false</xsl:otherwise>
    </xsl:choose>
  </xsl:function>

  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="mapping:mapping">
    <xsl:variable name="prefixes" select="in-scope-prefixes(.)[. ne 'xml']"/>
    <xsl:variable name="node" select="."/>
    <axsl:stylesheet version="2.0"
                     extension-element-prefixes="xdmp"
                     >
      <xsl:for-each select="$prefixes">
        <xsl:variable name="ns" select="namespace-uri-for-prefix(.,$node)"/>
        <xsl:namespace name="{.}" select="$ns"/>
      </xsl:for-each>
      <xsl:attribute name="exclude-result-prefixes">
        <xsl:value-of select="'xsl xdmp sem'"/>
        <xsl:for-each select="$prefixes">
          <xsl:variable name="ns" select="namespace-uri-for-prefix(.,$node)"/>
          <xsl:if test="$ns='http://marklogic.com/entity-services/mapping'">
            <xsl:value-of select="concat(' ',.)"/>
          </xsl:if>
        </xsl:for-each>
      </xsl:attribute>
      <xsl:choose>
        <xsl:when test="this:haveTDE()">
          <xsl:attribute name="xdmp:dialect">tde</xsl:attribute>
        </xsl:when>
        <xsl:otherwise>
          <xsl:attribute name="xdmp:dialect">1.0-ml</xsl:attribute>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="mapping:use-functions"/>
      <axdmp:import-module namespace="http://marklogic.com/entity-services/standard-library" href="/data-hub/core/entity-services/standard-library.xqy"/>

      <axdmp:using namespace="http://marklogic.com/xdmp"/>
      <axdmp:using namespace="http://marklogic.com/cts"/>
      <axdmp:using namespace="http://marklogic.com/xdmp/math"/>
      <axdmp:using namespace="http://marklogic.com/xdmp/sql"/>
      <!-- <axdmp:using namespace="http://marklogic.com/semantics"/> -->
      <!-- <axdmp:using namespace="http://www.w3.org/2001/XMLSchema"/> -->
      <axdmp:using namespace="http://marklogic.com/entity-services/standard-library"/>
      <axdmp:using namespace="http://marklogic.com/entity-services/extra-functions"/>
      <xsl:apply-templates select="mapping:entity"/>

      <xsl:if test="mapping:output">
        <axsl:template match="/">
          <xsl:apply-templates select="mapping:output"/>
        </axsl:template>
      </xsl:if>

      <!-- Pass through anything else -->
      <xsl:apply-templates select="* except (mapping:entity|mapping:output|mapping:use-functions|mapping:input-model|mapping:output-model)"/>
    </axsl:stylesheet>
  </xsl:template>

  <xsl:template match="mapping:use-functions">
    <axsl:import href="{concat(@href,'.xslt')}"/>
  </xsl:template>

  <xsl:template match="mapping:output">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="mapping:entity">
    <axsl:template name="{@name}">
      <xsl:apply-templates/>
    </axsl:template>
  </xsl:template>

  <xsl:template match="mapping:variable">
    <axsl:variable name="{@name}">
      <xsl:apply-templates select="*"/>
    </axsl:variable>
  </xsl:template>

  <xsl:template match="mapping:val">
    <axsl:variable name="selectOutput">
      <xsl:attribute name="select">
        <xsl:value-of select="."/>
      </xsl:attribute>
    </axsl:variable>
    <xsl:choose>
      <xsl:when test="./@retain-falsey-values">
        <axsl:choose>
          <axsl:when test="($selectOutput instance of element() and $selectOutput/@xsi:nil) or $selectOutput instance of null-node()">
            <axsl:attribute name="xsi:nil">
              <axsl:value-of select="true()"/>
            </axsl:attribute>
          </axsl:when>
          <axsl:when test="not($selectOutput instance of empty-sequence())">
            <axsl:attribute name="not-empty">
              <axsl:value-of select="true()"/>
            </axsl:attribute>
            <axsl:value-of select="$selectOutput"/>
          </axsl:when>
            <axsl:otherwise>
                <axsl:value-of select="$selectOutput"/>
            </axsl:otherwise>
        </axsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <axsl:value-of select="$selectOutput"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="mapping:param[mapping:select]">
    <axsl:param name="{@name}">
      <xsl:attribute name="select">
        <xsl:value-of select="mapping:select"/>
      </xsl:attribute>
    </axsl:param>
  </xsl:template>

  <xsl:template match="mapping:with-param[mapping:select]">
    <axsl:with-param name="{@name}">
      <xsl:attribute name="select">
        <xsl:value-of select="mapping:select"/>
      </xsl:attribute>
    </axsl:with-param>
  </xsl:template>

  <xsl:template match="mapping:copy">
    <axsl:copy-of>
      <xsl:attribute name="select">
        <xsl:value-of select="."/>
      </xsl:attribute>
    </axsl:copy-of>
  </xsl:template>

  <xsl:template match="mapping:for-each">
    <axsl:for-each>
      <xsl:apply-templates/>
    </axsl:for-each>
  </xsl:template>

  <xsl:template match="mapping:select">
    <xsl:attribute name="select">
      <xsl:value-of select="."/>
    </xsl:attribute>
  </xsl:template>

  <xsl:template match="mapping:optional">
    <xsl:variable name="id" select="generate-id()"/>
    <axsl:variable name="{$id}">
      <xsl:apply-templates/>
    </axsl:variable>
    <axsl:if test="exists(${$id}/node()/node()) or ${$id}/node()/@xsi:nil or ${$id}/node()/@not-empty"><axsl:copy-of select="${$id}"/></axsl:if>
  </xsl:template>

  <xsl:template match="mapping:test">
    <xsl:attribute name="test">
      <xsl:value-of select="."/>
    </xsl:attribute>
  </xsl:template>

  <xsl:template match="mapping:*">
    <xsl:element name="{concat('xsl:',local-name(.))}">
      <xsl:apply-templates select="@*|node()"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="*">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates select="node()"/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="@*">
    <xsl:copy-of select='.'/>
  </xsl:template>
</xsl:stylesheet>
