The files under this folder exist to keep Data Hub 5 Data Service calls working. They were autogenerated with the following XQuery to invoke their MJS equivalents.

```xquery
xquery version "1.0-ml";
 
for $api-uri in cts:uri-match("/data-hub/data-services/*.api")
let $api-doc := fn:doc($api-uri)
let $options := <options xmlns="xdmp:document-insert">  
<permissions>{xdmp:node-permissions($api-doc)}</permissions>
<collections>{for $col in xdmp:node-collections($api-doc) return <collection>{$col}</collection>}</collections>
</options>
let $mjs-uri := fn:replace($api-uri, "\.api$", ".mjs")
let $api-5-uri := fn:replace($api-uri, "^/data-hub/data-services/", "/data-hub/5/data-services/")
let $sjs-5-uri := fn:replace(fn:replace($api-5-uri, "\.api$", ".sjs"), "^/data-hub/data-services/", "/data-hub/5/data-services/")
let $param-names := fn:string-join($api-doc/params/name[. ne ""], ", ")
where fn:doc-available($mjs-uri)
return (
  $mjs-uri || " => " || $sjs-5-uri,
  xdmp:document-insert($sjs-5-uri, text{"&quot;use strict&quot;;&#10;&#13;" ||
    (if ($param-names ne "") then
      "var " || $param-names || ";"
    else
      ())
    || "&#10;&#13;"
    || "xdmp.invoke('"|| $mjs-uri || "', {" || $param-names || "});"
  }, $options),
  $api-uri || " => " || $api-5-uri,
  xdmp:document-insert($api-5-uri, $api-doc, $options)
)
```