/**
 Copyright (c) 2021 MarkLogic Corporation

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */
'use strict';


const collections = ['http://marklogic.com/data-hub/concept'];

function getArtifactNode(artifactName) {
  const results = cts.search(cts.andQuery([cts.collectionQuery(collections[0]), cts.documentQuery(getArtifactUri(artifactName))]), ["score-zero", "unfaceted"], 0);
  return fn.head(results);
}

function getArtifactUri(artifactName) {
  return getDirectory().concat(artifactName).concat(getFileExtension());
}

function getDirectory() {
  return "/concepts/";
}

function getFileExtension() {
  return ".concept.json";
}


export default {
  getArtifactNode
};
