/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.step.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.hub.step.StepDefinition;
import com.marklogic.hub.util.json.JSONObject;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Step {
    private String stepId;
    private String name;
    private String description;
    private Map<String, Object> options;
    private JsonNode customHook;
    private Integer retryLimit;
    private Integer batchSize;
    private Integer threadCount;
    private String stepDefinitionName;
    private StepDefinition.StepDefinitionType stepDefinitionType;
    private JsonNode fileLocations;

    public String getStepId() {
        return this.stepId;
    }

    public void setStepId(String stepId) {
        this.stepId = stepId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public JsonNode getCustomHook() {
        return this.customHook;
    }

    public void setCustomHook(JsonNode customHook) {
        this.customHook = customHook;
    }

    public Integer getRetryLimit() {
        return this.retryLimit;
    }

    public void setRetryLimit(Integer retryLimit) {
        this.retryLimit = retryLimit;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public Integer getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(Integer threadCount) {
        this.threadCount = threadCount;
    }

    public String getStepDefinitionName() {
        return this.stepDefinitionName;
    }

    public void setStepDefinitionName(String stepDefinitionName) {
        this.stepDefinitionName = stepDefinitionName;
    }

    public StepDefinition.StepDefinitionType getStepDefinitionType() {
        return this.stepDefinitionType;
    }

    public void setStepDefinitionType(StepDefinition.StepDefinitionType stepDefinitionType) {
        this.stepDefinitionType = stepDefinitionType;
    }

    public JsonNode getFileLocations() {
        return this.fileLocations;
    }

    public void setFileLocations(JsonNode fileLocations) {
        this.fileLocations = fileLocations;
    }

    public static Step deserialize(JsonNode json) {
        Step step = new Step();
        JSONObject jsonObject = new JSONObject(json);
        step.setStepId(jsonObject.getString("stepId"));
        step.setStepDefinitionName(jsonObject.getString("stepDefinitionName"));
        step.setStepDefinitionType(StepDefinition.StepDefinitionType.getStepDefinitionType(jsonObject.getString("stepDefinitionType")));
        String stepName = jsonObject.getString("name");
        if (stepName == null) {
            stepName = step.getStepDefinitionName();
        }
        step.setName(stepName);
        step.setDescription(jsonObject.getString("description"));
        step.setOptions(jsonObject.getMap("options"));
        step.setCustomHook(jsonObject.getNode("customHook"));
        step.setBatchSize(jsonObject.getIntValue("batchSize"));
        step.setThreadCount(jsonObject.getIntValue("threadCount"));
        step.setFileLocations(jsonObject.getNode("fileLocations"));
        return step;
    }

    public boolean isEqual(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Step that = (Step)o;
        if (!this.name.equalsIgnoreCase(that.name)) {
            return false;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.description) ? !this.description.equals(that.description) : StringUtils.isNotEmpty((CharSequence)that.description)) {
            return false;
        }
        if (that.batchSize != null && that.batchSize.equals(this.batchSize) || that.retryLimit != null && that.retryLimit.equals(this.retryLimit) || that.threadCount != null && that.threadCount.equals(this.threadCount) || !this.stepDefinitionType.equals((Object)that.stepDefinitionType)) {
            return false;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.stepDefinitionName) ? !this.stepDefinitionName.equals(that.stepDefinitionName) : StringUtils.isNotEmpty((CharSequence)that.stepDefinitionName)) {
            return false;
        }
        if (!Objects.equals(this.options, that.options)) {
            return false;
        }
        if (!Objects.equals(this.customHook, that.customHook)) {
            return false;
        }
        if (this.fileLocations != null && that.fileLocations != null) {
            return this.fileLocations.equals((Object)that.fileLocations);
        }
        return true;
    }

    @JsonIgnore
    public boolean isMappingStep() {
        return StepDefinition.StepDefinitionType.MAPPING.equals((Object)this.stepDefinitionType);
    }

    @JsonIgnore
    public boolean isCustomStep() {
        return StepDefinition.StepDefinitionType.CUSTOM.equals((Object)this.stepDefinitionType);
    }

    @JsonIgnore
    public String getMappingName() {
        ObjectNode mapping;
        Object obj;
        if (this.isMappingStep() && this.options != null && (obj = this.options.get("mapping")) instanceof ObjectNode && (mapping = (ObjectNode)obj).has("name")) {
            return mapping.get("name").asText();
        }
        return null;
    }
}

