/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.extensions.ResourceManager;
import com.marklogic.client.io.JacksonHandle;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.util.RequestParameters;
import com.marklogic.hub.DatabaseKind;
import com.marklogic.hub.HubClientConfig;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.MasteringManager;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MasteringManagerImpl
implements MasteringManager {
    protected HubConfig hubConfig;

    @Autowired
    public MasteringManagerImpl(HubConfig hubConfig) {
        this.hubConfig = hubConfig;
    }

    public MasteringManagerImpl(HubClientConfig hubClientConfig) {
        this.hubConfig = (HubConfig)hubClientConfig;
    }

    @Override
    public JsonNode unmerge(String mergeURI, Boolean retainAuditTrail, Boolean blockFutureMerges) {
        return this.getMergeResource(DatabaseKind.FINAL).unmerge(mergeURI, retainAuditTrail, blockFutureMerges);
    }

    @Override
    public JsonNode unmergeRecord(String mergeURI, Boolean retainAuditTrail, Boolean blockFutureMerges, List<String> removeURIs) {
        return this.getMergeResource(DatabaseKind.FINAL).unmergeRecord(mergeURI, retainAuditTrail, blockFutureMerges, removeURIs);
    }

    @Override
    public JsonNode merge(List<String> mergeURIs, String flowName, String stepNumber, Boolean preview, JsonNode options) {
        return this.getMergeResource(DatabaseKind.FINAL).merge(mergeURIs, flowName, stepNumber, preview, options);
    }

    @Override
    public JsonNode mergePreview(String flowName, List<String> uris) {
        return this.getMergeResource(DatabaseKind.FINAL).mergePreview(flowName, uris);
    }

    @Override
    public JsonNode match(String matchURI, String flowName, String stepNumber, Boolean includeMatchDetails, JsonNode options) {
        return this.getMatchResource(DatabaseKind.FINAL).match(matchURI, flowName, stepNumber, includeMatchDetails, options);
    }

    @Override
    public JsonNode documentHistory(String mergedURI) {
        return this.getDocumentHistoryResource(DatabaseKind.FINAL).documentHistory(mergedURI);
    }

    @Override
    public JsonNode notifications(int start, int pageLength) {
        return this.getNotificationsResource(DatabaseKind.FINAL).notifications(start, pageLength);
    }

    @Override
    public JsonNode deleteNotifications(List<String> uris) {
        return this.getNotificationsResource(DatabaseKind.FINAL).deleteNotifications(uris);
    }

    private MergeResource getMergeResource(DatabaseKind databaseKind) {
        return new MergeResource(this.getSrcClient(databaseKind), this.hubConfig.getDbName(databaseKind));
    }

    private MatchResource getMatchResource(DatabaseKind databaseKind) {
        return new MatchResource(this.getSrcClient(databaseKind), this.hubConfig.getDbName(databaseKind));
    }

    private DocumentHistoryResource getDocumentHistoryResource(DatabaseKind databaseKind) {
        return new DocumentHistoryResource(this.getSrcClient(databaseKind));
    }

    private NotificationsResource getNotificationsResource(DatabaseKind databaseKind) {
        return new NotificationsResource(this.getSrcClient(databaseKind));
    }

    private DatabaseClient getSrcClient(DatabaseKind databaseKind) {
        switch (databaseKind) {
            case FINAL: {
                return this.hubConfig.newFinalClient(null);
            }
        }
        return this.hubConfig.newStagingClient(null);
    }

    static class NotificationsResource
    extends ResourceManager {
        public NotificationsResource(DatabaseClient srcClient) {
            srcClient.init("mlSmNotifications", (ResourceManager)this);
        }

        public JsonNode notifications(int start, int pageLength) {
            RequestParameters params = new RequestParameters();
            params.put("start", String.valueOf(start));
            params.put("pageLength", String.valueOf(pageLength));
            JsonNode resp = ((JacksonHandle)this.getServices().get(params, (AbstractReadHandle)new JacksonHandle())).get();
            return resp;
        }

        public JsonNode deleteNotifications(List<String> uris) {
            RequestParameters params = new RequestParameters();
            params.put("uri", uris);
            JsonNode resp = ((JacksonHandle)this.getServices().delete(params, (AbstractReadHandle)new JacksonHandle())).get();
            return resp;
        }
    }

    static class DocumentHistoryResource
    extends ResourceManager {
        public DocumentHistoryResource(DatabaseClient srcClient) {
            srcClient.init("mlSmHistoryDocument", (ResourceManager)this);
        }

        public JsonNode documentHistory(String mergedURI) {
            RequestParameters params = new RequestParameters();
            params.put("uri", mergedURI);
            JsonNode resp = ((JacksonHandle)this.getServices().get(params, (AbstractReadHandle)new JacksonHandle())).get();
            return resp;
        }
    }

    static class MatchResource
    extends ResourceManager {
        private final String targetDatabase;

        public MatchResource(DatabaseClient srcClient, String targetDatabase) {
            this.targetDatabase = targetDatabase;
            srcClient.init("mlSmMatch", (ResourceManager)this);
        }

        public JsonNode match(String matchURI, String flowName, String stepNumber, Boolean includeMatchDetails, JsonNode options) {
            RequestParameters params = new RequestParameters();
            params.put("uri", matchURI);
            params.put("includeMatchDetails", includeMatchDetails.toString());
            params.put("flowName", flowName);
            params.put("step", stepNumber);
            params.put("targetDatabase", this.targetDatabase);
            params.put("sourceDatabase", this.targetDatabase);
            JacksonHandle jsonOptions = new JacksonHandle().with(options);
            JsonNode resp = ((JacksonHandle)this.getServices().post(params, (AbstractWriteHandle)jsonOptions, (AbstractReadHandle)new JacksonHandle())).get();
            return resp;
        }
    }

    static class MergeResource
    extends ResourceManager {
        private final String targetDatabase;

        public MergeResource(DatabaseClient srcClient, String targetDatabase) {
            this.targetDatabase = targetDatabase;
            srcClient.init("mlSmMerge", (ResourceManager)this);
        }

        public JsonNode unmerge(String mergeURI, Boolean retainAuditTrail, Boolean blockFutureMerges) {
            RequestParameters params = new RequestParameters();
            params.add("mergeURI", mergeURI);
            params.put("retainAuditTrail", retainAuditTrail.toString());
            params.put("blockFutureMerges", blockFutureMerges.toString());
            params.put("targetDatabase", this.targetDatabase);
            params.put("sourceDatabase", this.targetDatabase);
            JacksonHandle handle = new JacksonHandle();
            JsonNode resp = ((JacksonHandle)this.getServices().delete(params, (AbstractReadHandle)handle)).get();
            return resp;
        }

        public JsonNode unmergeRecord(String mergeURI, Boolean retainAuditTrail, Boolean blockFutureMerges, List<String> removeURIs) {
            RequestParameters params = new RequestParameters();
            params.put("mergeURI", mergeURI);
            params.put("retainAuditTrail", retainAuditTrail.toString());
            params.put("blockFutureMerges", blockFutureMerges.toString());
            params.put("targetDatabase", this.targetDatabase);
            params.put("sourceDatabase", this.targetDatabase);
            params.put("removeURI", removeURIs);
            JacksonHandle handle = new JacksonHandle();
            JsonNode resp = ((JacksonHandle)this.getServices().delete(params, (AbstractReadHandle)handle)).get();
            return resp;
        }

        public JsonNode merge(List<String> mergeURIs, String flowName, String stepNumber, Boolean preview, JsonNode options) {
            RequestParameters params = new RequestParameters();
            params.put("uri", mergeURIs);
            params.put("preview", preview.toString());
            params.put("flowName", flowName);
            params.put("step", stepNumber);
            params.put("targetDatabase", this.targetDatabase);
            params.put("sourceDatabase", this.targetDatabase);
            JacksonHandle jsonOptions = new JacksonHandle().with(options);
            JsonNode resp = ((JacksonHandle)this.getServices().post(params, (AbstractWriteHandle)jsonOptions, (AbstractReadHandle)new JacksonHandle())).get();
            return resp;
        }

        public JsonNode mergePreview(String flowName, List<String> uris) {
            ObjectNode jsonOptions = new ObjectMapper().createObjectNode().put("preview", "true");
            RequestParameters params = new RequestParameters();
            params.put("flowName", flowName);
            params.put("preview", "true");
            params.put("uri", uris);
            params.put("targetDatabase", this.targetDatabase);
            params.put("sourceDatabase", this.targetDatabase);
            JsonNode resp = ((JacksonHandle)this.getServices().post(params, (AbstractWriteHandle)new JacksonHandle((JsonNode)jsonOptions), (AbstractReadHandle)new JacksonHandle())).get();
            return resp.get("mergedDocument");
        }
    }
}

