/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.commands;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.ext.file.CacheBusterDocumentFileProcessor;
import com.marklogic.client.ext.file.CollectionsDocumentFileProcessor;
import com.marklogic.client.ext.file.DocumentFileProcessor;
import com.marklogic.client.ext.file.DocumentFileReader;
import com.marklogic.client.ext.file.JarDocumentFileReader;
import com.marklogic.client.ext.file.PermissionsDocumentFileProcessor;
import com.marklogic.client.ext.file.TokenReplacerDocumentFileProcessor;
import com.marklogic.client.ext.modulesloader.ModulesFinder;
import com.marklogic.client.ext.modulesloader.ModulesLoader;
import com.marklogic.client.ext.modulesloader.ModulesManager;
import com.marklogic.client.ext.modulesloader.impl.AssetFileLoader;
import com.marklogic.client.ext.modulesloader.impl.DefaultModulesFinder;
import com.marklogic.client.ext.modulesloader.impl.DefaultModulesLoader;
import com.marklogic.client.ext.modulesloader.impl.PropertiesModuleManager;
import com.marklogic.client.ext.modulesloader.impl.SearchOptionsFinder;
import com.marklogic.client.ext.tokenreplacer.DefaultTokenReplacer;
import com.marklogic.client.ext.tokenreplacer.TokenReplacer;
import com.marklogic.hub.HubClientConfig;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.deploy.commands.AbstractCacheClearingCommand;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LoadHubModulesCommand
extends AbstractCacheClearingCommand {
    @Autowired
    private HubConfig hubConfig;
    private Throwable caughtException;

    public LoadHubModulesCommand() {
        this.setExecuteSortOrder(SortOrderConstants.LOAD_MODULES - 1);
    }

    public LoadHubModulesCommand(HubConfig hubConfig) {
        this();
        this.hubConfig = hubConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandContext context) {
        DatabaseClient modulesClient = this.hubConfig.newModulesDbClient();
        DatabaseClient stagingClient = this.hubConfig.newStagingClient();
        try {
            boolean supportColonPrefix;
            ModulesLoader modulesLoader = this.newModulesLoader(context, modulesClient);
            if (this.caughtException == null) {
                this.logger.info("Loading DHF modules");
                modulesLoader.loadModules("classpath*:/ml-modules", (ModulesFinder)new DefaultModulesFinder(), modulesClient);
                this.logger.info("Loading REST search options for staging server");
                modulesLoader.loadModules("classpath*:/ml-modules-staging", (ModulesFinder)new SearchOptionsFinder(), stagingClient);
            }
            if (this.caughtException != null) {
                throw new RuntimeException(this.caughtException);
            }
            this.loadJobsSearchOptions(modulesLoader);
            boolean bl = supportColonPrefix = this.hubConfig instanceof HubClientConfig && ((HubClientConfig)this.hubConfig).supportMlColonPrefix();
            if (supportColonPrefix) {
                this.supportMlColonREST(modulesClient);
            }
        }
        finally {
            modulesClient.release();
            stagingClient.release();
        }
    }

    private void loadJobsSearchOptions(ModulesLoader modulesLoader) {
        this.logger.info("Loading REST search options for jobs server");
        DatabaseClient jobsClient = this.hubConfig.newJobDbClient();
        try {
            modulesLoader.loadModules("classpath*:/ml-modules-traces", (ModulesFinder)new SearchOptionsFinder(), jobsClient);
            if (this.caughtException == null) {
                modulesLoader.loadModules("classpath*:/ml-modules-jobs", (ModulesFinder)new SearchOptionsFinder(), jobsClient);
            }
        }
        finally {
            jobsClient.release();
        }
    }

    private ModulesLoader newModulesLoader(CommandContext context, DatabaseClient client) {
        PropertiesModuleManager modulesManager = new PropertiesModuleManager(this.hubConfig.getAppConfig().getModuleTimestampsPath());
        AssetFileLoader assetFileLoader = new AssetFileLoader(client, (ModulesManager)modulesManager);
        LoadHubModulesCommand.prepareAssetFileLoader(assetFileLoader, context);
        DefaultModulesLoader modulesLoader = new DefaultModulesLoader(assetFileLoader);
        modulesLoader.setModulesManager((ModulesManager)modulesManager);
        modulesLoader.addFailureListener((throwable, dbClient) -> {
            if (this.caughtException == null) {
                this.caughtException = throwable;
            }
        });
        return modulesLoader;
    }

    protected static void prepareAssetFileLoader(AssetFileLoader loader, CommandContext context) {
        AppConfig appConfig = context.getAppConfig();
        Integer batchSize = appConfig.getModulesLoaderBatchSize();
        if (batchSize != null) {
            loader.setBatchSize(batchSize);
        }
        JarDocumentFileReader jarDocumentFileReader = new JarDocumentFileReader();
        jarDocumentFileReader.addDocumentFileProcessor((DocumentFileProcessor)new CacheBusterDocumentFileProcessor());
        jarDocumentFileReader.addDocumentFileProcessor((DocumentFileProcessor)new TokenReplacerDocumentFileProcessor(LoadHubModulesCommand.buildModuleTokenReplacer(appConfig)));
        jarDocumentFileReader.addDocumentFileProcessor((DocumentFileProcessor)new CollectionsDocumentFileProcessor(new String[]{"hub-core-module"}));
        jarDocumentFileReader.addDocumentFileProcessor((DocumentFileProcessor)new PermissionsDocumentFileProcessor(appConfig.getModulePermissions()));
        loader.setDocumentFileReader((DocumentFileReader)jarDocumentFileReader);
    }

    private void supportMlColonREST(DatabaseClient modulesClient) {
        modulesClient.newServerEval().modulePath("/data-hub/compatibility/support-ml-colon-prefix.mjs").eval().close();
        this.clearCache(this.hubConfig, this.hubConfig.newHubClient());
    }

    private static TokenReplacer buildModuleTokenReplacer(AppConfig appConfig) {
        DefaultTokenReplacer r = new DefaultTokenReplacer();
        Map customTokens = appConfig.getCustomTokens();
        if (customTokens != null && !customTokens.isEmpty()) {
            r.addPropertiesSource(() -> {
                Properties p = new Properties();
                p.putAll((Map<?, ?>)customTokens);
                return p;
            });
        }
        return r;
    }

    public void setHubConfig(HubConfig hubConfig) {
        this.hubConfig = hubConfig;
    }
}

