/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.commands;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.es.GenerateModelArtifactsCommand;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.eval.EvalResultIterator;
import com.marklogic.client.ext.es.CodeGenerationRequest;
import com.marklogic.client.ext.es.GeneratedCode;
import com.marklogic.hub.DatabaseKind;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.deploy.commands.EntityServicesManager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;

public class GenerateHubTDETemplateCommand
extends GenerateModelArtifactsCommand {
    private static final String ENTITY_FILE_EXTENSION = ".entity.json";
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final HubConfig hubConfig;
    private final Path userFinalSchemasTDEs;
    private String entityNames;
    private List<String> entityNamesList = Collections.EMPTY_LIST;

    public GenerateHubTDETemplateCommand(HubConfig hubConfig) {
        this.hubConfig = hubConfig;
        this.userFinalSchemasTDEs = hubConfig.getHubProject().getUserDatabaseDir().resolve(hubConfig.getDbName(DatabaseKind.FINAL_SCHEMAS)).resolve("schemas").resolve("tde");
    }

    public void execute(CommandContext context) {
        AppConfig appConfig = context.getAppConfig();
        DatabaseClient client = appConfig.newDatabaseClient();
        EntityServicesManager mgr = new EntityServicesManager(client);
        CodeGenerationRequest request = GenerateHubTDETemplateCommand.createCodeGenerationRequest();
        List<File> entityFiles = this.findEntityFiles();
        if (!entityFiles.isEmpty()) {
            Map<String, File> entityNameFileMap = GenerateHubTDETemplateCommand.createEntityNameFileMap(entityFiles);
            this.logger.debug("Found the following entities->files: {} ", entityNameFileMap);
            if (!entityNameFileMap.isEmpty()) {
                this.logger.warn("About to generate a template for the following entities: {}", this.entityNamesList.isEmpty() ? entityNameFileMap.keySet() : this.entityNamesList);
                ArrayList<GeneratedCode> generatedCodes = new ArrayList<GeneratedCode>();
                for (File f : entityNameFileMap.values()) {
                    GeneratedCode code;
                    File esModel;
                    String modelName;
                    try {
                        String tempDir = System.getProperty("java.io.tmpdir");
                        String fileName = f.getName();
                        modelName = EntityServicesManager.extractEntityNameFromURI(fileName).get();
                        esModel = new File(tempDir, fileName);
                        String modelString = this.generateModel(f);
                        if (modelString == null) {
                            this.logger.warn(f.getName() + " is not deployed to the database");
                            continue;
                        }
                        FileUtils.writeStringToFile((File)esModel, (String)modelString);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unable to generate ES model");
                    }
                    try {
                        code = this.loadModelDefinition(request, esModel, mgr);
                    }
                    catch (RuntimeException e) {
                        throw new RuntimeException("Unable to read model definition from file: " + f.getAbsolutePath(), e);
                    }
                    finally {
                        FileUtils.deleteQuietly((File)esModel);
                    }
                    if (!this.entityNamesList.isEmpty() && !this.entityNamesList.contains(modelName)) continue;
                    generatedCodes.add(code);
                }
                for (GeneratedCode code : generatedCodes) {
                    this.generateExtractionTemplate(appConfig, code);
                }
            }
        } else {
            this.logger.info("No data hub entity files found under {} or its sub-directories.", (Object)this.hubConfig.getHubEntitiesDir());
        }
    }

    private String generateModel(File f) {
        String xquery = "import module namespace hent = \"http://marklogic.com/data-hub/hub-entities\"\nat \"/data-hub/5/impl/hub-entities.xqy\";\n" + String.format("hent:get-model(\"%s\")", GenerateHubTDETemplateCommand.extractEntityNameFromFilename(f.getName()).get());
        try (EvalResultIterator resp = this.hubConfig.newStagingClient().newServerEval().xquery(xquery).eval();){
            if (resp.hasNext()) {
                String string = resp.next().getString();
                return string;
            }
        }
        return null;
    }

    public String getEntityNames() {
        return this.entityNames;
    }

    public void setEntityNames(String entityNames) {
        this.entityNames = entityNames;
        if (entityNames != null) {
            this.entityNamesList = Arrays.asList(entityNames.split(","));
        }
    }

    protected void filterEntities(Map<String, File> entityNameFileMap) {
        Set<String> entityNameFileMapKeys = entityNameFileMap.keySet();
        if (this.entityNames != null && !this.entityNames.isEmpty()) {
            List<String> entityNamesAsList = Arrays.asList(this.entityNames.split(","));
            this.logger.info("Entities specified for TDE Generation: {} ", entityNamesAsList);
            entityNameFileMapKeys.retainAll(entityNamesAsList);
            if (entityNameFileMapKeys.isEmpty()) {
                this.logger.warn("No entities files found under {} or its sub-directories with the entity name(s) {}", (Object)this.hubConfig.getHubEntitiesDir(), entityNamesAsList);
            }
        }
    }

    protected static Map<String, File> createEntityNameFileMap(List<File> entityFiles) {
        if (entityFiles == null) {
            return Collections.emptyMap();
        }
        return entityFiles.stream().collect(Collectors.toMap(GenerateHubTDETemplateCommand.extractEntityNameFunction(), Function.identity()));
    }

    protected List<File> findEntityFiles() {
        ArrayList<File> entities = new ArrayList<File>();
        Path entitiesPath = this.hubConfig.getHubEntitiesDir();
        File[] entityDefs = entitiesPath.toFile().listFiles(pathname -> pathname.toString().endsWith(ENTITY_FILE_EXTENSION) && !pathname.isHidden());
        if (entityDefs != null) {
            entities.addAll(Arrays.asList(entityDefs));
        }
        return entities;
    }

    protected void generateExtractionTemplate(AppConfig appConfig, GeneratedCode code) {
        String template = code.getExtractionTemplate();
        if (template != null) {
            File dir = this.userFinalSchemasTDEs.toFile();
            if (!dir.mkdirs() && !dir.exists()) {
                this.logger.warn("Unable to create directory for TDE templates: " + dir.getAbsolutePath());
                return;
            }
            File out = new File(dir, code.getTitle() + "-" + code.getVersion() + ".tdex");
            String logMessage = "Wrote extraction template to: ";
            if (out.exists()) {
                if (!this.fileHasDifferentContent(out, template)) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Extraction template matches file, so not modifying: " + out.getAbsolutePath());
                    }
                    return;
                }
                out = new File(dir, code.getTitle() + "-" + code.getVersion() + "-GENERATED.tdex");
                logMessage = "Extraction template does not match existing file, so writing to: ";
            }
            try {
                FileCopyUtils.copy((byte[])template.getBytes(StandardCharsets.UTF_8), (File)out);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(logMessage + out.getAbsolutePath());
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to write extraction template to file: " + out.getAbsolutePath(), e);
            }
        }
    }

    protected static Optional<String> extractEntityNameFromFilename(String filename) {
        return EntityServicesManager.extractEntityNameFromURI(filename);
    }

    private static Function<File, String> extractEntityNameFunction() {
        Function<File, String> fileName = File::getName;
        return fileName.andThen(name -> GenerateHubTDETemplateCommand.extractEntityNameFromFilename(name).get());
    }

    private static CodeGenerationRequest createCodeGenerationRequest() {
        CodeGenerationRequest request = new CodeGenerationRequest();
        request.setGenerateExtractionTemplate(true);
        request.setGenerateDatabaseProperties(false);
        request.setGenerateInstanceConverter(false);
        request.setGenerateSchema(false);
        request.setGenerateSearchOptions(false);
        return request;
    }
}

