/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.commands;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.appservers.DeployOtherServersCommand;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.impl.HubConfigImpl;
import com.marklogic.mgmt.SaveReceipt;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.appservers.ServerManager;
import com.marklogic.mgmt.util.ObjectMapperFactory;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class DeployHubAppServersCommand
extends DeployOtherServersCommand {
    private final HubConfigImpl hubConfig;

    public DeployHubAppServersCommand(HubConfig hubConfig) {
        this.hubConfig = (HubConfigImpl)hubConfig;
    }

    protected String adjustPayloadBeforeSavingResource(CommandContext context, File f, String payload) {
        if (StringUtils.equals((CharSequence)"cloud", (CharSequence)this.hubConfig.getMlAuthentication())) {
            ObjectNode payloadNode = this.convertPayloadToObjectNode(context, payload);
            payloadNode.put("authentication", "saml");
            this.logger.info("Adjusting {} app-server authentication to SAML for host {}", (Object)payloadNode.get("server-name").asText(), (Object)this.hubConfig.getHost());
            payload = payloadNode.toString();
        }
        return super.adjustPayloadBeforeSavingResource(context, f, payload);
    }

    protected SaveReceipt saveResource(ResourceManager mgr, CommandContext context, String payload) {
        SaveReceipt saveReceipt = super.saveResource(mgr, context, payload);
        this.verifyServersEnabled(context, payload);
        return saveReceipt;
    }

    private void verifyServersEnabled(CommandContext context, String payload) {
        if (payload != null) {
            boolean serverDeliberatelyDisabled = false;
            try {
                String appServerName;
                JsonNode payloadNode = ObjectMapperFactory.getObjectMapper().readTree(payload);
                boolean bl = serverDeliberatelyDisabled = !payloadNode.path("enabled").asBoolean(true);
                if (!serverDeliberatelyDisabled && !StringUtils.isEmpty((CharSequence)(appServerName = payloadNode.path("server-name").asText()))) {
                    String groupName = context.getAppConfig().getGroupName();
                    ServerManager serverManager = new ServerManager(context.getManageClient(), groupName);
                    JsonNode latestPayload = ObjectMapperFactory.getObjectMapper().readTree(serverManager.getPropertiesAsJson(appServerName, new String[0]));
                    if (!latestPayload.path("enabled").asBoolean(true)) {
                        String enablePayload = this.format("{\"server-name\":\"%s\", \"group-name\": \"%s\", \"enabled\":true}", new Object[]{appServerName, groupName});
                        serverManager.save(enablePayload);
                    }
                }
            }
            catch (JsonProcessingException e) {
                this.logger.debug("Failed to parse app server payload when determining if server is enabled.");
            }
        }
    }
}

