/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub;

import com.marklogic.mgmt.ManageClient;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MarkLogicVersion {
    private final String versionString;
    private Integer major;
    private Integer minor;
    private boolean nightly;
    private String dateString;

    public MarkLogicVersion(String versionString) {
        this.versionString = versionString;
        this.parseMarkLogicVersionString(versionString);
    }

    public MarkLogicVersion(ManageClient manageClient) {
        this.versionString = this.getMarkLogicVersionString(manageClient);
        this.parseMarkLogicVersionString(this.versionString);
    }

    public boolean isNightly() {
        return this.nightly;
    }

    public Integer getMajor() {
        return this.major;
    }

    public Integer getMinor() {
        return this.minor;
    }

    public String getDateString() {
        return this.dateString;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public boolean supportsDataHubFramework() {
        if (this.nightly && this.major >= 10) {
            return true;
        }
        return this.major >= 11 || this.major == 10 && this.minor >= 1000;
    }

    private void parseMarkLogicVersionString(String version) {
        String[] versionArr = version.split("[.-]");
        this.major = Integer.parseInt(versionArr[0]);
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
            SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date date = dateFormat.parse(versionArr[2]);
            this.nightly = true;
            this.dateString = outputFormat.format(date);
            return;
        }
        catch (Exception e) {
            int patch;
            int minor;
            this.nightly = false;
            if (this.major <= 10) {
                minor = versionArr.length > 2 ? Integer.parseInt(versionArr[2]) : 0;
                patch = versionArr.length > 3 ? Integer.parseInt(versionArr[3]) : 0;
            } else {
                minor = versionArr.length > 1 ? Integer.parseInt(versionArr[1]) : 0;
                patch = versionArr.length > 2 ? Integer.parseInt(versionArr[2]) : 0;
            }
            this.minor = minor * 100 + patch;
            return;
        }
    }

    private String getMarkLogicVersionString(ManageClient manageClient) {
        try {
            return manageClient.getXml("/manage/LATEST/?format=xml", new String[0]).getElementValue("/node()/c:version");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get version of MarkLogic; cause: " + e.getMessage(), e);
        }
    }
}

