/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.marklogic.client.impl.FailedRequest;
import com.marklogic.client.impl.FailedRequestParser;
import java.io.InputStream;
import java.util.Map;

public class JSONErrorParser
implements FailedRequestParser {
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public FailedRequest parseFailedRequest(int httpStatus, InputStream content) {
        Map errorData;
        try {
            errorData = (Map)this.objectMapper.readValue(content, Map.class);
        }
        catch (Exception ex) {
            return new FailedRequest(httpStatus, "Request failed; could not parse JSON in response body.");
        }
        if (!errorData.containsKey("errorResponse")) {
            return new FailedRequest(httpStatus, "Unexpected JSON in response body; did not find 'errorResponse' key; response: " + errorData);
        }
        FailedRequest failure = new FailedRequest();
        Map errorBody = (Map)errorData.get("errorResponse");
        failure.setStatusCode(httpStatus);
        failure.setStatusString((String)errorBody.get("status"));
        failure.setMessageCode((String)errorBody.get("messageCode"));
        failure.setMessageString((String)errorBody.get("message"));
        failure.setStackTrace((String)errorBody.get("stackTrace"));
        return failure;
    }
}

