/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import java.lang.ref.SoftReference;
import javax.xml.stream.XMLOutputFactory;

public final class XmlFactories {
    private static final CachedInstancePerThreadSupplier<XMLOutputFactory> cachedOutputFactory = new CachedInstancePerThreadSupplier<XMLOutputFactory>(new Supplier<XMLOutputFactory>(){

        @Override
        public XMLOutputFactory get() {
            return XmlFactories.makeNewOutputFactory();
        }
    });

    private XmlFactories() {
    }

    public static XMLOutputFactory makeNewOutputFactory() {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isRepairingNamespaces", true);
        return factory;
    }

    public static XMLOutputFactory getOutputFactory() {
        return cachedOutputFactory.get();
    }

    private static class CachedInstancePerThreadSupplier<T>
    implements Supplier<T> {
        private final ThreadLocal<SoftReference<T>> cachedInstances = new ThreadLocal();
        private final Supplier<T> delegate;

        CachedInstancePerThreadSupplier(Supplier<T> delegate) {
            this.delegate = delegate;
            if (null == delegate) {
                throw new IllegalArgumentException("Delegate must not be null");
            }
        }

        @Override
        public T get() {
            Object cachedInstance;
            SoftReference<T> cachedInstanceReference = this.cachedInstances.get();
            Object t = cachedInstance = null != cachedInstanceReference ? (Object)cachedInstanceReference.get() : null;
            if (null == cachedInstance) {
                cachedInstance = this.delegate.get();
                if (null == cachedInstance) {
                    throw new IllegalStateException("Must not return null from " + this.delegate.getClass().getName() + "::get() (" + this.delegate + ")");
                }
                this.cachedInstances.set(new SoftReference<Object>(cachedInstance));
            }
            return cachedInstance;
        }
    }

    static interface Supplier<T> {
        public T get();
    }
}

