/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.expression.PlanBuilder;
import com.marklogic.client.impl.BaseTypeImpl;
import com.marklogic.client.impl.ContentParam;
import com.marklogic.client.impl.CtsExprImpl;
import com.marklogic.client.impl.FnExprImpl;
import com.marklogic.client.impl.GeoExprImpl;
import com.marklogic.client.impl.JsonExprImpl;
import com.marklogic.client.impl.MapExprImpl;
import com.marklogic.client.impl.MathExprImpl;
import com.marklogic.client.impl.PlanBuilderSubImpl;
import com.marklogic.client.impl.RdfExprImpl;
import com.marklogic.client.impl.RdtExprImpl;
import com.marklogic.client.impl.SemExprImpl;
import com.marklogic.client.impl.SpellExprImpl;
import com.marklogic.client.impl.SqlExprImpl;
import com.marklogic.client.impl.VecExprImpl;
import com.marklogic.client.impl.XdmpExprImpl;
import com.marklogic.client.impl.XsExprImpl;
import com.marklogic.client.impl.XsValueImpl;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.type.PlanColumn;
import com.marklogic.client.type.PlanParamExpr;
import com.marklogic.client.type.PlanSearchOptions;
import com.marklogic.client.type.XsDoubleVal;
import com.marklogic.client.type.XsFloatVal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class PlanBuilderBaseImpl
extends PlanBuilder {
    static final PlanBuilderSubImpl pb = new PlanBuilderSubImpl();
    private DatabaseClientFactory.HandleFactoryRegistry handleRegistry;

    PlanBuilderBaseImpl() {
        super(CtsExprImpl.cts, FnExprImpl.fn, GeoExprImpl.geo, JsonExprImpl.json, MapExprImpl.map, MathExprImpl.math, RdfExprImpl.rdf, SemExprImpl.sem, SpellExprImpl.spell, SqlExprImpl.sql, VecExprImpl.vec, XdmpExprImpl.xdmp, XsExprImpl.xs, RdtExprImpl.rdt);
    }

    DatabaseClientFactory.HandleFactoryRegistry getHandleRegistry() {
        return this.handleRegistry;
    }

    void setHandleRegistry(DatabaseClientFactory.HandleFactoryRegistry handleRegistry) {
        this.handleRegistry = handleRegistry;
    }

    public PlanColumn exprCol(String column) {
        return this.col(column);
    }

    static BaseTypeImpl.Literal literal(Object value) {
        return new BaseTypeImpl.Literal(value);
    }

    @Override
    public PlanSearchOptions searchOptions() {
        return new PlanSearchOptionsImpl(this);
    }

    static class PlanSeqListImpl
    extends BaseTypeImpl.ServerExpressionListImpl {
        PlanSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class PlanCallImpl
    extends BaseTypeImpl.ServerExpressionCallImpl {
        PlanCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static abstract class PlanBaseImpl
    extends BaseTypeImpl.BaseChainImpl<BaseTypeImpl.BaseArgImpl>
    implements PlanBuilder.Plan,
    RequestPlan,
    BaseTypeImpl.BaseArgImpl {
        static final CtsExprImpl cts = CtsExprImpl.cts;
        static final FnExprImpl fn = FnExprImpl.fn;
        static final JsonExprImpl json = JsonExprImpl.json;
        static final MapExprImpl map = MapExprImpl.map;
        static final MathExprImpl math = MathExprImpl.math;
        static final RdfExprImpl rdf = RdfExprImpl.rdf;
        static final SemExprImpl sem = SemExprImpl.sem;
        static final SpellExprImpl spell = SpellExprImpl.spell;
        static final SqlExprImpl sql = SqlExprImpl.sql;
        static final XdmpExprImpl xdmp = XdmpExprImpl.xdmp;
        static final XsExprImpl xs = XsExprImpl.xs;
        static final PlanBuilderSubImpl pb = pb;
        private DatabaseClientFactory.HandleFactoryRegistry handleRegistry;

        PlanBaseImpl(PlanBaseImpl prior, String fnPrefix, String fnName, Object[] fnArgs) {
            super((BaseTypeImpl.BaseChainImpl)prior, fnPrefix, fnName, BaseTypeImpl.convertList(fnArgs));
            if (prior != null) {
                this.setHandleRegistry(prior.getHandleRegistry());
            }
        }

        DatabaseClientFactory.HandleFactoryRegistry getHandleRegistry() {
            return this.handleRegistry;
        }

        void setHandleRegistry(DatabaseClientFactory.HandleFactoryRegistry handleRegistry) {
            this.handleRegistry = handleRegistry;
        }

        @Override
        public AbstractWriteHandle getHandle() {
            return new StringHandle(this.getAst()).withFormat(Format.JSON);
        }

        String getAst() {
            StringBuilder strb = new StringBuilder();
            strb.append("{\"$optic\":");
            return this.exportAst(strb).append("}").toString();
        }

        public PlanColumn col(String column) {
            return pb.col(column);
        }

        public PlanColumn exprCol(String column) {
            return pb.exprCol(column);
        }
    }

    static interface RequestPlan {
        public Map<PlanParamBase, BaseTypeImpl.ParamBinder> getParams();

        public AbstractWriteHandle getHandle();

        public List<ContentParam> getContentParams();
    }

    static class PlanParamBase
    extends BaseTypeImpl.BaseCallImpl<XsValueImpl.StringValImpl>
    implements PlanParamExpr {
        String name = null;

        PlanParamBase(String name) {
            super("op", "param", (BaseTypeImpl.BaseArgImpl[])new XsValueImpl.StringValImpl[]{new XsValueImpl.StringValImpl(name)});
            if (name == null) {
                throw new IllegalArgumentException("cannot define parameter with null name");
            }
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    static class PlanSearchOptionsImpl
    implements PlanSearchOptions {
        private PlanBuilderBaseImpl pb;
        private XsFloatVal qualityWeight;
        private PlanSearchOptions.ScoreMethod scoreMethod;
        private XsDoubleVal bm25LengthWeight;

        PlanSearchOptionsImpl(PlanBuilderBaseImpl pb) {
            this.pb = pb;
        }

        PlanSearchOptionsImpl(PlanBuilderBaseImpl pb, XsFloatVal qualityWeight, PlanSearchOptions.ScoreMethod scoreMethod, XsDoubleVal bm25LengthWeight) {
            this(pb);
            this.qualityWeight = qualityWeight;
            this.scoreMethod = scoreMethod;
            this.bm25LengthWeight = bm25LengthWeight;
        }

        @Override
        public XsFloatVal getQualityWeight() {
            return this.qualityWeight;
        }

        @Override
        public PlanSearchOptions.ScoreMethod getScoreMethod() {
            return this.scoreMethod;
        }

        @Override
        public XsDoubleVal getBm25LengthWeight() {
            return this.bm25LengthWeight;
        }

        @Override
        public PlanSearchOptions withQualityWeight(float qualityWeight) {
            return this.withQualityWeight(this.pb.xs.floatVal(qualityWeight));
        }

        @Override
        public PlanSearchOptions withQualityWeight(XsFloatVal qualityWeight) {
            return new PlanSearchOptionsImpl(this.pb, qualityWeight, this.getScoreMethod(), this.getBm25LengthWeight());
        }

        @Override
        public PlanSearchOptions withScoreMethod(PlanSearchOptions.ScoreMethod scoreMethod) {
            return new PlanSearchOptionsImpl(this.pb, this.getQualityWeight(), scoreMethod, this.getBm25LengthWeight());
        }

        @Override
        public PlanSearchOptions withBm25LengthWeight(double bm25LengthWeight) {
            return new PlanSearchOptionsImpl(this.pb, this.getQualityWeight(), this.getScoreMethod(), this.pb.xs.doubleVal(bm25LengthWeight));
        }

        Map<String, Object> makeMap() {
            if (this.qualityWeight == null && this.scoreMethod == null && this.bm25LengthWeight == null) {
                return null;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (this.qualityWeight != null) {
                map.put("qualityWeight", this.qualityWeight);
            }
            if (this.scoreMethod != null) {
                map.put("scoreMethod", this.scoreMethod.name().toLowerCase());
            }
            if (this.bm25LengthWeight != null) {
                map.put("bm25LengthWeight", this.bm25LengthWeight);
            }
            return map;
        }
    }
}

