/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement.impl;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.datamovement.DataMovementException;
import com.marklogic.client.datamovement.DataMovementManager;
import com.marklogic.client.datamovement.Forest;
import com.marklogic.client.datamovement.ForestConfiguration;
import com.marklogic.client.datamovement.JobTicket;
import com.marklogic.client.datamovement.WriteBatch;
import com.marklogic.client.datamovement.WriteBatchListener;
import com.marklogic.client.datamovement.WriteBatcher;
import com.marklogic.client.datamovement.WriteEvent;
import com.marklogic.client.datamovement.WriteFailureListener;
import com.marklogic.client.datamovement.impl.BatchWriteSet;
import com.marklogic.client.datamovement.impl.BatcherImpl;
import com.marklogic.client.datamovement.impl.DataMovementManagerImpl;
import com.marklogic.client.document.DocumentWriteOperation;
import com.marklogic.client.document.ServerTransform;
import com.marklogic.client.document.XMLDocumentManager;
import com.marklogic.client.impl.DocumentWriteOperationImpl;
import com.marklogic.client.impl.Utilities;
import com.marklogic.client.io.DocumentMetadataHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.DocumentMetadataWriteHandle;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteBatcherImpl
extends BatcherImpl
implements WriteBatcher {
    private static Logger logger = LoggerFactory.getLogger(WriteBatcherImpl.class);
    private String temporalCollection;
    private ServerTransform transform;
    private ForestConfiguration forestConfig;
    private LinkedBlockingQueue<DocumentWriteOperation> queue = new LinkedBlockingQueue();
    private List<WriteBatchListener> successListeners = new ArrayList<WriteBatchListener>();
    private List<WriteFailureListener> failureListeners = new ArrayList<WriteFailureListener>();
    private AtomicLong batchNumber = new AtomicLong(0L);
    private AtomicLong batchCounter = new AtomicLong(0L);
    private AtomicLong itemsSoFar = new AtomicLong(0L);
    private HostInfo[] hostInfos;
    private boolean initialized = false;
    private CompletableThreadPoolExecutor threadPool = null;
    private DocumentMetadataHandle defaultMetadata;

    public WriteBatcherImpl(DataMovementManager moveMgr, ForestConfiguration forestConfig) {
        super(moveMgr);
        this.withForestConfig(forestConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        if (this.initialized) {
            return;
        }
        WriteBatcherImpl writeBatcherImpl = this;
        synchronized (writeBatcherImpl) {
            if (this.initialized) {
                return;
            }
            if (this.getBatchSize() <= 0) {
                this.withBatchSize(1);
                logger.warn("batchSize should be 1 or greater--setting batchSize to 1");
            }
            if (this.getThreadCount() <= 0) {
                this.withThreadCount(this.hostInfos.length);
                logger.warn("threadCount should be 1 or greater--setting threadCount to number of hosts ({})", (Object)this.hostInfos.length);
            }
            this.threadPool = new CompletableThreadPoolExecutor(this.getThreadCount(), this.getThreadCount(), 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(this.getThreadCount() * 3));
            this.threadPool.allowCoreThreadTimeOut(true);
            this.initialized = true;
            if (logger.isDebugEnabled()) {
                logger.debug("threadCount={}", (Object)this.getThreadCount());
                logger.debug("batchSize={}", (Object)this.getBatchSize());
            }
            super.setJobStartTime();
            this.setStartedToTrue();
        }
    }

    @Override
    public WriteBatcher add(String uri, AbstractWriteHandle contentHandle) {
        this.add(uri, null, contentHandle);
        return this;
    }

    @Override
    public WriteBatcher addAs(String uri, Object content) {
        return this.addAs(uri, null, content);
    }

    @Override
    public WriteBatcher add(DocumentWriteOperation writeOperation) {
        boolean timeToWriteBatch;
        if (writeOperation.getUri() == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        this.initialize();
        this.requireNotStopped();
        this.queue.add(writeOperation);
        logger.trace("add uri={}", (Object)writeOperation.getUri());
        long recordNum = this.batchCounter.incrementAndGet();
        boolean bl = timeToWriteBatch = recordNum % (long)this.getBatchSize() == 0L;
        if (timeToWriteBatch) {
            DocumentWriteOperation doc;
            BatchWriteSet writeSet = this.newBatchWriteSet();
            int minBatchSize = 0;
            if (this.defaultMetadata != null) {
                writeSet.getWriteSet().add(new DocumentWriteOperationImpl(DocumentWriteOperation.OperationType.METADATA_DEFAULT, null, this.defaultMetadata, null));
                minBatchSize = 1;
            }
            for (int i = 0; i < this.getBatchSize() && (doc = this.queue.poll()) != null; ++i) {
                writeSet.getWriteSet().add(doc);
            }
            if (writeSet.getWriteSet().size() > minBatchSize) {
                this.threadPool.submit(new BatchWriter(writeSet));
            }
        }
        return this;
    }

    @Override
    public WriteBatcher add(String uri, DocumentMetadataWriteHandle metadataHandle, AbstractWriteHandle contentHandle) {
        this.add(new DocumentWriteOperationImpl(DocumentWriteOperation.OperationType.DOCUMENT_WRITE, uri, metadataHandle, contentHandle));
        return this;
    }

    @Override
    public WriteBatcher add(WriteEvent ... docs) {
        for (WriteEvent doc : docs) {
            this.add(doc.getTargetUri(), doc.getMetadata(), doc.getContent());
        }
        return this;
    }

    @Override
    public WriteBatcher addAs(String uri, DocumentMetadataWriteHandle metadataHandle, Object content) {
        ContentHandle<?> handle;
        if (content == null) {
            throw new IllegalArgumentException("content must not be null");
        }
        Class<?> as = content.getClass();
        if (AbstractWriteHandle.class.isAssignableFrom(as)) {
            handle = (ContentHandle<?>)content;
        } else {
            ContentHandle<?> contentHandle = DatabaseClientFactory.getHandleRegistry().makeHandle(as);
            Utilities.setHandleContent(contentHandle, content);
            handle = contentHandle;
        }
        return this.add(uri, metadataHandle, handle);
    }

    private void requireInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("This operation must be called after starting this job");
        }
    }

    private void requireNotInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("Configuration cannot be changed after starting this job or calling add or addAs");
        }
    }

    private void requireNotStopped() {
        if (this.isStopped()) {
            throw new IllegalStateException("This instance has been stopped");
        }
    }

    private BatchWriteSet newBatchWriteSet() {
        long batchNum = this.batchNumber.incrementAndGet();
        return this.newBatchWriteSet(batchNum);
    }

    private BatchWriteSet newBatchWriteSet(long batchNum) {
        int hostToUse = (int)(batchNum % (long)this.hostInfos.length);
        HostInfo host = this.hostInfos[hostToUse];
        DatabaseClient hostClient = host.client;
        BatchWriteSet batchWriteSet = new BatchWriteSet(this, hostClient.newDocumentManager().newWriteSet(), hostClient, this.getTransform(), this.getTemporalCollection());
        batchWriteSet.setBatchNumber(batchNum);
        batchWriteSet.onSuccess(() -> this.sendSuccessToListeners(batchWriteSet));
        batchWriteSet.onFailure(throwable -> this.sendThrowableToListeners((Throwable)throwable, "Error writing batch: {}", batchWriteSet));
        return batchWriteSet;
    }

    @Override
    public WriteBatcher onBatchSuccess(WriteBatchListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.successListeners.add(listener);
        return this;
    }

    @Override
    public WriteBatcher onBatchFailure(WriteFailureListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.failureListeners.add(listener);
        return this;
    }

    @Override
    public void retryWithFailureListeners(WriteBatch batch) {
        this.retry(batch, true);
    }

    @Override
    public void retry(WriteBatch batch) {
        this.retry(batch, false);
    }

    private void retry(WriteBatch batch, boolean callFailListeners) {
        if (this.isStopped()) {
            logger.warn("Job is now stopped, aborting the retry");
            return;
        }
        if (batch == null) {
            throw new IllegalArgumentException("batch must not be null");
        }
        BatchWriteSet writeSet = this.newBatchWriteSet(batch.getJobBatchNumber());
        if (!callFailListeners) {
            writeSet.onFailure(throwable -> {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new DataMovementException("Failed to retry batch", (Throwable)throwable);
            });
        }
        for (WriteEvent doc : (WriteEvent[])batch.getItems()) {
            writeSet.getWriteSet().add(doc.getTargetUri(), doc.getMetadata(), doc.getContent());
        }
        BatchWriter runnable = new BatchWriter(writeSet);
        runnable.run();
    }

    @Override
    public WriteBatchListener[] getBatchSuccessListeners() {
        return this.successListeners.toArray(new WriteBatchListener[this.successListeners.size()]);
    }

    @Override
    public WriteFailureListener[] getBatchFailureListeners() {
        return this.failureListeners.toArray(new WriteFailureListener[this.failureListeners.size()]);
    }

    @Override
    public void setBatchSuccessListeners(WriteBatchListener ... listeners) {
        this.requireNotInitialized();
        this.successListeners.clear();
        if (listeners != null) {
            for (WriteBatchListener listener : listeners) {
                this.successListeners.add(listener);
            }
        }
    }

    @Override
    public void setBatchFailureListeners(WriteFailureListener ... listeners) {
        this.requireNotInitialized();
        this.failureListeners.clear();
        if (listeners != null) {
            for (WriteFailureListener listener : listeners) {
                this.failureListeners.add(listener);
            }
        }
    }

    @Override
    public void flushAsync() {
        this.flush(false);
    }

    @Override
    public void flushAndWait() {
        this.flush(true);
    }

    private void flush(boolean waitForCompletion) {
        this.requireInitialized();
        this.requireNotStopped();
        ArrayList docs = new ArrayList();
        this.batchCounter.set(0L);
        this.queue.drainTo(docs);
        if (logger.isTraceEnabled()) {
            logger.trace("flushing {} queued docs", (Object)docs.size());
        }
        Iterator iter = docs.iterator();
        int i = 0;
        while (iter.hasNext()) {
            if (this.isStopped()) {
                logger.warn("Job is now stopped, preventing the flush of {} queued docs", (Object)(docs.size() - i));
                if (waitForCompletion) {
                    this.awaitCompletion();
                }
                return;
            }
            BatchWriteSet writeSet = this.newBatchWriteSet();
            if (this.defaultMetadata != null) {
                writeSet.getWriteSet().add(new DocumentWriteOperationImpl(DocumentWriteOperation.OperationType.METADATA_DEFAULT, null, this.defaultMetadata, null));
            }
            for (int j = 0; j < this.getBatchSize() && iter.hasNext(); ++j) {
                DocumentWriteOperation doc = (DocumentWriteOperation)iter.next();
                writeSet.getWriteSet().add(doc);
            }
            this.threadPool.submit(new BatchWriter(writeSet));
            ++i;
        }
        if (waitForCompletion) {
            this.awaitCompletion();
        }
    }

    private void sendSuccessToListeners(BatchWriteSet batchWriteSet) {
        batchWriteSet.setItemsSoFar(this.itemsSoFar.addAndGet(batchWriteSet.getWriteSet().size()));
        WriteBatch batch = batchWriteSet.getBatchOfWriteEvents();
        for (WriteBatchListener successListener : this.successListeners) {
            try {
                successListener.processEvent(batch);
            }
            catch (Throwable t) {
                logger.error("Exception thrown by an onBatchSuccess listener", t);
            }
        }
    }

    private void sendThrowableToListeners(Throwable t, String message, BatchWriteSet batchWriteSet) {
        batchWriteSet.setItemsSoFar(this.itemsSoFar.get());
        WriteBatch batch = batchWriteSet.getBatchOfWriteEvents();
        for (WriteFailureListener failureListener : this.failureListeners) {
            try {
                failureListener.processFailure(batch, t);
            }
            catch (Throwable t2) {
                logger.error("Exception thrown by an onBatchFailure listener", t2);
            }
        }
        if (message != null) {
            logger.warn(message, (Object)t.toString());
        }
    }

    @Override
    public void start(JobTicket ticket) {
        super.setJobTicket(ticket);
        this.initialize();
    }

    @Override
    public void stop() {
        super.setJobEndTime();
        this.setStoppedToTrue();
        if (this.threadPool != null) {
            this.threadPool.shutdownNow();
        }
        this.closeAllListeners();
    }

    private void closeAllListeners() {
        for (WriteBatchListener writeBatchListener : this.getBatchSuccessListeners()) {
            if (!(writeBatchListener instanceof AutoCloseable)) continue;
            try {
                ((AutoCloseable)((Object)writeBatchListener)).close();
            }
            catch (Exception e) {
                logger.error("onBatchSuccess listener cannot be closed", (Throwable)e);
            }
        }
        for (WriteFailureListener writeFailureListener : this.getBatchFailureListeners()) {
            if (!(writeFailureListener instanceof AutoCloseable)) continue;
            try {
                ((AutoCloseable)((Object)writeFailureListener)).close();
            }
            catch (Exception e) {
                logger.error("onBatchFailure listener cannot be closed", (Throwable)e);
            }
        }
    }

    @Override
    public JobTicket getJobTicket() {
        this.requireInitialized();
        return super.getJobTicket();
    }

    @Override
    public Calendar getJobStartTime() {
        if (!this.isStarted()) {
            return null;
        }
        return super.getJobStartTime();
    }

    @Override
    public Calendar getJobEndTime() {
        if (!this.isStopped()) {
            return null;
        }
        return super.getJobEndTime();
    }

    @Override
    public boolean awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException {
        return this.threadPool.awaitCompletion(timeout, unit);
    }

    @Override
    public boolean awaitCompletion() {
        try {
            return this.awaitCompletion(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            logger.debug("awaitCompletion caught InterruptedException");
            return false;
        }
    }

    @Override
    public WriteBatcher withJobName(String jobName) {
        this.requireNotInitialized();
        super.withJobName(jobName);
        return this;
    }

    @Override
    public WriteBatcher withJobId(String jobId) {
        this.requireNotInitialized();
        this.setJobId(jobId);
        return this;
    }

    @Override
    public WriteBatcher withBatchSize(int batchSize) {
        this.requireNotInitialized();
        super.withBatchSize(batchSize);
        return this;
    }

    @Override
    public WriteBatcher withThreadCount(int threadCount) {
        this.requireNotInitialized();
        super.withThreadCount(threadCount);
        return this;
    }

    @Override
    public WriteBatcher withTemporalCollection(String collection) {
        this.requireNotInitialized();
        this.temporalCollection = collection;
        return this;
    }

    @Override
    public String getTemporalCollection() {
        return this.temporalCollection;
    }

    @Override
    public WriteBatcher withTransform(ServerTransform transform) {
        this.requireNotInitialized();
        this.transform = transform;
        return this;
    }

    @Override
    public ServerTransform getTransform() {
        return this.transform;
    }

    @Override
    public synchronized WriteBatcher withForestConfig(ForestConfiguration forestConfig) {
        super.withForestConfig(forestConfig);
        Forest[] forests = this.forests(forestConfig);
        Set<String> hosts = this.hosts(forests);
        HashMap<String, HostInfo> existingHostInfos = new HashMap<String, HostInfo>();
        HashMap<String, HostInfo> removedHostInfos = new HashMap<String, HostInfo>();
        if (this.hostInfos != null) {
            for (HostInfo hostInfo : this.hostInfos) {
                existingHostInfos.put(hostInfo.hostName, hostInfo);
                removedHostInfos.put(hostInfo.hostName, hostInfo);
            }
        }
        logger.info("(withForestConfig) Using forests on {} hosts for \"{}\"", hosts, (Object)forests[0].getDatabaseName());
        HostInfo[] newHostInfos = new HostInfo[hosts.size()];
        int i = 0;
        for (String host : hosts) {
            if (existingHostInfos.get(host) != null) {
                newHostInfos[i] = (HostInfo)existingHostInfos.get(host);
                removedHostInfos.remove(host);
            } else {
                newHostInfos[i] = new HostInfo();
                newHostInfos[i].hostName = host;
                newHostInfos[i].client = this.getMoveMgr().getHostClient(host);
                if (this.getMoveMgr().getConnectionType() == DatabaseClient.ConnectionType.DIRECT) {
                    logger.info("Adding DatabaseClient on port {} for host \"{}\" to the rotation", (Object)newHostInfos[i].client.getPort(), (Object)host);
                }
            }
            ++i;
        }
        this.forestConfig = forestConfig;
        this.hostInfos = newHostInfos;
        if (removedHostInfos.size() > 0) {
            DataMovementManagerImpl moveMgrImpl = this.getMoveMgr();
            String primaryHost = moveMgrImpl.getPrimaryClient().getHost();
            if (removedHostInfos.containsKey(primaryHost)) {
                int randomPos = new Random().nextInt(newHostInfos.length);
                moveMgrImpl.setPrimaryClient(newHostInfos[randomPos].client);
            }
            ArrayList tasks = new ArrayList();
            if (this.threadPool != null) {
                this.threadPool.getQueue().drainTo(tasks);
            }
            for (Runnable task : tasks) {
                BatchWriter writerTask;
                if (task instanceof BatchWriter && removedHostInfos.containsKey((writerTask = (BatchWriter)task).writeSet.getClient().getHost())) {
                    BatchWriteSet writeSet = this.newBatchWriteSet(writerTask.writeSet.getBatchNumber());
                    writeSet.onFailure(throwable -> {
                        if (throwable instanceof RuntimeException) {
                            throw (RuntimeException)throwable;
                        }
                        throw new DataMovementException("Failed to retry batch after failover", (Throwable)throwable);
                    });
                    for (WriteEvent doc : (WriteEvent[])writerTask.writeSet.getBatchOfWriteEvents().getItems()) {
                        writeSet.getWriteSet().add(doc.getTargetUri(), doc.getMetadata(), doc.getContent());
                    }
                    BatchWriter retryWriterTask = new BatchWriter(writeSet);
                    Runnable fretryWriterTask = (Runnable)((Object)this.threadPool.submit(retryWriterTask));
                    this.threadPool.replaceTask(writerTask, fretryWriterTask);
                    continue;
                }
                Runnable fTask = (Runnable)((Object)this.threadPool.submit(task));
                this.threadPool.replaceTask(task, fTask);
            }
        }
        return this;
    }

    @Override
    public ForestConfiguration getForestConfig() {
        return this.forestConfig;
    }

    @Override
    public WriteBatcher withDefaultMetadata(DocumentMetadataHandle handle) {
        this.defaultMetadata = handle;
        return this;
    }

    @Override
    public void addAll(Stream<? extends DocumentWriteOperation> operations) {
        operations.forEach(this::add);
    }

    @Override
    public DocumentMetadataHandle getDocumentMetadata() {
        return this.defaultMetadata;
    }

    public static class CompletableThreadPoolExecutor
    extends ThreadPoolExecutor {
        Set<Runnable> queuedAndExecutingTasks = ConcurrentHashMap.newKeySet();
        Map<Thread, ConcurrentLinkedQueue<Runnable>> activeSnapshots = new ConcurrentHashMap<Thread, ConcurrentLinkedQueue<Runnable>>();

        public CompletableThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> queue) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, queue, new CompletableRejectedExecutionHandler());
            ((CompletableRejectedExecutionHandler)this.getRejectedExecutionHandler()).setThreadPool(this);
        }

        @Override
        public void execute(Runnable r) {
            this.queuedAndExecutingTasks.add(r);
            super.execute(r);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            this.taskComplete(r);
            super.afterExecute(r, t);
        }

        public ConcurrentLinkedQueue<Runnable> snapshotQueuedAndExecutingTasks() {
            ConcurrentLinkedQueue<Runnable> snapshot = new ConcurrentLinkedQueue<Runnable>();
            this.activeSnapshots.put(Thread.currentThread(), snapshot);
            snapshot.addAll(this.queuedAndExecutingTasks);
            for (Runnable task : snapshot) {
                if (this.queuedAndExecutingTasks.contains(task)) continue;
                snapshot.remove(task);
            }
            return snapshot;
        }

        public void removeSnapshot() {
            this.activeSnapshots.remove(Thread.currentThread());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taskComplete(Runnable r) {
            boolean removedFromASnapshot = false;
            this.queuedAndExecutingTasks.remove(r);
            for (ConcurrentLinkedQueue<Runnable> snapshot : this.activeSnapshots.values()) {
                if (!snapshot.remove(r)) continue;
                removedFromASnapshot = true;
            }
            if (removedFromASnapshot) {
                Runnable runnable = r;
                synchronized (runnable) {
                    r.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void replaceTask(Runnable oldTask, Runnable newTask) {
            boolean removedFromASnapshot = false;
            if (this.queuedAndExecutingTasks.remove(oldTask)) {
                this.queuedAndExecutingTasks.add(newTask);
            }
            for (ConcurrentLinkedQueue<Runnable> snapshot : this.activeSnapshots.values()) {
                if (!snapshot.remove(oldTask)) continue;
                snapshot.add(newTask);
                removedFromASnapshot = true;
            }
            if (removedFromASnapshot) {
                Runnable runnable = oldTask;
                synchronized (runnable) {
                    oldTask.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException {
            if (unit == null) {
                throw new IllegalArgumentException("unit cannot be null");
            }
            ConcurrentLinkedQueue<Runnable> snapshotQueuedAndExecutingTasks = this.snapshotQueuedAndExecutingTasks();
            try {
                long duration = TimeUnit.MILLISECONDS.convert(timeout, unit);
                Runnable task = null;
                while ((task = snapshotQueuedAndExecutingTasks.peek()) != null) {
                    Runnable runnable = task;
                    synchronized (runnable) {
                        while (snapshotQueuedAndExecutingTasks.contains(task) && this.queuedAndExecutingTasks.contains(task)) {
                            long startTime = System.currentTimeMillis();
                            task.wait(duration);
                            if ((duration -= System.currentTimeMillis() - startTime) > 0L) continue;
                            logger.debug("[awaitCompletion] timeout");
                            boolean bl = false;
                            return bl;
                        }
                    }
                }
                return true;
            }
            finally {
                this.removeSnapshot();
            }
        }

        @Override
        public List<Runnable> shutdownNow() {
            List<Runnable> tasks = super.shutdownNow();
            for (Runnable task : tasks) {
                this.taskComplete(task);
            }
            return tasks;
        }
    }

    public static class CompletableRejectedExecutionHandler
    extends ThreadPoolExecutor.CallerRunsPolicy {
        CompletableThreadPoolExecutor threadPool = null;

        public void setThreadPool(CompletableThreadPoolExecutor threadPool) {
            this.threadPool = threadPool;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            super.rejectedExecution(r, e);
            this.threadPool.taskComplete(r);
        }
    }

    public static class BatchWriter
    implements Runnable {
        private BatchWriteSet writeSet;

        public BatchWriter(BatchWriteSet writeSet) {
            if (writeSet.getWriteSet().size() == 0) {
                throw new IllegalStateException("Attempt to write an empty batch");
            }
            this.writeSet = writeSet;
        }

        @Override
        public void run() {
            block6: {
                try {
                    Runnable onBeforeWrite = this.writeSet.getOnBeforeWrite();
                    if (onBeforeWrite != null) {
                        onBeforeWrite.run();
                    }
                    logger.trace("begin write batch {} to forest on host \"{}\"", (Object)this.writeSet.getBatchNumber(), (Object)this.writeSet.getClient().getHost());
                    if (this.writeSet.getTemporalCollection() == null) {
                        this.writeSet.getClient().newDocumentManager().write(this.writeSet.getWriteSet(), this.writeSet.getTransform(), null);
                    } else {
                        XMLDocumentManager docMgr = this.writeSet.getClient().newXMLDocumentManager();
                        docMgr.setContentFormat(Format.UNKNOWN);
                        docMgr.write(this.writeSet.getWriteSet(), this.writeSet.getTransform(), null, this.writeSet.getTemporalCollection());
                    }
                    this.closeAllHandles();
                    Runnable onSuccess = this.writeSet.getOnSuccess();
                    if (onSuccess != null) {
                        onSuccess.run();
                    }
                }
                catch (Throwable t) {
                    logger.trace("failed batch sent to forest on host \"{}\"", (Object)this.writeSet.getClient().getHost());
                    Consumer<Throwable> onFailure = this.writeSet.getOnFailure();
                    if (onFailure == null) break block6;
                    onFailure.accept(t);
                }
            }
        }

        private void closeAllHandles() throws Throwable {
            Throwable lastThrowable = null;
            for (DocumentWriteOperation doc : this.writeSet.getWriteSet()) {
                try {
                    if (doc.getContent() instanceof Closeable) {
                        ((Closeable)((Object)doc.getContent())).close();
                    }
                    if (!(doc.getMetadata() instanceof Closeable)) continue;
                    ((Closeable)((Object)doc.getMetadata())).close();
                }
                catch (Throwable t) {
                    logger.error("error calling close()", t);
                    lastThrowable = t;
                }
            }
            if (lastThrowable != null) {
                throw lastThrowable;
            }
        }
    }

    public static class HostInfo {
        public String hostName;
        public DatabaseClient client;
    }
}

