/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.datamovement.Batcher;
import com.marklogic.client.datamovement.DataMovementException;
import com.marklogic.client.datamovement.ForestConfiguration;
import com.marklogic.client.datamovement.JobReport;
import com.marklogic.client.datamovement.JobTicket;
import com.marklogic.client.datamovement.QueryBatcher;
import com.marklogic.client.datamovement.RowBatcher;
import com.marklogic.client.datamovement.WriteBatcher;
import com.marklogic.client.datamovement.impl.BatcherImpl;
import com.marklogic.client.datamovement.impl.ForestConfigurationImpl;
import com.marklogic.client.datamovement.impl.ForestImpl;
import com.marklogic.client.datamovement.impl.JobReportImpl;
import com.marklogic.client.datamovement.impl.JobTicketImpl;
import com.marklogic.client.datamovement.impl.QueryBatcherImpl;
import com.marklogic.client.datamovement.impl.RowBatcherImpl;
import com.marklogic.client.datamovement.impl.WriteBatcherImpl;
import com.marklogic.client.impl.DatabaseClientImpl;
import com.marklogic.client.io.JacksonHandle;
import com.marklogic.client.query.SearchQueryDefinition;
import com.marklogic.client.util.RequestParameters;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMovementServices {
    private static Logger logger = LoggerFactory.getLogger(DataMovementServices.class);
    private DatabaseClient client;

    public DatabaseClient getClient() {
        return this.client;
    }

    public DataMovementServices setClient(DatabaseClient client) {
        this.client = client;
        return this;
    }

    QueryConfig initConfig(String method, SearchQueryDefinition qdef) {
        logger.debug("initializing forest configuration with query");
        if (qdef == null) {
            throw new IllegalArgumentException("null query definition");
        }
        JsonNode result = ((DatabaseClientImpl)this.client).getServices().forestInfo(null, method, new RequestParameters(), qdef, new JacksonHandle()).get();
        QueryConfig queryConfig = new QueryConfig();
        try {
            JsonNode maxDocToUriBatchRatio;
            JsonNode filteredResult;
            ObjectMapper mapper = new ObjectMapper();
            JsonNode queryResult = result.get("query");
            if (queryResult != null && queryResult.isObject() && queryResult.has("ctsquery")) {
                queryConfig.serializedCtsQuery = mapper.writeValueAsString((Object)queryResult);
                logger.debug("initialized query to: {}", (Object)queryConfig.serializedCtsQuery);
            }
            if ((filteredResult = result.get("filtered")) != null && filteredResult.isBoolean()) {
                queryConfig.filtered = filteredResult.asBoolean();
                logger.debug("initialized filtering to: {}", (Object)queryConfig.filtered.toString());
            }
            if ((maxDocToUriBatchRatio = result.get("maxDocToUriBatchRatio")) != null && maxDocToUriBatchRatio.isInt()) {
                queryConfig.maxDocToUriBatchRatio = maxDocToUriBatchRatio.asInt();
                logger.debug("initialized maxDocToUriBatchRatio to : {}", (Object)queryConfig.maxDocToUriBatchRatio);
            } else {
                queryConfig.maxDocToUriBatchRatio = -1;
            }
            JsonNode defaultDocBatchSize = result.get("defaultDocBatchSize");
            if (defaultDocBatchSize != null && defaultDocBatchSize.isInt()) {
                queryConfig.defaultDocBatchSize = defaultDocBatchSize.asInt();
                logger.debug("initialized defaultDocBatchSize to : {}", (Object)queryConfig.defaultDocBatchSize);
            } else {
                queryConfig.defaultDocBatchSize = -1;
            }
            JsonNode maxUriBatchSize = result.get("maxUriBatchSize");
            if (maxUriBatchSize != null && maxUriBatchSize.isInt()) {
                queryConfig.maxUriBatchSize = maxUriBatchSize.asInt();
                logger.debug("initialized maxUriBatchSize to : {}", (Object)queryConfig.maxUriBatchSize);
            } else {
                queryConfig.maxUriBatchSize = -1;
            }
        }
        catch (JsonProcessingException e) {
            logger.error("failed to initialize query", (Throwable)e);
        }
        queryConfig.forestConfig = this.makeForestConfig(result.has("forests") ? result.get("forests") : result);
        return queryConfig;
    }

    ForestConfigurationImpl readForestConfig() {
        logger.debug("initializing forest configuration");
        JsonNode forestNodes = ((DatabaseClientImpl)this.client).getServices().getResource(null, "internal/forestinfo", null, null, new JacksonHandle()).get();
        return this.makeForestConfig(forestNodes);
    }

    private ForestConfigurationImpl makeForestConfig(JsonNode forestNodes) {
        ArrayList<ForestImpl> forests = new ArrayList<ForestImpl>();
        for (JsonNode forestNode : forestNodes) {
            String id = forestNode.get("id").asText();
            String name = forestNode.get("name").asText();
            String database = forestNode.get("database").asText();
            String host = forestNode.get("host").asText();
            String openReplicaHost = null;
            if (forestNode.get("openReplicaHost") != null) {
                openReplicaHost = forestNode.get("openReplicaHost").asText();
            }
            String requestHost = null;
            if (forestNode.get("requestHost") != null) {
                requestHost = forestNode.get("requestHost").asText();
            }
            String alternateHost = null;
            if (forestNode.get("alternateHost") != null) {
                alternateHost = forestNode.get("alternateHost").asText();
            }
            if (requestHost != null && alternateHost != null) {
                alternateHost = null;
            }
            boolean isUpdateable = "all".equals(forestNode.get("updatesAllowed").asText());
            boolean isDeleteOnly = false;
            forests.add(new ForestImpl(host, openReplicaHost, requestHost, alternateHost, database, name, id, isUpdateable, isDeleteOnly));
        }
        return new ForestConfigurationImpl(forests.toArray(new ForestImpl[forests.size()]));
    }

    public JobTicket startJob(WriteBatcher batcher, ConcurrentHashMap<String, JobTicket> activeJobs) {
        return this.startJobImpl((WriteBatcherImpl)batcher, JobTicket.JobType.WRITE_BATCHER, activeJobs).withWriteBatcher((WriteBatcherImpl)batcher);
    }

    public JobTicket startJob(QueryBatcher batcher, ConcurrentHashMap<String, JobTicket> activeJobs) {
        return this.startJobImpl((QueryBatcherImpl)batcher, JobTicket.JobType.QUERY_BATCHER, activeJobs).withQueryBatcher((QueryBatcherImpl)batcher);
    }

    public JobTicket startJob(RowBatcher<?> batcher, ConcurrentHashMap<String, JobTicket> activeJobs) {
        return this.startJobImpl((RowBatcherImpl)batcher, JobTicket.JobType.ROW_BATCHER, activeJobs).withRowBatcher((RowBatcherImpl)batcher);
    }

    private JobTicketImpl startJobImpl(BatcherImpl batcher, JobTicket.JobType jobType, ConcurrentHashMap<String, JobTicket> activeJobs) {
        String jobId = batcher.getJobId();
        if (batcher.getJobId() == null) {
            jobId = this.generateJobId();
            batcher.setJobId(jobId);
        }
        if (!batcher.isStarted() && activeJobs.containsKey(jobId)) {
            throw new DataMovementException("Cannot start the batcher because the given job Id already exists in the active jobs", null);
        }
        JobTicketImpl jobTicket = new JobTicketImpl(jobId, jobType);
        batcher.start(jobTicket);
        activeJobs.put(jobId, jobTicket);
        return jobTicket;
    }

    public JobReport getJobReport(JobTicket ticket) {
        if (ticket instanceof JobTicketImpl) {
            return JobReportImpl.about((JobTicketImpl)ticket);
        }
        return null;
    }

    public void stopJob(JobTicket ticket, ConcurrentHashMap<String, JobTicket> activeJobs) {
        if (ticket instanceof JobTicketImpl) {
            JobTicketImpl ticketImpl = (JobTicketImpl)ticket;
            ticketImpl.getBatcher().stop();
            activeJobs.remove(ticket.getJobId());
        }
    }

    public void stopJob(Batcher batcher, ConcurrentHashMap<String, JobTicket> activeJobs) {
        if (batcher instanceof BatcherImpl) {
            ((BatcherImpl)batcher).stop();
        }
        if (batcher.getJobId() != null) {
            activeJobs.remove(batcher.getJobId());
        }
    }

    private String generateJobId() {
        return UUID.randomUUID().toString();
    }

    static class QueryConfig {
        String serializedCtsQuery;
        ForestConfiguration forestConfig;
        Boolean filtered;
        int maxDocToUriBatchRatio;
        int defaultDocBatchSize;
        int maxUriBatchSize;

        QueryConfig() {
        }
    }
}

