/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement;

import com.marklogic.client.datamovement.Splitter;
import com.marklogic.client.document.DocumentWriteOperation;
import com.marklogic.client.impl.DocumentWriteOperationImpl;
import com.marklogic.client.io.BytesHandle;
import com.marklogic.client.io.Format;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Spliterators;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;

public class ZipSplitter
implements Splitter<BytesHandle> {
    private Map<String, Format> extensionFormats = new HashMap<String, Format>();
    private Predicate<ZipEntry> entryFilter;
    private Function<String, String> uriTransformer;
    private String splitFilename;
    private long count = 0L;
    private static Pattern extensionRegex = Pattern.compile("^(.+)\\.([^.]+)$");
    private UriMaker uriMaker;

    public Map<String, Format> getExtensionFormats() {
        return this.extensionFormats;
    }

    public Predicate<ZipEntry> getEntryFilter() {
        return this.entryFilter;
    }

    public void setEntryFilter(Predicate<ZipEntry> entryFilter) {
        this.entryFilter = entryFilter;
    }

    public Function<String, String> getUriTransformer() {
        return this.uriTransformer;
    }

    public void setUriTransformer(Function<String, String> uriTransformer) {
        if (this.getUriMaker() != null) {
            throw new IllegalStateException("It's illegal to set UriTransformer when UriMaker is used");
        }
        this.uriTransformer = uriTransformer;
    }

    public ZipSplitter() {
        this.extensionFormats.put("", Format.UNKNOWN);
        this.extensionFormats.put("json", Format.JSON);
        this.extensionFormats.put("txt", Format.TEXT);
        this.extensionFormats.put("xml", Format.XML);
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public Stream<BytesHandle> split(InputStream input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        if (!(input instanceof ZipInputStream)) {
            throw new IllegalArgumentException("Input should be an instance of ZipInputStream");
        }
        return this.split((ZipInputStream)input);
    }

    public Stream<BytesHandle> split(ZipInputStream input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        this.count = 0L;
        BytesHandleSpliterator bytesHandleSpliterator = new BytesHandleSpliterator(this);
        bytesHandleSpliterator.setZipStream(input);
        bytesHandleSpliterator.setEntryFilter(this.entryFilter);
        bytesHandleSpliterator.setExtensionFormats(this.extensionFormats);
        return StreamSupport.stream(bytesHandleSpliterator, true);
    }

    @Override
    public Stream<DocumentWriteOperation> splitWriteOperations(InputStream input) throws Exception {
        return this.splitWriteOperations(input, null);
    }

    @Override
    public Stream<DocumentWriteOperation> splitWriteOperations(InputStream input, String splitFilename) throws Exception {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        if (!(input instanceof ZipInputStream)) {
            throw new IllegalArgumentException("Input should be an instance of ZipInputStream");
        }
        return this.splitWriteOperations((ZipInputStream)input, splitFilename);
    }

    public Stream<DocumentWriteOperation> splitWriteOperations(ZipInputStream input) throws IOException {
        return this.splitWriteOperations(input, null);
    }

    public Stream<DocumentWriteOperation> splitWriteOperations(ZipInputStream input, String splitFilename) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        this.count = 0L;
        DocumentWriteOperationSpliterator documentWriteOperationSpliterator = new DocumentWriteOperationSpliterator(this);
        documentWriteOperationSpliterator.setZipStream(input);
        documentWriteOperationSpliterator.setEntryFilter(this.entryFilter);
        documentWriteOperationSpliterator.setExtensionFormats(this.extensionFormats);
        this.splitFilename = splitFilename;
        return StreamSupport.stream(documentWriteOperationSpliterator, true);
    }

    public UriMaker getUriMaker() {
        return this.uriMaker;
    }

    public void setUriMaker(UriMaker uriMaker) {
        if (this.getUriTransformer() != null) {
            throw new IllegalStateException("It's illegal to set UriMaker when UriTransformer is used");
        }
        this.uriMaker = uriMaker;
    }

    private static class UriMakerImpl
    extends com.marklogic.client.datamovement.impl.UriMakerImpl<BytesHandle>
    implements UriMaker {
        private UriMakerImpl() {
        }

        @Override
        public String makeUri(long num, String entryName, BytesHandle handle) {
            StringBuilder uri = new StringBuilder();
            Matcher matcher = extensionRegex.matcher(entryName);
            matcher.find();
            String name = matcher.group(1);
            String extension = matcher.group(2);
            if (this.getInputAfter() != null && this.getInputAfter().length() != 0) {
                uri.append(this.getInputAfter());
            }
            if (this.getSplitFilename() != null && this.getSplitFilename().length() != 0) {
                uri.append(this.getName());
            }
            uri.append("/").append(name);
            uri.append(num).append("_").append(UUID.randomUUID()).append(".").append(extension);
            return uri.toString();
        }
    }

    public static interface UriMaker
    extends Splitter.UriMaker {
        public String makeUri(long var1, String var3, BytesHandle var4);
    }

    private static class DocumentWriteOperationSpliterator
    extends ZipEntrySpliterator<DocumentWriteOperation> {
        private ZipSplitter splitter;

        protected DocumentWriteOperationSpliterator(ZipSplitter splitter) {
            super(Long.MAX_VALUE, 1280);
            this.splitter = splitter;
        }

        @Override
        public boolean tryAdvance(Consumer<? super DocumentWriteOperation> action) {
            try {
                String name;
                FormatEntry nextEntry = this.getNextEntry();
                if (nextEntry == null) {
                    return false;
                }
                this.splitter.count = this.splitter.getCount() + 1L;
                BytesHandle nextBytesHandle = this.readEntry(nextEntry);
                String uri = name = nextEntry.getZipEntry().getName();
                if (this.splitter.getUriTransformer() == null && this.splitter.getUriMaker() == null) {
                    UriMakerImpl uriMaker = new UriMakerImpl();
                    uriMaker.setSplitFilename(this.splitter.splitFilename);
                    this.splitter.setUriMaker(uriMaker);
                }
                if (this.splitter.getUriMaker() != null) {
                    if (this.splitter.splitFilename != null) {
                        this.splitter.getUriMaker().setSplitFilename(this.splitter.splitFilename);
                    }
                    uri = this.splitter.getUriMaker().makeUri(this.splitter.getCount(), name, nextBytesHandle);
                } else {
                    uri = (String)this.splitter.uriTransformer.apply(name);
                }
                DocumentWriteOperationImpl documentWriteOperation = new DocumentWriteOperationImpl(DocumentWriteOperation.OperationType.DOCUMENT_WRITE, uri, null, nextBytesHandle);
                action.accept(documentWriteOperation);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read ZipEntry", e);
            }
            return true;
        }
    }

    private static class BytesHandleSpliterator
    extends ZipEntrySpliterator<BytesHandle> {
        private ZipSplitter splitter;

        protected BytesHandleSpliterator(ZipSplitter splitter) {
            super(Long.MAX_VALUE, 1280);
            this.splitter = splitter;
        }

        @Override
        public boolean tryAdvance(Consumer<? super BytesHandle> action) {
            try {
                FormatEntry nextEntry = this.getNextEntry();
                if (nextEntry == null) {
                    return false;
                }
                this.splitter.count = this.splitter.getCount() + 1L;
                BytesHandle nextBytesHandle = this.readEntry(nextEntry);
                action.accept(nextBytesHandle);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read ZipEntry", e);
            }
            return true;
        }
    }

    private static abstract class ZipEntrySpliterator<T>
    extends Spliterators.AbstractSpliterator<T> {
        private ZipInputStream zipStream;
        private Map<String, Format> extensionFormats;
        private Predicate<ZipEntry> entryFilter;

        ZipEntrySpliterator(long est, int additionalCharacteristics) {
            super(est, additionalCharacteristics);
        }

        ZipInputStream getZipStream() {
            return this.zipStream;
        }

        void setZipStream(ZipInputStream zipStream) {
            if (zipStream == null) {
                throw new IllegalArgumentException("ZipStream cannot be null");
            }
            this.zipStream = zipStream;
        }

        Map<String, Format> getExtensionFormats() {
            return this.extensionFormats;
        }

        void setExtensionFormats(Map<String, Format> extensionFormats) {
            if (extensionFormats == null) {
                throw new IllegalArgumentException("ExtensionFormats cannot be null");
            }
            this.extensionFormats = extensionFormats;
        }

        Predicate<ZipEntry> getEntryFilter() {
            return this.entryFilter;
        }

        void setEntryFilter(Predicate<ZipEntry> entryFilter) {
            this.entryFilter = entryFilter;
        }

        protected FormatEntry getNextEntry() throws IOException {
            ZipEntry candidateEntry;
            while ((candidateEntry = this.getZipStream().getNextEntry()) != null) {
                if (this.getEntryFilter() != null && !this.getEntryFilter().test(candidateEntry)) continue;
                String name = candidateEntry.getName();
                Matcher matcher = extensionRegex.matcher(name);
                matcher.find();
                Format format = this.getExtensionFormats().get(matcher.group(2));
                if (format == null) {
                    format = this.getExtensionFormats().get("");
                }
                if (format == null || format == Format.UNKNOWN) continue;
                FormatEntry newEntry = new FormatEntry();
                newEntry.setFormat(format);
                newEntry.setZipEntry(candidateEntry);
                return newEntry;
            }
            return null;
        }

        protected BytesHandle readEntry(FormatEntry entry) throws IOException {
            long entrySize = entry.getZipEntry().getSize();
            if (entrySize > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("zip entry " + entry.getZipEntry().getName() + " too large: " + entrySize);
            }
            byte[] content = new byte[(int)entrySize];
            int readSize = this.getZipStream().read(content, 0, content.length);
            if (readSize == -1) {
                throw new ZipException("failed to read entry for " + entry.getZipEntry().getName());
            }
            if (readSize != content.length) {
                throw new ZipException("read " + entry.getZipEntry().getName() + " expecting length of " + content.length + " instead of " + readSize);
            }
            return new BytesHandle(content).withFormat(entry.getFormat());
        }
    }

    private static class FormatEntry {
        private ZipEntry zipEntry;
        private Format format;

        private FormatEntry() {
        }

        private ZipEntry getZipEntry() {
            return this.zipEntry;
        }

        private void setZipEntry(ZipEntry zipEntry) {
            if (zipEntry == null) {
                throw new IllegalArgumentException("ZipEntry cannot be null");
            }
            this.zipEntry = zipEntry;
        }

        private Format getFormat() {
            return this.format;
        }

        private void setFormat(Format format) {
            if (format == null) {
                throw new IllegalArgumentException("Format cannot be null");
            }
            this.format = format;
        }
    }
}

