/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import java.io.FileInputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SSLUtil {
    public static X509TrustManager getDefaultTrustManager() {
        X509TrustManager trustManager = (X509TrustManager)SSLUtil.getDefaultTrustManagers()[0];
        Logger logger = LoggerFactory.getLogger(SSLUtil.class);
        if (logger.isDebugEnabled() && trustManager.getAcceptedIssuers() != null) {
            logger.debug("Count of accepted issuers in default trust manager: {}", (Object)trustManager.getAcceptedIssuers().length);
        }
        return trustManager;
    }

    public static TrustManager[] getDefaultTrustManagers() {
        String defaultAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        return SSLUtil.getTrustManagers(defaultAlgorithm, null);
    }

    public static TrustManager[] getTrustManagers(String trustManagerAlgorithm, KeyStore optionalKeyStore) {
        TrustManagerFactory trustManagerFactory;
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(trustManagerAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to obtain trust manager factory using algorithm: " + trustManagerAlgorithm, e);
        }
        try {
            trustManagerFactory.init(optionalKeyStore);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(String.format("Unable to initialize trust manager factory obtained using algorithm: %s; cause: %s", trustManagerAlgorithm, e.getMessage()), e);
        }
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        if (trustManagers == null || trustManagers.length == 0) {
            throw new RuntimeException("No trust managers found using algorithm: " + trustManagerAlgorithm);
        }
        if (!(trustManagers[0] instanceof X509TrustManager)) {
            throw new RuntimeException("Default trust manager is not an X509TrustManager: " + trustManagers[0]);
        }
        return trustManagers;
    }

    static SSLInputs createSSLContextFromKeyStore(String keyStorePath, char[] keyStorePassword, String keyStoreType, String algorithm, String sslProtocol, X509TrustManager userProvidedTrustManager) {
        TrustManager[] trustManagerArray;
        KeyStore keyStore = SSLUtil.getKeyStore(keyStorePath, keyStorePassword, keyStoreType);
        KeyManagerFactory keyManagerFactory = SSLUtil.newKeyManagerFactory(keyStore, keyStorePassword, algorithm);
        SSLContext sslContext = SSLUtil.newSSLContext(sslProtocol);
        if (userProvidedTrustManager != null) {
            X509TrustManager[] x509TrustManagerArray = new X509TrustManager[1];
            trustManagerArray = x509TrustManagerArray;
            x509TrustManagerArray[0] = userProvidedTrustManager;
        } else {
            trustManagerArray = SSLUtil.getTrustManagers(algorithm, keyStore);
        }
        TrustManager[] trustManagers = trustManagerArray;
        try {
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagers, null);
        }
        catch (KeyManagementException ex) {
            throw new RuntimeException("Unable to initialize SSL context", ex);
        }
        return new SSLInputs(sslContext, (X509TrustManager)trustManagers[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyStore getKeyStore(String keyStorePath, char[] keyStorePassword, String keyStoreType) {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance(keyStoreType);
        }
        catch (KeyStoreException ex) {
            throw new RuntimeException("Unable to get instance of key store with type: " + keyStoreType, ex);
        }
        try (FileInputStream inputStream = new FileInputStream(keyStorePath);){
            keyStore.load(inputStream, keyStorePassword);
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to read from key store at path: " + keyStorePath, ex);
        }
    }

    private static KeyManagerFactory newKeyManagerFactory(KeyStore keyStore, char[] keyStorePassword, String algorithm) {
        KeyManagerFactory keyManagerFactory;
        try {
            keyManagerFactory = KeyManagerFactory.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("Unable to create key manager factory with algorithm: " + algorithm, ex);
        }
        try {
            keyManagerFactory.init(keyStore, keyStorePassword);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to initialize key manager factory", ex);
        }
        return keyManagerFactory;
    }

    private static SSLContext newSSLContext(String sslProtocol) {
        try {
            return SSLContext.getInstance(sslProtocol);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to create SSL context using protocol: " + sslProtocol, ex);
        }
    }

    public static class SSLInputs {
        private final SSLContext sslContext;
        private final X509TrustManager trustManager;

        public SSLInputs(SSLContext sslContext, X509TrustManager trustManager) {
            this.sslContext = sslContext;
            this.trustManager = trustManager;
        }

        public SSLContext getSslContext() {
            return this.sslContext;
        }

        public X509TrustManager getTrustManager() {
            return this.trustManager;
        }
    }
}

