/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement;

import com.marklogic.client.datamovement.Batch;
import com.marklogic.client.datamovement.BatchFailureListener;
import com.marklogic.client.datamovement.Batcher;
import com.marklogic.client.datamovement.HostAvailabilityListener;
import com.marklogic.client.datamovement.NoResponseListener;
import com.marklogic.client.datamovement.QueryBatch;
import com.marklogic.client.datamovement.QueryBatchListener;
import com.marklogic.client.datamovement.QueryBatcher;
import com.marklogic.client.document.DocumentManager;
import com.marklogic.client.document.DocumentPage;
import com.marklogic.client.document.DocumentRecord;
import com.marklogic.client.document.GenericDocumentManager;
import com.marklogic.client.document.ServerTransform;
import com.marklogic.client.impl.GenericDocumentImpl;
import com.marklogic.client.io.Format;
import com.marklogic.client.query.QueryManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportListener
implements QueryBatchListener {
    private static Logger logger = LoggerFactory.getLogger(ExportListener.class);
    private ServerTransform transform;
    private QueryManager.QueryView view;
    private Set<DocumentManager.Metadata> categories = new HashSet<DocumentManager.Metadata>();
    private Format nonDocumentFormat;
    private List<Consumer<DocumentRecord>> documentListeners = new ArrayList<Consumer<DocumentRecord>>();
    private Consumer<DocumentPage> documentPageListener;
    private boolean consistentSnapshot = false;
    private List<BatchFailureListener<Batch<String>>> failureListeners = new ArrayList<BatchFailureListener<Batch<String>>>();
    private List<BatchFailureListener<QueryBatch>> queryBatchFailureListeners = new ArrayList<BatchFailureListener<QueryBatch>>();

    public ExportListener() {
        logger.debug("new ExportListener - this should print once/job; if you see this once/batch, fix your job configuration");
    }

    protected DocumentPage getDocs(QueryBatch batch) {
        if (batch.getClient() == null) {
            throw new IllegalStateException("null DatabaseClient");
        }
        GenericDocumentManager docMgr = batch.getClient().newDocumentManager();
        if (this.view != null) {
            docMgr.setSearchView(this.view);
        }
        if (this.categories != null) {
            docMgr.setMetadataCategories(this.categories);
        }
        if (this.nonDocumentFormat != null) {
            docMgr.setNonDocumentFormat(this.nonDocumentFormat);
        }
        if (this.consistentSnapshot) {
            return ((GenericDocumentImpl)docMgr).read(batch.getServerTimestamp(), this.transform, (String[])batch.getItems());
        }
        return docMgr.read(this.transform, (String[])batch.getItems());
    }

    @Override
    public void initializeListener(QueryBatcher queryBatcher) {
        BatchFailureListener<QueryBatch> noResponseRetryListener;
        NoResponseListener noResponseListener;
        BatchFailureListener<QueryBatch> retryListener;
        HostAvailabilityListener hostAvailabilityListener = HostAvailabilityListener.getInstance((Batcher)queryBatcher);
        if (hostAvailabilityListener != null && (retryListener = hostAvailabilityListener.initializeRetryListener(this)) != null) {
            this.onFailure(retryListener);
        }
        if ((noResponseListener = NoResponseListener.getInstance(queryBatcher)) != null && (noResponseRetryListener = noResponseListener.initializeRetryListener(this)) != null) {
            this.onFailure(noResponseRetryListener);
        }
    }

    @Override
    public void processEvent(QueryBatch batch) {
        try (DocumentPage docs = this.getDocs(batch);){
            if (this.documentPageListener != null) {
                this.documentPageListener.accept(docs);
            } else {
                while (docs.hasNext()) {
                    for (Consumer<DocumentRecord> listener : this.documentListeners) {
                        try {
                            listener.accept((DocumentRecord)docs.next());
                        }
                        catch (Throwable t) {
                            logger.error("Exception thrown by an onDocumentReady listener", t);
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            for (BatchFailureListener<Batch<String>> batchFailureListener : this.failureListeners) {
                try {
                    batchFailureListener.processFailure(batch, t);
                }
                catch (Throwable t2) {
                    logger.error("Exception thrown by an onBatchFailure listener", t2);
                }
            }
            for (BatchFailureListener<Batch<String>> batchFailureListener : this.queryBatchFailureListeners) {
                try {
                    batchFailureListener.processFailure(batch, t);
                }
                catch (Throwable t2) {
                    logger.error("Exception thrown by an onFailure listener", t2);
                }
            }
        }
    }

    public ExportListener withConsistentSnapshot() {
        this.consistentSnapshot = true;
        return this;
    }

    public ExportListener withMetadataCategory(DocumentManager.Metadata category) {
        this.categories.add(category);
        return this;
    }

    public ExportListener withNonDocumentFormat(Format nonDocumentFormat) {
        this.nonDocumentFormat = nonDocumentFormat;
        return this;
    }

    public ExportListener withTransform(ServerTransform transform) {
        this.transform = transform;
        return this;
    }

    public ExportListener onDocumentReady(Consumer<DocumentRecord> listener) {
        if (this.documentPageListener != null) {
            throw new IllegalStateException("Cannot call onDocumentReady if a listener has already been set via onDocumentPageReady");
        }
        this.documentListeners.add(listener);
        return this;
    }

    public ExportListener onDocumentPageReady(Consumer<DocumentPage> listener) {
        if (this.documentListeners != null && !this.documentListeners.isEmpty()) {
            throw new IllegalStateException("Cannot call onDocumentPageReady if a listener has already been added via onDocumentReady");
        }
        this.documentPageListener = listener;
        return this;
    }

    @Deprecated
    public ExportListener onBatchFailure(BatchFailureListener<Batch<String>> listener) {
        this.failureListeners.add(listener);
        return this;
    }

    public ExportListener onFailure(BatchFailureListener<QueryBatch> listener) {
        this.queryBatchFailureListeners.add(listener);
        return this;
    }

    @Deprecated
    protected List<BatchFailureListener<Batch<String>>> getFailureListeners() {
        return this.failureListeners;
    }

    protected List<BatchFailureListener<QueryBatch>> getBatchFailureListeners() {
        return this.queryBatchFailureListeners;
    }
}

