/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.navigation.utils.thread;

import com.mapbox.navigation.utils.thread.JobControl;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorsKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\u0006\u0010\u0012\u001a\u00020\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/mapbox/navigation/utils/thread/ThreadController;", "", "()V", "IODispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "getIODispatcher", "()Lkotlinx/coroutines/CoroutineDispatcher;", "ioRootJob", "Lkotlinx/coroutines/CompletableJob;", "mainRootJob", "maxCoresUsed", "", "cancelAllNonUICoroutines", "", "cancelAllUICoroutines", "getIOScopeAndRootJob", "Lcom/mapbox/navigation/utils/thread/JobControl;", "getMainScopeAndRootJob", "init", "libnavigation-util_release"})
public final class ThreadController {
    private static final int maxCoresUsed;
    @NotNull
    private static final CoroutineDispatcher IODispatcher;
    private static CompletableJob ioRootJob;
    private static CompletableJob mainRootJob;
    public static final ThreadController INSTANCE;

    @NotNull
    public final CoroutineDispatcher getIODispatcher() {
        return IODispatcher;
    }

    public final void init() {
        ioRootJob = SupervisorKt.SupervisorJob$default(null, (int)1, null);
        mainRootJob = SupervisorKt.SupervisorJob$default(null, (int)1, null);
    }

    public final void cancelAllNonUICoroutines() {
        JobKt.cancelChildren$default((Job)((Job)ioRootJob), null, (int)1, null);
    }

    public final void cancelAllUICoroutines() {
        JobKt.cancelChildren$default((Job)((Job)mainRootJob), null, (int)1, null);
    }

    @NotNull
    public final JobControl getIOScopeAndRootJob() {
        CompletableJob parentJob = SupervisorKt.SupervisorJob((Job)((Job)ioRootJob));
        return new JobControl((Job)parentJob, CoroutineScopeKt.CoroutineScope((CoroutineContext)parentJob.plus((CoroutineContext)IODispatcher)));
    }

    @NotNull
    public final JobControl getMainScopeAndRootJob() {
        CompletableJob parentJob = SupervisorKt.SupervisorJob((Job)((Job)mainRootJob));
        return new JobControl((Job)parentJob, CoroutineScopeKt.CoroutineScope((CoroutineContext)parentJob.plus((CoroutineContext)Dispatchers.getMain())));
    }

    private ThreadController() {
    }

    static {
        ThreadController threadController;
        INSTANCE = threadController = new ThreadController();
        maxCoresUsed = RangesKt.coerceAtMost((int)Runtime.getRuntime().availableProcessors(), (int)2);
        ExecutorService executorService = Executors.newFixedThreadPool(maxCoresUsed);
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"Executors.newFixedThreadPool(maxCoresUsed)");
        IODispatcher = (CoroutineDispatcher)ExecutorsKt.from((ExecutorService)executorService);
        ioRootJob = SupervisorKt.SupervisorJob$default(null, (int)1, null);
        mainRootJob = SupervisorKt.SupervisorJob$default(null, (int)1, null);
    }
}

