/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.matching.v5.models;

import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.mapbox.api.directions.v5.models.RouteLeg;
import com.mapbox.api.directions.v5.models.RouteOptions;
import com.mapbox.api.matching.v5.models.AutoValue_MapMatchingMatching;
import com.mapbox.api.matching.v5.models.MapMatchingMatching;
import java.util.List;

abstract class $AutoValue_MapMatchingMatching
extends MapMatchingMatching {
    private final double distance;
    private final double duration;
    private final String geometry;
    private final double weight;
    private final String weightName;
    private final List<RouteLeg> legs;
    private final double confidence;
    private final RouteOptions routeOptions;
    private final String voiceLanguage;

    $AutoValue_MapMatchingMatching(double distance, double duration, @Nullable String geometry, double weight, String weightName, List<RouteLeg> legs, double confidence, @Nullable RouteOptions routeOptions, @Nullable String voiceLanguage) {
        this.distance = distance;
        this.duration = duration;
        this.geometry = geometry;
        this.weight = weight;
        if (weightName == null) {
            throw new NullPointerException("Null weightName");
        }
        this.weightName = weightName;
        if (legs == null) {
            throw new NullPointerException("Null legs");
        }
        this.legs = legs;
        this.confidence = confidence;
        this.routeOptions = routeOptions;
        this.voiceLanguage = voiceLanguage;
    }

    @Override
    public double distance() {
        return this.distance;
    }

    @Override
    public double duration() {
        return this.duration;
    }

    @Override
    @Nullable
    public String geometry() {
        return this.geometry;
    }

    @Override
    public double weight() {
        return this.weight;
    }

    @Override
    @SerializedName(value="weight_name")
    public String weightName() {
        return this.weightName;
    }

    @Override
    public List<RouteLeg> legs() {
        return this.legs;
    }

    @Override
    public double confidence() {
        return this.confidence;
    }

    @Override
    @Nullable
    public RouteOptions routeOptions() {
        return this.routeOptions;
    }

    @Override
    @SerializedName(value="voiceLocale")
    @Nullable
    public String voiceLanguage() {
        return this.voiceLanguage;
    }

    public String toString() {
        return "MapMatchingMatching{distance=" + this.distance + ", duration=" + this.duration + ", geometry=" + this.geometry + ", weight=" + this.weight + ", weightName=" + this.weightName + ", legs=" + this.legs + ", confidence=" + this.confidence + ", routeOptions=" + this.routeOptions + ", voiceLanguage=" + this.voiceLanguage + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MapMatchingMatching) {
            MapMatchingMatching that = (MapMatchingMatching)o;
            return Double.doubleToLongBits(this.distance) == Double.doubleToLongBits(that.distance()) && Double.doubleToLongBits(this.duration) == Double.doubleToLongBits(that.duration()) && (this.geometry == null ? that.geometry() == null : this.geometry.equals(that.geometry())) && Double.doubleToLongBits(this.weight) == Double.doubleToLongBits(that.weight()) && this.weightName.equals(that.weightName()) && this.legs.equals(that.legs()) && Double.doubleToLongBits(this.confidence) == Double.doubleToLongBits(that.confidence()) && (this.routeOptions == null ? that.routeOptions() == null : this.routeOptions.equals(that.routeOptions())) && (this.voiceLanguage == null ? that.voiceLanguage() == null : this.voiceLanguage.equals(that.voiceLanguage()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.distance) >>> 32 ^ Double.doubleToLongBits(this.distance));
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.duration) >>> 32 ^ Double.doubleToLongBits(this.duration));
        h$ *= 1000003;
        h$ ^= this.geometry == null ? 0 : this.geometry.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.weight) >>> 32 ^ Double.doubleToLongBits(this.weight));
        h$ *= 1000003;
        h$ ^= this.weightName.hashCode();
        h$ *= 1000003;
        h$ ^= this.legs.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.confidence) >>> 32 ^ Double.doubleToLongBits(this.confidence));
        h$ *= 1000003;
        h$ ^= this.routeOptions == null ? 0 : this.routeOptions.hashCode();
        h$ *= 1000003;
        return h$ ^= this.voiceLanguage == null ? 0 : this.voiceLanguage.hashCode();
    }

    @Override
    public MapMatchingMatching.Builder toBuilder() {
        return new Builder(this);
    }

    static class Builder
    extends MapMatchingMatching.Builder {
        private Double distance;
        private Double duration;
        private String geometry;
        private Double weight;
        private String weightName;
        private List<RouteLeg> legs;
        private Double confidence;
        private RouteOptions routeOptions;
        private String voiceLanguage;

        Builder() {
        }

        private Builder(MapMatchingMatching source) {
            this.distance = source.distance();
            this.duration = source.duration();
            this.geometry = source.geometry();
            this.weight = source.weight();
            this.weightName = source.weightName();
            this.legs = source.legs();
            this.confidence = source.confidence();
            this.routeOptions = source.routeOptions();
            this.voiceLanguage = source.voiceLanguage();
        }

        @Override
        public MapMatchingMatching.Builder distance(double distance) {
            this.distance = distance;
            return this;
        }

        @Override
        public MapMatchingMatching.Builder duration(double duration) {
            this.duration = duration;
            return this;
        }

        @Override
        public MapMatchingMatching.Builder geometry(@Nullable String geometry) {
            this.geometry = geometry;
            return this;
        }

        @Override
        public MapMatchingMatching.Builder weight(double weight) {
            this.weight = weight;
            return this;
        }

        @Override
        public MapMatchingMatching.Builder weightName(String weightName) {
            if (weightName == null) {
                throw new NullPointerException("Null weightName");
            }
            this.weightName = weightName;
            return this;
        }

        @Override
        public MapMatchingMatching.Builder legs(List<RouteLeg> legs) {
            if (legs == null) {
                throw new NullPointerException("Null legs");
            }
            this.legs = legs;
            return this;
        }

        @Override
        public MapMatchingMatching.Builder confidence(double confidence) {
            this.confidence = confidence;
            return this;
        }

        @Override
        public MapMatchingMatching.Builder routeOptions(@Nullable RouteOptions routeOptions) {
            this.routeOptions = routeOptions;
            return this;
        }

        @Override
        public MapMatchingMatching.Builder voiceLanguage(@Nullable String voiceLanguage) {
            this.voiceLanguage = voiceLanguage;
            return this;
        }

        @Override
        public MapMatchingMatching build() {
            String missing = "";
            if (this.distance == null) {
                missing = missing + " distance";
            }
            if (this.duration == null) {
                missing = missing + " duration";
            }
            if (this.weight == null) {
                missing = missing + " weight";
            }
            if (this.weightName == null) {
                missing = missing + " weightName";
            }
            if (this.legs == null) {
                missing = missing + " legs";
            }
            if (this.confidence == null) {
                missing = missing + " confidence";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_MapMatchingMatching(this.distance, this.duration, this.geometry, this.weight, this.weightName, this.legs, this.confidence, this.routeOptions, this.voiceLanguage);
        }
    }
}

