/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.directions.v5.models;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.mapbox.api.directions.v5.DirectionsAdapterFactory;
import com.mapbox.api.directions.v5.models.;
import com.mapbox.api.directions.v5.models.AutoValue_LegStep;
import com.mapbox.api.directions.v5.models.BannerInstructions;
import com.mapbox.api.directions.v5.models.DirectionsJsonObject;
import com.mapbox.api.directions.v5.models.StepIntersection;
import com.mapbox.api.directions.v5.models.StepManeuver;
import com.mapbox.api.directions.v5.models.VoiceInstructions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

@AutoValue
public abstract class LegStep
extends DirectionsJsonObject {
    public static final String MUTCD = "mutcd";
    public static final String VIENNA = "vienna";

    public static Builder builder() {
        return new .AutoValue_LegStep.Builder();
    }

    public abstract double distance();

    public abstract double duration();

    @SerializedName(value="duration_typical")
    @Nullable
    public abstract Double durationTypical();

    @Nullable
    public abstract String speedLimitUnit();

    @Nullable
    public abstract String speedLimitSign();

    @Nullable
    public abstract String geometry();

    @Nullable
    public abstract String name();

    @Nullable
    public abstract String ref();

    @Nullable
    public abstract String destinations();

    @NonNull
    public abstract String mode();

    @Nullable
    public abstract String pronunciation();

    @SerializedName(value="rotary_name")
    @Nullable
    public abstract String rotaryName();

    @SerializedName(value="rotary_pronunciation")
    @Nullable
    public abstract String rotaryPronunciation();

    @NonNull
    public abstract StepManeuver maneuver();

    @Nullable
    public abstract List<VoiceInstructions> voiceInstructions();

    @Nullable
    public abstract List<BannerInstructions> bannerInstructions();

    @SerializedName(value="driving_side")
    @Nullable
    public abstract String drivingSide();

    public abstract double weight();

    @Nullable
    public abstract List<StepIntersection> intersections();

    @Nullable
    public abstract String exits();

    public abstract Builder toBuilder();

    public static TypeAdapter<LegStep> typeAdapter(Gson gson) {
        return new AutoValue_LegStep.GsonTypeAdapter(gson);
    }

    public static LegStep fromJson(String json) {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapterFactory(DirectionsAdapterFactory.create());
        return (LegStep)gson.create().fromJson(json, LegStep.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder distance(double var1);

        public abstract Builder duration(double var1);

        public abstract Builder durationTypical(@Nullable Double var1);

        public abstract Builder speedLimitUnit(@Nullable String var1);

        public abstract Builder speedLimitSign(@Nullable String var1);

        public abstract Builder geometry(@Nullable String var1);

        public abstract Builder name(@Nullable String var1);

        public abstract Builder ref(@Nullable String var1);

        public abstract Builder destinations(@Nullable String var1);

        public abstract Builder mode(@NonNull String var1);

        public abstract Builder pronunciation(@Nullable String var1);

        public abstract Builder rotaryName(@Nullable String var1);

        public abstract Builder rotaryPronunciation(@Nullable String var1);

        public abstract Builder maneuver(@NonNull StepManeuver var1);

        public abstract Builder voiceInstructions(@NonNull List<VoiceInstructions> var1);

        public abstract Builder bannerInstructions(@NonNull List<BannerInstructions> var1);

        public abstract Builder drivingSide(@Nullable String var1);

        public abstract Builder weight(double var1);

        public abstract Builder intersections(@NonNull List<StepIntersection> var1);

        public abstract Builder exits(@Nullable String var1);

        public abstract LegStep build();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SpeedLimitSign {
    }
}

