/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.directions.v5.models;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.mapbox.api.directions.v5.DirectionsAdapterFactory;
import com.mapbox.api.directions.v5.models.$AutoValue_Incident;
import com.mapbox.api.directions.v5.models.AutoValue_Incident;
import com.mapbox.api.directions.v5.models.Congestion;
import com.mapbox.api.directions.v5.models.DirectionsJsonObject;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

@AutoValue
public abstract class Incident
extends DirectionsJsonObject {
    public static final String INCIDENT_ACCIDENT = "accident";
    public static final String INCIDENT_CONGESTION = "congestion";
    public static final String INCIDENT_CONSTRUCTION = "construction";
    public static final String INCIDENT_DISABLED_VEHICLE = "disabled_vehicle";
    public static final String INCIDENT_LANE_RESTRICTION = "lane_restriction";
    public static final String INCIDENT_MASS_TRANSIT = "mass_transit";
    public static final String INCIDENT_MISCELLANEOUS = "miscellaneous";
    public static final String INCIDENT_OTHER_NEWS = "other_news";
    public static final String INCIDENT_PLANNED_EVENT = "planned_event";
    public static final String INCIDENT_ROAD_CLOSURE = "road_closure";
    public static final String INCIDENT_ROAD_HAZARD = "road_hazard";
    public static final String INCIDENT_WEATHER = "weather";
    public static final String IMPACT_UNKNOWN = "unknown";
    public static final String IMPACT_CRITICAL = "critical";
    public static final String IMPACT_MAJOR = "major";
    public static final String IMPACT_MINOR = "minor";
    public static final String IMPACT_LOW = "low";

    @NonNull
    public abstract String id();

    @Nullable
    public abstract String type();

    @Nullable
    public abstract Boolean closed();

    @Nullable
    public abstract Congestion congestion();

    @Nullable
    public abstract String description();

    @SerializedName(value="long_description")
    @Nullable
    public abstract String longDescription();

    @Nullable
    public abstract String impact();

    @SerializedName(value="sub_type")
    @Nullable
    public abstract String subType();

    @SerializedName(value="sub_type_description")
    @Nullable
    public abstract String subTypeDescription();

    @SerializedName(value="alertc_codes")
    @Nullable
    public abstract List<Integer> alertcCodes();

    @SerializedName(value="geometry_index_start")
    @Nullable
    public abstract Integer geometryIndexStart();

    @SerializedName(value="geometry_index_end")
    @Nullable
    public abstract Integer geometryIndexEnd();

    @SerializedName(value="creation_time")
    @Nullable
    public abstract String creationTime();

    @SerializedName(value="start_time")
    @Nullable
    public abstract String startTime();

    @SerializedName(value="end_time")
    @Nullable
    public abstract String endTime();

    public static Builder builder() {
        return new $AutoValue_Incident.Builder();
    }

    public abstract Builder toBuilder();

    public static TypeAdapter<Incident> typeAdapter(Gson gson) {
        return new AutoValue_Incident.GsonTypeAdapter(gson);
    }

    public static Incident fromJson(String json) {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapterFactory(DirectionsAdapterFactory.create());
        return (Incident)gson.create().fromJson(json, Incident.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder id(@NonNull String var1);

        public abstract Builder type(@Nullable String var1);

        public abstract Builder closed(@Nullable Boolean var1);

        public abstract Builder congestion(@Nullable Congestion var1);

        public abstract Builder description(@Nullable String var1);

        public abstract Builder longDescription(@Nullable String var1);

        public abstract Builder impact(@Nullable String var1);

        public abstract Builder subType(@Nullable String var1);

        public abstract Builder subTypeDescription(@Nullable String var1);

        public abstract Builder alertcCodes(@Nullable List<Integer> var1);

        public abstract Builder geometryIndexStart(@Nullable Integer var1);

        public abstract Builder geometryIndexEnd(@Nullable Integer var1);

        public abstract Builder creationTime(@Nullable String var1);

        public abstract Builder startTime(@Nullable String var1);

        public abstract Builder endTime(@Nullable String var1);

        public abstract Incident build();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ImpactType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IncidentType {
    }
}

