package com.mapbox.android.accounts.navigation.sku.v1;

import android.support.annotation.Keep;

/**
 * The interface exposes the methods to allow different implementations of SKU token generation
 * and rotatio logic.
 */
public interface SkuGenerator {
    /**
     * Generates the SKU token
     * @return the SKU token
     */
    @Keep
    String generateToken();

    /**
     * Reports about the navigation start event
     */
    @Keep
    void onNavigationStart();

    /**
     * Reports about the navigation stop event
     */
    @Keep
    void onNavigationEnd();
}
