/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.commons.geojson.custom;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mapbox.services.commons.models.Position;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class PositionSerializer
implements JsonSerializer<Position> {
    public JsonElement serialize(Position src, Type typeOfSrc, JsonSerializationContext context) {
        JsonArray rawCoordinates = new JsonArray();
        BigDecimal lat = new BigDecimal(src.getLatitude());
        lat = lat.setScale(7, RoundingMode.HALF_UP).stripTrailingZeros();
        BigDecimal lon = new BigDecimal(src.getLongitude());
        lon = lon.setScale(7, RoundingMode.HALF_UP).stripTrailingZeros();
        rawCoordinates.add((JsonElement)new JsonPrimitive((Number)lon));
        rawCoordinates.add((JsonElement)new JsonPrimitive((Number)lat));
        if (src.hasAltitude()) {
            rawCoordinates.add((JsonElement)new JsonPrimitive((Number)src.getAltitude()));
        }
        return rawCoordinates;
    }
}

